{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetPosition: TVector3;
    procedure SetPosition(const Value: TVector3);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdPosition: TSFVec3f;
    { Internal wrapper for property @link(Position). This wrapper API may change, we advise to access simpler @link(Position) instead. }
    public property FdPosition: TSFVec3f read FFdPosition;
    {  }
    property Position: TVector3 read GetPosition write SetPosition;

{$endif read_interface}

{$ifdef read_implementation}

{ TExplosionEmitterNode ----------------------------------------------- }

function TExplosionEmitterNode.GetPosition: TVector3;
begin
  Result := FdPosition.Value;
end;

procedure TExplosionEmitterNode.SetPosition(const Value: TVector3);
begin
  FdPosition.Send(Value);
end;

class function TExplosionEmitterNode.ClassX3DType: String;
begin
  Result := 'ExplosionEmitter';
end;

procedure TExplosionEmitterNode.CreateNode;
begin
  inherited;

  FFdPosition := TSFVec3f.Create(Self, True, 'position', Vector3(0, 0, 0));
   FdPosition.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPosition);
end;

{$endif read_implementation}
