{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetAddress: String;
    procedure SetAddress(const Value: String);
    function GetApplicationID: Integer;
    procedure SetApplicationID(const Value: Integer);
    function GetEntityID: Integer;
    procedure SetEntityID(const Value: Integer);
    function GetMulticastRelayHost: String;
    procedure SetMulticastRelayHost(const Value: String);
    function GetMulticastRelayPort: Integer;
    procedure SetMulticastRelayPort(const Value: Integer);
    function GetNetworkMode: TDISNetworkMode;
    procedure SetNetworkMode(const Value: TDISNetworkMode);
    function GetPort: Integer;
    procedure SetPort(const Value: Integer);
    function GetRadioID: Integer;
    procedure SetRadioID(const Value: Integer);
    function GetReadInterval: Single;
    procedure SetReadInterval(const Value: Single);
    function GetReceivedPower: Single;
    procedure SetReceivedPower(const Value: Single);
    function GetReceiverState: Integer;
    procedure SetReceiverState(const Value: Integer);
    function GetRtpHeaderExpected: Boolean;
    procedure SetRtpHeaderExpected(const Value: Boolean);
    function GetSiteID: Integer;
    procedure SetSiteID(const Value: Integer);
    function GetTransmitterApplicationID: Integer;
    procedure SetTransmitterApplicationID(const Value: Integer);
    function GetTransmitterEntityID: Integer;
    procedure SetTransmitterEntityID(const Value: Integer);
    function GetTransmitterRadioID: Integer;
    procedure SetTransmitterRadioID(const Value: Integer);
    function GetTransmitterSiteID: Integer;
    procedure SetTransmitterSiteID(const Value: Integer);
    function GetWhichGeometry: Integer;
    procedure SetWhichGeometry(const Value: Integer);
    function GetWriteInterval: Single;
    procedure SetWriteInterval(const Value: Single);
    function GetBBox: TBox3D;
    procedure SetBBox(const Value: TBox3D);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdAddress: TSFString;
    { Internal wrapper for property @link(Address). This wrapper API may change, we advise to access simpler @link(Address) instead. }
    public property FdAddress: TSFString read FFdAddress;
    {  }
    property Address: String read GetAddress write SetAddress;

    strict private FFdApplicationID: TSFInt32;
    { Internal wrapper for property @link(ApplicationID). This wrapper API may change, we advise to access simpler @link(ApplicationID) instead. }
    public property FdApplicationID: TSFInt32 read FFdApplicationID;
    {  }
    property ApplicationID: Integer read GetApplicationID write SetApplicationID;

    strict private FFdEntityID: TSFInt32;
    { Internal wrapper for property @link(EntityID). This wrapper API may change, we advise to access simpler @link(EntityID) instead. }
    public property FdEntityID: TSFInt32 read FFdEntityID;
    {  }
    property EntityID: Integer read GetEntityID write SetEntityID;

    strict private FFdMulticastRelayHost: TSFString;
    { Internal wrapper for property @link(MulticastRelayHost). This wrapper API may change, we advise to access simpler @link(MulticastRelayHost) instead. }
    public property FdMulticastRelayHost: TSFString read FFdMulticastRelayHost;
    {  }
    property MulticastRelayHost: String read GetMulticastRelayHost write SetMulticastRelayHost;

    strict private FFdMulticastRelayPort: TSFInt32;
    { Internal wrapper for property @link(MulticastRelayPort). This wrapper API may change, we advise to access simpler @link(MulticastRelayPort) instead. }
    public property FdMulticastRelayPort: TSFInt32 read FFdMulticastRelayPort;
    {  }
    property MulticastRelayPort: Integer read GetMulticastRelayPort write SetMulticastRelayPort;

    strict private FFdNetworkMode: TSFStringEnum;
    { Internal wrapper for property @link(NetworkMode). This wrapper API may change, we advise to access simpler @link(NetworkMode) instead. }
    public property FdNetworkMode: TSFStringEnum read FFdNetworkMode;
    {  }
    property NetworkMode: TDISNetworkMode read GetNetworkMode write SetNetworkMode;

    strict private FFdPort: TSFInt32;
    { Internal wrapper for property @link(Port). This wrapper API may change, we advise to access simpler @link(Port) instead. }
    public property FdPort: TSFInt32 read FFdPort;
    {  }
    property Port: Integer read GetPort write SetPort;

    strict private FFdRadioID: TSFInt32;
    { Internal wrapper for property @link(RadioID). This wrapper API may change, we advise to access simpler @link(RadioID) instead. }
    public property FdRadioID: TSFInt32 read FFdRadioID;
    {  }
    property RadioID: Integer read GetRadioID write SetRadioID;

    strict private FFdReadInterval: TSFFloat;
    { Internal wrapper for property @link(ReadInterval). This wrapper API may change, we advise to access simpler @link(ReadInterval) instead. }
    public property FdReadInterval: TSFFloat read FFdReadInterval;
    {  }
    property ReadInterval: Single read GetReadInterval write SetReadInterval;

    strict private FFdReceivedPower: TSFFloat;
    { Internal wrapper for property @link(ReceivedPower). This wrapper API may change, we advise to access simpler @link(ReceivedPower) instead. }
    public property FdReceivedPower: TSFFloat read FFdReceivedPower;
    {  }
    property ReceivedPower: Single read GetReceivedPower write SetReceivedPower;

    strict private FFdReceiverState: TSFInt32;
    { Internal wrapper for property @link(ReceiverState). This wrapper API may change, we advise to access simpler @link(ReceiverState) instead. }
    public property FdReceiverState: TSFInt32 read FFdReceiverState;
    {  }
    property ReceiverState: Integer read GetReceiverState write SetReceiverState;

    strict private FFdRtpHeaderExpected: TSFBool;
    { Internal wrapper for property @link(RtpHeaderExpected). This wrapper API may change, we advise to access simpler @link(RtpHeaderExpected) instead. }
    public property FdRtpHeaderExpected: TSFBool read FFdRtpHeaderExpected;
    {  }
    property RtpHeaderExpected: Boolean read GetRtpHeaderExpected write SetRtpHeaderExpected;

    strict private FFdSiteID: TSFInt32;
    { Internal wrapper for property @link(SiteID). This wrapper API may change, we advise to access simpler @link(SiteID) instead. }
    public property FdSiteID: TSFInt32 read FFdSiteID;
    {  }
    property SiteID: Integer read GetSiteID write SetSiteID;

    strict private FFdTransmitterApplicationID: TSFInt32;
    { Internal wrapper for property @link(TransmitterApplicationID). This wrapper API may change, we advise to access simpler @link(TransmitterApplicationID) instead. }
    public property FdTransmitterApplicationID: TSFInt32 read FFdTransmitterApplicationID;
    {  }
    property TransmitterApplicationID: Integer read GetTransmitterApplicationID write SetTransmitterApplicationID;

    strict private FFdTransmitterEntityID: TSFInt32;
    { Internal wrapper for property @link(TransmitterEntityID). This wrapper API may change, we advise to access simpler @link(TransmitterEntityID) instead. }
    public property FdTransmitterEntityID: TSFInt32 read FFdTransmitterEntityID;
    {  }
    property TransmitterEntityID: Integer read GetTransmitterEntityID write SetTransmitterEntityID;

    strict private FFdTransmitterRadioID: TSFInt32;
    { Internal wrapper for property @link(TransmitterRadioID). This wrapper API may change, we advise to access simpler @link(TransmitterRadioID) instead. }
    public property FdTransmitterRadioID: TSFInt32 read FFdTransmitterRadioID;
    {  }
    property TransmitterRadioID: Integer read GetTransmitterRadioID write SetTransmitterRadioID;

    strict private FFdTransmitterSiteID: TSFInt32;
    { Internal wrapper for property @link(TransmitterSiteID). This wrapper API may change, we advise to access simpler @link(TransmitterSiteID) instead. }
    public property FdTransmitterSiteID: TSFInt32 read FFdTransmitterSiteID;
    {  }
    property TransmitterSiteID: Integer read GetTransmitterSiteID write SetTransmitterSiteID;

    strict private FFdWhichGeometry: TSFInt32;
    { Internal wrapper for property @link(WhichGeometry). This wrapper API may change, we advise to access simpler @link(WhichGeometry) instead. }
    public property FdWhichGeometry: TSFInt32 read FFdWhichGeometry;
    {  }
    property WhichGeometry: Integer read GetWhichGeometry write SetWhichGeometry;

    strict private FFdWriteInterval: TSFFloat;
    { Internal wrapper for property @link(WriteInterval). This wrapper API may change, we advise to access simpler @link(WriteInterval) instead. }
    public property FdWriteInterval: TSFFloat read FFdWriteInterval;
    {  }
    property WriteInterval: Single read GetWriteInterval write SetWriteInterval;

    strict private FEventIsNetworkReader: TSFBoolEvent;
    {  }
    public property EventIsNetworkReader: TSFBoolEvent read FEventIsNetworkReader;

    strict private FEventIsNetworkWriter: TSFBoolEvent;
    {  }
    public property EventIsNetworkWriter: TSFBoolEvent read FEventIsNetworkWriter;

    strict private FEventIsRtpHeaderHeard: TSFBoolEvent;
    {  }
    public property EventIsRtpHeaderHeard: TSFBoolEvent read FEventIsRtpHeaderHeard;

    strict private FEventIsStandAlone: TSFBoolEvent;
    {  }
    public property EventIsStandAlone: TSFBoolEvent read FEventIsStandAlone;

    strict private FEventTimestamp: TSFTimeEvent;
    {  }
    public property EventTimestamp: TSFTimeEvent read FEventTimestamp;

    strict private FFdBboxCenter: TSFVec3f;
    { Internal wrapper for property @link(BboxCenter). This wrapper API may change, we advise to access simpler @link(BboxCenter) instead. }
    public property FdBboxCenter: TSFVec3f read FFdBboxCenter;
    {  }
    property BBox: TBox3D read GetBBox write SetBBox;

    strict private FFdBboxSize: TSFVec3f;
    { Internal wrapper for property @link(BboxSize). This wrapper API may change, we advise to access simpler @link(BboxSize) instead. }
    public property FdBboxSize: TSFVec3f read FFdBboxSize;

{$endif read_interface}

{$ifdef read_implementation}

{ TReceiverPduNode ----------------------------------------------- }

function TReceiverPduNode.GetAddress: String;
begin
  Result := FdAddress.Value;
end;

procedure TReceiverPduNode.SetAddress(const Value: String);
begin
  FdAddress.Send(Value);
end;

function TReceiverPduNode.GetApplicationID: Integer;
begin
  Result := FdApplicationID.Value;
end;

procedure TReceiverPduNode.SetApplicationID(const Value: Integer);
begin
  FdApplicationID.Send(Value);
end;

function TReceiverPduNode.GetEntityID: Integer;
begin
  Result := FdEntityID.Value;
end;

procedure TReceiverPduNode.SetEntityID(const Value: Integer);
begin
  FdEntityID.Send(Value);
end;

function TReceiverPduNode.GetMulticastRelayHost: String;
begin
  Result := FdMulticastRelayHost.Value;
end;

procedure TReceiverPduNode.SetMulticastRelayHost(const Value: String);
begin
  FdMulticastRelayHost.Send(Value);
end;

function TReceiverPduNode.GetMulticastRelayPort: Integer;
begin
  Result := FdMulticastRelayPort.Value;
end;

procedure TReceiverPduNode.SetMulticastRelayPort(const Value: Integer);
begin
  FdMulticastRelayPort.Send(Value);
end;

function TReceiverPduNode.GetNetworkMode: TDISNetworkMode;
begin
  Result := TDISNetworkMode(FdNetworkMode.EnumValue);
end;

procedure TReceiverPduNode.SetNetworkMode(const Value: TDISNetworkMode);
begin
  FdNetworkMode.SendEnumValue(Ord(Value));
end;

function TReceiverPduNode.GetPort: Integer;
begin
  Result := FdPort.Value;
end;

procedure TReceiverPduNode.SetPort(const Value: Integer);
begin
  FdPort.Send(Value);
end;

function TReceiverPduNode.GetRadioID: Integer;
begin
  Result := FdRadioID.Value;
end;

procedure TReceiverPduNode.SetRadioID(const Value: Integer);
begin
  FdRadioID.Send(Value);
end;

function TReceiverPduNode.GetReadInterval: Single;
begin
  Result := FdReadInterval.Value;
end;

procedure TReceiverPduNode.SetReadInterval(const Value: Single);
begin
  FdReadInterval.Send(Value);
end;

function TReceiverPduNode.GetReceivedPower: Single;
begin
  Result := FdReceivedPower.Value;
end;

procedure TReceiverPduNode.SetReceivedPower(const Value: Single);
begin
  FdReceivedPower.Send(Value);
end;

function TReceiverPduNode.GetReceiverState: Integer;
begin
  Result := FdReceiverState.Value;
end;

procedure TReceiverPduNode.SetReceiverState(const Value: Integer);
begin
  FdReceiverState.Send(Value);
end;

function TReceiverPduNode.GetRtpHeaderExpected: Boolean;
begin
  Result := FdRtpHeaderExpected.Value;
end;

procedure TReceiverPduNode.SetRtpHeaderExpected(const Value: Boolean);
begin
  FdRtpHeaderExpected.Send(Value);
end;

function TReceiverPduNode.GetSiteID: Integer;
begin
  Result := FdSiteID.Value;
end;

procedure TReceiverPduNode.SetSiteID(const Value: Integer);
begin
  FdSiteID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterApplicationID: Integer;
begin
  Result := FdTransmitterApplicationID.Value;
end;

procedure TReceiverPduNode.SetTransmitterApplicationID(const Value: Integer);
begin
  FdTransmitterApplicationID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterEntityID: Integer;
begin
  Result := FdTransmitterEntityID.Value;
end;

procedure TReceiverPduNode.SetTransmitterEntityID(const Value: Integer);
begin
  FdTransmitterEntityID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterRadioID: Integer;
begin
  Result := FdTransmitterRadioID.Value;
end;

procedure TReceiverPduNode.SetTransmitterRadioID(const Value: Integer);
begin
  FdTransmitterRadioID.Send(Value);
end;

function TReceiverPduNode.GetTransmitterSiteID: Integer;
begin
  Result := FdTransmitterSiteID.Value;
end;

procedure TReceiverPduNode.SetTransmitterSiteID(const Value: Integer);
begin
  FdTransmitterSiteID.Send(Value);
end;

function TReceiverPduNode.GetWhichGeometry: Integer;
begin
  Result := FdWhichGeometry.Value;
end;

procedure TReceiverPduNode.SetWhichGeometry(const Value: Integer);
begin
  FdWhichGeometry.Send(Value);
end;

function TReceiverPduNode.GetWriteInterval: Single;
begin
  Result := FdWriteInterval.Value;
end;

procedure TReceiverPduNode.SetWriteInterval(const Value: Single);
begin
  FdWriteInterval.Send(Value);
end;

function TReceiverPduNode.GetBBox: TBox3D;
begin
  Result := TBox3D.FromCenterSize(FdBBoxCenter.Value, FdBBoxSize.Value);
end;

procedure TReceiverPduNode.SetBBox(const Value: TBox3D);
var
  ValueCenter, ValueSize: TVector3;
begin
  Value.ToCenterSize(ValueCenter, ValueSize);
  FdBBoxCenter.Send(ValueCenter);
  FdBBoxSize.Send(ValueSize);
end;

class function TReceiverPduNode.ClassX3DType: String;
begin
  Result := 'ReceiverPdu';
end;

procedure TReceiverPduNode.CreateNode;
begin
  inherited;

  FFdAddress := TSFString.Create(Self, True, 'address', 'localhost');
   FdAddress.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdAddress);

  FFdApplicationID := TSFInt32.Create(Self, True, 'applicationID', 1);
   FdApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdApplicationID);

  FFdEntityID := TSFInt32.Create(Self, True, 'entityID', 0);
   FdEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdEntityID);

  FFdMulticastRelayHost := TSFString.Create(Self, True, 'multicastRelayHost', '');
   FdMulticastRelayHost.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayHost);

  FFdMulticastRelayPort := TSFInt32.Create(Self, True, 'multicastRelayPort', 0);
   FdMulticastRelayPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdMulticastRelayPort);

  FFdNetworkMode := TSFStringEnum.Create(Self, True, 'networkMode', @DISNetworkModeNames, Ord(High(DISNetworkModeNames)) + 1, Ord(nmStandAlone));
   FdNetworkMode.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdNetworkMode);

  FFdPort := TSFInt32.Create(Self, True, 'port', 0);
   FdPort.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdPort);

  FFdRadioID := TSFInt32.Create(Self, True, 'radioID', 0);
   FdRadioID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRadioID);

  FFdReadInterval := TSFFloat.Create(Self, True, 'readInterval', 0.1);
   FdReadInterval.ChangeAlways := chVisibleNonGeometry;
   FdReadInterval.MustBeNonnegative := true;
  AddField(FFdReadInterval);

  FFdReceivedPower := TSFFloat.Create(Self, True, 'receivedPower', 0.0);
   FdReceivedPower.ChangeAlways := chVisibleNonGeometry;
   FdReceivedPower.MustBeNonnegative := true;
  AddField(FFdReceivedPower);

  FFdReceiverState := TSFInt32.Create(Self, True, 'receiverState', 0);
   FdReceiverState.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdReceiverState);

  FFdRtpHeaderExpected := TSFBool.Create(Self, True, 'rtpHeaderExpected', false);
   FdRtpHeaderExpected.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdRtpHeaderExpected);

  FFdSiteID := TSFInt32.Create(Self, True, 'siteID', 0);
   FdSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdSiteID);

  FFdTransmitterApplicationID := TSFInt32.Create(Self, True, 'transmitterApplicationID', 1);
   FdTransmitterApplicationID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmitterApplicationID);

  FFdTransmitterEntityID := TSFInt32.Create(Self, True, 'transmitterEntityID', 0);
   FdTransmitterEntityID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmitterEntityID);

  FFdTransmitterRadioID := TSFInt32.Create(Self, True, 'transmitterRadioID', 0);
   FdTransmitterRadioID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmitterRadioID);

  FFdTransmitterSiteID := TSFInt32.Create(Self, True, 'transmitterSiteID', 0);
   FdTransmitterSiteID.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdTransmitterSiteID);

  FFdWhichGeometry := TSFInt32.Create(Self, True, 'whichGeometry', 1);
   FdWhichGeometry.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdWhichGeometry);

  FFdWriteInterval := TSFFloat.Create(Self, True, 'writeInterval', 1.0);
   FdWriteInterval.ChangeAlways := chVisibleNonGeometry;
   FdWriteInterval.MustBeNonnegative := true;
  AddField(FFdWriteInterval);

  FEventIsNetworkReader := TSFBoolEvent.Create(Self, 'isNetworkReader', false);
  AddEvent(FEventIsNetworkReader);

  FEventIsNetworkWriter := TSFBoolEvent.Create(Self, 'isNetworkWriter', false);
  AddEvent(FEventIsNetworkWriter);

  FEventIsRtpHeaderHeard := TSFBoolEvent.Create(Self, 'isRtpHeaderHeard', false);
  AddEvent(FEventIsRtpHeaderHeard);

  FEventIsStandAlone := TSFBoolEvent.Create(Self, 'isStandAlone', false);
  AddEvent(FEventIsStandAlone);

  FEventTimestamp := TSFTimeEvent.Create(Self, 'timestamp', false);
  AddEvent(FEventTimestamp);

  FFdBboxCenter := TSFVec3f.Create(Self, False, 'bboxCenter', Vector3(0, 0, 0));
   FdBboxCenter.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxCenter);

  FFdBboxSize := TSFVec3f.Create(Self, False, 'bboxSize', Vector3(-1, -1, -1));
   FdBboxSize.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdBboxSize);
end;

{$endif read_implementation}
