/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifdef BL_LANG_FORT
#  define FORT_INITSIGMA    initsigma
#  define FORT_COARSIGMA    coarsigma
#  define FORT_RHSMAC       rhsmac
#  define FORT_RESIDUAL     resmac
#  define FORT_RELAX        relaxmac
#  define FORT_RESTRICT     coarsres
#  define FORT_INTERPOLATE  interp
#  define FORT_PROJUMAC     projumac
#  define FORT_SOLVEMAC     solvemac
#  define FORT_MKSUMMAC     mksummac
#else
#if defined(BL_FORT_USE_UNDERSCORE)
#  define FORT_INITSIGMA    initsigma_
#  define FORT_COARSIGMA    coarsigma_
#  define FORT_RHSMAC       rhsmac_
#  define FORT_RESIDUAL     resmac_
#  define FORT_RELAX        relaxmac_
#  define FORT_RESTRICT     coarsres_
#  define FORT_INTERPOLATE  interp_
#  define FORT_PROJUMAC     projumac_
#  define FORT_SOLVEMAC     solvemac_
#  define FORT_MKSUMMAC     mksummac_
#elif defined(BL_FORT_USE_UPPERCASE)
#  define FORT_INITSIGMA    INITSIGMA
#  define FORT_COARSIGMA    COARSIGMA
#  define FORT_RHSMAC       RHSMAC
#  define FORT_RESIDUAL     RESMAC
#  define FORT_RELAX        RELAXMAC
#  define FORT_RESTRICT     COARSRES
#  define FORT_INTERPOLATE  INTERP
#  define FORT_PROJUMAC     PROJUMAC
#  define FORT_SOLVEMAC     SOLVEMAC
#  define FORT_MKSUMMAC     MKSUMMAC
#elif defined(BL_FORT_USE_LOWERCASE)
#  define FORT_INITSIGMA    initsigma
#  define FORT_COARSIGMA    coarsigma
#  define FORT_RHSMAC       rhsmac
#  define FORT_RESIDUAL     resmac
#  define FORT_RELAX        relaxmac
#  define FORT_RESTRICT     coarsres
#  define FORT_INTERPOLATE  interp
#  define FORT_PROJUMAC     projumac
#  define FORT_SOLVEMAC     solvemac
#  define FORT_MKSUMMAC     mksummac
#endif

#include <ArrayLim.H>

extern "C" {

#if (BL_SPACEDIM == 2)

  void FORT_INITSIGMA(Real * sigmax, Real * sigmay, 
                      Real * rho, 
                      const Real * areax, const Real * areay, 
                      ARLIM_P(lo), ARLIM_P(hi),
                      int * bc, int * ng);

  void FORT_RHSMAC(Real * uhalfx, Real * uhalfy, 
                   Real * divu_src, 
                   Real * rhs, const Real * areax, const Real * areay, 
                   const Real * vol,
                   ARLIM_P(lo), ARLIM_P(hi),
                   Real * rhsnorm, int * ng);

  void FORT_RESIDUAL(Real * resid, Real * phi, Real * f, 
                     Real * sigmax, Real * sigmay, 
                     ARLIM_P(lo), ARLIM_P(hi),
                     const Real * dx, Real * rnorm, int * bc, int * ng);

  void FORT_COARSIGMA(Real * sigmax , Real * sigmay,
                      Real * sigmaxc, Real * sigmayc,
                      ARLIM_P(lo ), ARLIM_P(hi ),
                      ARLIM_P(loc), ARLIM_P(hic), int * ng);

  void FORT_RESTRICT(Real * res   , Real * crse_res,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     ARLIM_P(loc), ARLIM_P(hic), int * nextra);

  void FORT_INTERPOLATE(Real * phi, Real * deltac, 
                        ARLIM_P(lo ), ARLIM_P(hi ),
                        ARLIM_P(loc), ARLIM_P(hic), int * ng);

  void FORT_RELAX(Real * phi, Real * f, 
                  Real * sigmax, Real * sigmay,
                  ARLIM_P(lo ), ARLIM_P(hi ),
	          const Real * dx, int * bc, int * nnrelax, int * ng);

  void FORT_PROJUMAC(Real * uhalfx, Real * uhalfy, 
                     Real * sigmax, Real * sigmay,
                     Real * phi,
                     const Real * areax, const Real * areay,
                     const Real * dx,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     int * bc, const int * is_rz, int * ng);

  void FORT_SOLVEMAC(Real * dest, Real * dest0, Real *source, 
                     Real * sigmax,  Real * sigmay,
                     Real * sum,  
                     Real * r, Real * w, Real * z, Real * work,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     const Real * dx,  int * bc, Real * norm, 
                     Real * prob_norm, int * ng);

  void FORT_MKSUMMAC(Real * sum,
                     Real * sigmax,  Real * sigmay,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     const Real * dx, int * ng);

#elif (BL_SPACEDIM == 3)

  void FORT_INITSIGMA(Real * sigmax, Real * sigmay, Real * sigmaz, 
                      Real * rho, 
                      const Real * areax, const Real * areay, const Real * areaz,
                      ARLIM_P(lo), ARLIM_P(hi),
                      int * bc, int * ng);

  void FORT_RHSMAC(Real * uhalfx, Real * uhalfy, Real * uhalfz,
                   Real * divu_src, Real * rhs, 
                   const Real * areax, const Real * areay, const Real * areaz,
                   const Real * vol,
                   ARLIM_P(lo), ARLIM_P(hi),
                   Real * rhsnorm, int * ng);

  void FORT_RESIDUAL(Real * resid, Real * phi, Real * f, 
                     Real * sigmax, Real * sigmay, Real * sigmaz,
                     ARLIM_P(lo), ARLIM_P(hi),
                     const Real * dx, Real * rnorm, int * bc, int * ng);

  void FORT_COARSIGMA(Real * sigmax , Real * sigmay , Real * sigmaz,
                      Real * sigmaxc, Real * sigmayc, Real * sigmazc,
                      ARLIM_P(lo ), ARLIM_P(hi ),
                      ARLIM_P(loc), ARLIM_P(hic), int * ng);

  void FORT_RESTRICT(Real * res   , Real * crse_res,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     ARLIM_P(loc), ARLIM_P(hic), int * nextra);

  void FORT_INTERPOLATE(Real * phi, Real * deltac, 
                        ARLIM_P(lo ), ARLIM_P(hi ),
                        ARLIM_P(loc), ARLIM_P(hic), int * ng);

  void FORT_RELAX(Real * phi, Real * f, 
                  Real * sigmax, Real * sigmay, Real * sigmaz,
                  ARLIM_P(lo ), ARLIM_P(hi ),
	          const Real * dx, int * bc, int * nnrelax, int * ng);

  void FORT_PROJUMAC(Real * uhalfx, Real * uhalfy, Real * uhalfz,
                     Real * sigmax, Real * sigmay, Real * sigmaz,
                     Real * phi,
                     const Real * areax, const Real * areay, const Real * areaz,
                     const Real * dx,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     int * bc, int * ng);

  void FORT_SOLVEMAC(Real * dest, Real * dest0, Real *source, 
                     Real * sigmax,  Real * sigmay,
                     Real * sigmaz,  
                     Real * sum,  
                     Real * r, Real * w, Real * z, Real * work,
                     ARLIM_P(lo ), ARLIM_P(hi ),
                     const Real * dx,  int * bc, Real * norm, 
                     Real * prob_norm, int * ng);

  void FORT_MKSUMMAC(Real * sum,
                     Real * sigmax,  Real * sigmay, Real * sigmaz, 
                     ARLIM_P(lo), ARLIM_P(hi), const Real * dx, int * ng);
#endif
};
#endif
