(*:Name: Component *)

(* :Title: Component *)

(* :Author: Tom Wickham-Jones*)

(* :Summary: *)

(* :Context: ExtendGraphics`Component` *)

(* :Package Version: 1.0 *)

(* :Mathematica Version: 2.3 *)


(* :History:
	Created winter 1993 by Tom Wickham-Jones.
*)

(*:Warnings:
	This package requires V2.3 to run.
*)


BeginPackage[ "ExtendGraphics`ComponentPlot`", "Utilities`FilterOptions`"]

ComponentGraphics::usage = 
	"ComponentGraphics plots a triangular diagram."

ComponentListPlot::usage = "ComponentListPlot[ pts] will take a list 
	of triples.  Each point of the form {x, y, z} represents a mixture
	of three components such that x+y+z == 1 and each lies between
	0 and 1."


GridStyle::usage = "GridStyle is an option of ComponentListPlot
	which specifies the style in which the triangular grid will
	be drawn."

Begin["`Private`"]

ComponentGraphics::baddata = 
	"The data point `1` does not consist of three components
	 which sum to 1 and each lie between 0 and 1 inclusive."


Options[ ComponentGraphics] = 
	Join[ Options[ Graphics], 
			{
			Grid -> False,
			GridStyle -> {AbsoluteThickness[ 0.1], AbsoluteDashing[{2}]}
			}]

SetOptions[ ComponentGraphics, AspectRatio -> Automatic];
SetOptions[ ComponentGraphics, PlotRange -> All];
SetOptions[ ComponentGraphics, AxesStyle -> {}];

Options[ ComponentListPlot] = 
	Join[ Options[ ComponentGraphics],
			{
			PlotStyle -> AbsolutePointSize[ 3]
			}]

SetOptions[ ComponentListPlot, Grid -> Automatic];
SetOptions[ ComponentListPlot, AspectRatio -> Automatic];
SetOptions[ ComponentListPlot, PlotRange -> All];
SetOptions[ ComponentListPlot, AxesStyle -> {}];

SizeQ[ d_] :=
	If[ 0 <= d && d <= 1, True, False]

(*
ConvertCoordinates[ {h_, k_, l_}] :=
		If[ N[ h+k+l] === 1. && SizeQ[ h] && SizeQ[ k] && SizeQ[ l],
			{k/2 + l, k Tan[Pi/3]/2},
			Message[ ComponentListPlot::baddata, {h,k,l}];
			{0,0}]
			
c[ p_] := ExtendGraphics`ComponentPlot
*)
ConvertCoordinates[ {h_, k_, l_}] :=
		If[ N[ h+k+l] === 1. && SizeQ[ h] && SizeQ[ k] && SizeQ[ l],
			{h/2 + l, h Tan[Pi/3]/2},
			Message[ ComponentListPlot::baddata, {h,k,l}];
			{0,0}]

ConvertCoordinates[ Offset[ off_, pt_]] :=
	Offset[ off, ConvertCoordinates[ pt]]

ConvertCoordinates[ pt_] :=
	(Message[ ComponentListPlot::baddata, pt]; {0,0})

BuildPrimitives[ Point[ pt_]] :=
	Point[ ConvertCoordinates[ pt]]

BuildPrimitives[ Text[ t_, pt_, stuff___]] :=
	Text[ t, ConvertCoordinates[ pt], stuff]

BuildPrimitives[ Line[ l_List]] :=
	Line[ Map[ ConvertCoordinates, l]]

BuildPrimitives[ Polygon[ l_List]] :=
	Polygon[ Map[ ConvertCoordinates, l]]

BuildPrimitives[ l_List] :=
	Map[ BuildPrimitives, l]

BuildPrimitives[ obj_] :=
	obj

JoinStyle[ style_, prims_] :=
	If[ style === Automatic, prims, Join[ Flatten[ {style}], prims]]

ComponentListPlot[ data_List, opts___] :=
	Block[{style},
		style = PlotStyle /. Join[ {opts}, Options[ ComponentListPlot]] ;
		Show[ ComponentGraphics[ {style, Map[ Point, data]}, opts]]
		]

ComponentGraphics[ prims_, opts___] :=
	Block[{ndata, axes, grid, gstyle, axstyle, opt, nprims},
		opt = Join[ {opts}, Options[ ComponentGraphics]] ;
		axstyle = AxesStyle /. opt ;
		grid    = Grid /. opt ;
		gstyle  = GridStyle /. opt ;
		nprims  = BuildPrimitives[ prims] ;
		axes = JoinStyle[ axstyle, TriangularAxes[]] ;		
		grid = If[ grid === Automatic,
					JoinStyle[ gstyle, Map[ Grid, Range[0.1,0.9,0.1]]], {}] ;		
		Graphics[ {axes, nprims, grid}, 
			FilterOptions[ Graphics, Sequence @@ opt]]
		]



TriangularAxes[ ] :=
	Block[
			{ 
			a = {1,0,0}, 
			b = {0,0,1},
			c = {0,1,0},
			text
			},
		text = {
				Text[ "A", ConvertCoordinates[a], {0, -1.5}],
				Text[ "B", ConvertCoordinates[b], {-1.5,0}],
				Text[ "C", ConvertCoordinates[c], {1.5,0}]
				} ;
		{ text, Line[ Map[ ConvertCoordinates, {a,b,c,a}]]}
		]

	
Grid[ a_] :=
	Block[{b, pos},
		b = 1-a ;
		pos = {
				{{a,b,0}, {0,b,a}},
				{{a,b,0}, {a,0,b}},
				{{a,0,b}, {0,a,b}}
				} ;
		Map[ Line, Map[ ConvertCoordinates, pos, {2}]]
		]


End[]

EndPackage[]

(*


<<Component.m

ComponentListPlot[ {{0.15,0.24,0.61}, {0.2, 0.6, 0.2}, {0.4, 0.2, 0.4}}]

ComponentListPlot[ 
	{
	Line[{{0.15,0.24,0.61}, {0.2, 0.6, 0.2}, 
	      {0.4, 0.2,0.4},{0.15,0.24,0.61}}]
	 }]

rndpt := {a=Random[], b = Random[Real, {0,1-a}], 1-a-b}

ComponentListPlot[ Table[ rndpt, {10}]]


ComponentListPlot[ 
	{
	Line[{{0.15,0.24,0.61}, {0.2, 0.6, 0.2}, 
	      {0.4, 0.2,0.4},{0.15,0.24,0.61}}],
	GrayLevel[ 0.5], Polygon[ {rndpt, rndpt, rndpt}]
	 }]


*)

