#include <vector>
#include <iostream>
#include <iostream>
#include "modules.h"
#include "cdo_output.h"

static int errState = 0;

std::string
parseArg(std::string oper)
{
  if (oper == "")
    {
      printf("cdo apply: no operator given for apply.\n");
      errState = -1;
    }
  auto mod = getModule(get_original(oper.c_str()));
  if (mod.streamInCnt != 1)
    {
      printf("cdo apply: operator %s can not be used with apply.\n", oper.c_str());
      if (mod.streamInCnt == -1) printf("           %s has variable input.\n", oper.c_str());

      if (mod.streamInCnt > 1) printf("           %s has more than one input.\n", oper.c_str());

      if (mod.streamInCnt == 0) printf("           %s has no input.\n", oper.c_str());

      errState = -1;
    }
  return "-" + oper;
}

std::vector<std::string>::iterator
expand(std::string p_oper, std::vector<std::string> &p_result, std::vector<std::string> &p_argv,
       std::vector<std::string>::iterator p_start)
{
  auto argvIter = p_start;
  while (argvIter != p_argv.end() && (*(argvIter))[0] != ']')
    {
      auto currentArg = (*(argvIter));
      if (currentArg[0] == '[')
        {
          printf("cdo apply: brackets not allowed for command apply.\n");
          errState = -1;
          return argvIter;
        }
      if (currentArg[0] == '-')
        {
          printf("cdo apply: operators not allowed for command apply.\n");
          errState = -1;
          return argvIter;
        }
      p_result.push_back(p_oper);
      p_result.push_back(*argvIter);
      ++argvIter;
    }

  if ((*(argvIter))[0] != ']')
    {
      printf("cdo apply: missing closing bracket.\n");
      errState = -1;
    }
  return argvIter;
}

std::vector<std::string>
scan(std::vector<std::string> p_argv)
{
  bool firstIsNotApply = false;
  std::vector<std::string> newArgv;
  for (auto argvIter = p_argv.begin(); argvIter < p_argv.end(); argvIter++)
    {
      std::string currentArgv = *argvIter;
      if (currentArgv.compare(0, 6, "-apply") == 0)
        {
          if (firstIsNotApply == false)
            {
              printf("cdo apply: apply can not be first.\n");
              errState = -1;
              break;
            }
          ++argvIter;
          if ((*(argvIter))[0] == '[')
            {
              size_t pos = 0;
              std::string token = "";
              if ((pos = currentArgv.find(',')) != std::string::npos)
                {
                  token = parseArg(currentArgv.substr(pos + 1));
                  argvIter = expand(token, newArgv, p_argv, ++argvIter);
                }
              else
                {
                  printf("cdo apply: missing argument for apply.\n");
                  errState = -1;
                }
            }
          else
            {
              printf("cdo apply: Missing bracket after apply, apply can only be used with [].\n");
              errState = -1;
            }
        }
      else
        {
          newArgv.push_back(*argvIter);
          firstIsNotApply = true;
        }
    }
  return newArgv;
}
std::vector<std::string>
expandApply(std::vector<std::string> p_argv)
{
  auto result = scan(p_argv);
  if (errState == -1)
    {
      exit(EXIT_FAILURE);
    }
  return result;
}
