#include <gtest/gtest.h>
#include <algorithm>
#include <limits>
#include "lloyds.h"

using namespace std;

template<class T>
ostream &operator<<(ostream &stream, const vector<T> &vec)
{
	for (int i = 0; i < vec.size(); i++) {
		if (i != 0)
			stream << ", ";
		stream << vec[i];
	}
	return stream;
}

/*TEST(Lloyds, Long) {
	double signal[] = {
		-2.23622, -2.2133, -2.08922, -2.02973, -2.01912, -2.00194, -1.94793, -1.92903, -1.90671, -1.90311, -1.86394, -1.82542, -1.82281, -1.77955, -1.77286, -1.77119, -1.76317, -1.74447, -1.74447, -1.71927, -1.71244, -1.70758, -1.69632, -1.69448, -1.68845, -1.68842, -1.65839, -1.64934, -1.63575, -1.61216, -1.56943, -1.56546, -1.5601, -1.5584, -1.53875, -1.52408, -1.51576, -1.47345, -1.44838, -1.44712, -1.43751, -1.43722, -1.43159, -1.41818, -1.41585, -1.36654, -1.36556, -1.36486, -1.3596, -1.35941, -1.35301, -1.35301, -1.35145, -1.34479, -1.34443, -1.3441, -1.3381, -1.3334, -1.31715, -1.31105, -1.31071, -1.30166, -1.29944, -1.29715, -1.29669, -1.29634, -1.28696, -1.28504, -1.27143, -1.26548, -1.26533, -1.26421, -1.26054, -1.25978, -1.25631, -1.24751, -1.23887, -1.23797, -1.23588, -1.22391, -1.21961, -1.21559, -1.21499, -1.19502, -1.19009, -1.18784, -1.18746, -1.18264, -1.17917, -1.17597, -1.17482, -1.1664, -1.15644, -1.15584, -1.15317, -1.14694, -1.14341, -1.14246, -1.14234, -1.14027, -1.13955, -1.13745, -1.13674, -1.12764, -1.12735, -1.12729, -1.12645, -1.12578, -1.12533, -1.12131, -1.11019, -1.10879, -1.10357, -1.09973, -1.09187, -1.09187, -1.06664, -1.06356, -1.0554, -1.0492, -1.04506, -1.04027, -1.03942, -1.03896, -1.034, -1.03285, -1.02334, -1.02084, -1.01993, -1.01447, -1.01447, -1.01447, -1.00864, -1.00689, -1.00471, -1.00125, -0.999809, -0.998627, -0.998156, -0.994751, -0.994212, -0.993412, -0.992572, -0.992572, -0.992548, -0.992472, -0.989607, -0.987201, -0.982932, -0.982652, -0.980823, -0.976318, -0.974594, -0.973334, -0.97326, -0.971969, -0.970954, -0.964969, -0.963816, -0.960578, -0.959536, -0.95708, -0.953791, -0.953782, -0.952128, -0.951757, -0.95172, -0.951264, -0.950896, -0.949007, -0.947225, -0.945958, -0.945852, -0.945044, -0.94482, -0.940381, -0.940254, -0.940084, -0.939844, -0.937978, -0.935127, -0.93345, -0.931299, -0.931147, -0.929513, -0.927091, -0.926682, -0.926458, -0.925325, -0.918487, -0.917891, -0.917015, -0.916352, -0.915526, -0.915489, -0.913747, -0.91204, -0.911457, -0.911281, -0.910753, -0.909806, -0.909361, -0.908686, -0.907, -0.906509, -0.903637, -0.902177, -0.896958, -0.896304, -0.895733, -0.889965, -0.886484, -0.884943, -0.882143, -0.879831, -0.879507, -0.876134, -0.875782, -0.873226, -0.873167, -0.872282, -0.870152, -0.869655, -0.869655, -0.866992, -0.862656, -0.862331, -0.861969, -0.861246, -0.856819, -0.854323, -0.853294, -0.846832, -0.843682, -0.842113, -0.840478, -0.835353, -0.83055, -0.828979, -0.828979, -0.828088, -0.826904, -0.826844, -0.826474, -0.820101, -0.819027, -0.819027, -0.818121, -0.812784, -0.812206, -0.810112, -0.806803, -0.805296, -0.80126, -0.800501, -0.798129, -0.797067, -0.786663, -0.785991, -0.784662, -0.78212, -0.776524, -0.774306, -0.772335, -0.771675, -0.771675, -0.77125, -0.770083, -0.769165, -0.767499, -0.766419, -0.763909, -0.762582, -0.76243, -0.761753, -0.761182, -0.759494, -0.755514, -0.745122, -0.742554, -0.739007, -0.73575, -0.735359, -0.73376, -0.732161, -0.728712, -0.726951, -0.726218, -0.725935, -0.724686, -0.722143, -0.722044, -0.721563, -0.721248, -0.720543, -0.719718, -0.716511, -0.714431, -0.714329, -0.712779, -0.712512, -0.712512, -0.711802, -0.71157, -0.709608, -0.706909, -0.706774, -0.704839, -0.703444, -0.702687, -0.70263, -0.702272, -0.700726, -0.700691, -0.700566, -0.698961, -0.697583, -0.697153, -0.696813, -0.696062, -0.695309, -0.694557, -0.691675, -0.691434, -0.687548, -0.686447, -0.684052, -0.68283, -0.682705, -0.682523, -0.682514, -0.679172, -0.675747, -0.675161, -0.673046, -0.670132, -0.663973, -0.659537, -0.655187, -0.65481, -0.653818, -0.65335, -0.653181, -0.649845, -0.649723, -0.648533, -0.647648, -0.645932, -0.645885, -0.645736, -0.643418, -0.642324, -0.642275, -0.641053, -0.641053, -0.636907, -0.635015, -0.634658, -0.632863, -0.629322, -0.629234, -0.628869, -0.627114, -0.626578, -0.626576, -0.62511, -0.625091, -0.621436, -0.620774, -0.616916, -0.616051, -0.612722, -0.611527, -0.610163, -0.609325, -0.606185, -0.606169, -0.606019, -0.603731, -0.602434, -0.596665, -0.596236, -0.595822, -0.594053, -0.588736, -0.588164, -0.586796, -0.586709, -0.585038, -0.583978, -0.583929, -0.582533, -0.576205, -0.57511
	};
	vector<double> r = lloyds(signal, signal + sizeof(signal) / sizeof(signal[0]), 10);
	EXPECT_EQ(9, r.size());
	EXPECT_FLOAT_EQ(-2.15126, r[0]);
	EXPECT_FLOAT_EQ(-1.95019, r[1]);
	EXPECT_FLOAT_EQ(-1.72034, r[2]);
	EXPECT_FLOAT_EQ(-1.42570, r[3]);
	EXPECT_FLOAT_EQ(-1.23976, r[4]);
	EXPECT_FLOAT_EQ(-1.06092, r[5]);
	EXPECT_FLOAT_EQ(-0.93395, r[6]);
	EXPECT_FLOAT_EQ(-0.81530, r[7]);
	EXPECT_FLOAT_EQ(-0.68837, r[8]);
}*/

TEST(LLoyds, Lloyds1) {
	double data[] = {
		1.0, 1.1, 1.2,
		3.0, 3.1, 3.2,
	};
	vector<double> sig(data, data + 6);
	vector<double> table = lloyds(sig, 2);
	EXPECT_EQ(1, table.size());
	EXPECT_FLOAT_EQ(2.1, table[0]);
}

TEST(LLoyds, Lloyds2) {
	double data[] = {
		1.0, 1.1, 1.2,
	};
	vector<double> sig(data, data + 3);
	vector<double> table = lloyds(sig, 2);
	EXPECT_EQ(1, table.size());
	EXPECT_FLOAT_EQ(1.075, table[0]);
}

TEST(LLoyds, Lloyds3) {
	double data[] = {
		1.0, 1.1, 1.2,
	};
	vector<double> sig(data, data + 3);
	vector<double> table = lloyds(sig, 3);
	EXPECT_EQ(2, table.size());
	EXPECT_FLOAT_EQ(1.05, table[0]);
	EXPECT_FLOAT_EQ(1.15, table[1]);
}

TEST(LLoyds, Lloyds4) {
	double data[] = {
		435,219,891,906,184,572,301,892,875,121,245,146,640,137,938,25,668,288,848,790,141,890,528,145,289,861,339,769,293,757
	};
	vector<double> sig(data, data + 30);
	vector<double> table = lloyds(sig, 4);
	EXPECT_EQ(3, table.size());
	EXPECT_FLOAT_EQ(214.77678, table[0]);
	EXPECT_FLOAT_EQ(451.5625, table[1]);
	EXPECT_FLOAT_EQ(729.04547, table[2]);
}


