<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 */
class CRM_Contribute_Page_PaymentInfo extends CRM_Core_Page {

  public function preProcess() {
    $this->_component = CRM_Utils_Request::retrieve('component', 'String', $this, TRUE);
    $this->_action = CRM_Utils_Request::retrieve('action', 'String', $this, FALSE, 'browse');
    $this->_id = CRM_Utils_Request::retrieve('id', 'Positive', $this, TRUE);
    $this->_context = CRM_Utils_Request::retrieve('context', 'Alphanumeric', $this, TRUE);
    $this->_cid = CRM_Utils_Request::retrieve('cid', 'String', $this, TRUE);

    $this->assign('cid', $this->_cid);
    $this->assign('id', $this->_id);
    $this->assign('context', $this->_context);
    $this->assign('component', $this->_component);
    if ($this->_component != 'event') {
      $this->assign('hideButtonLinks', TRUE);
    }
  }

  public function browse() {
    $getTrxnInfo = $this->_context == 'transaction' ? TRUE : FALSE;
    $paymentInfo = CRM_Contribute_BAO_Contribution::getPaymentInfo($this->_id, $this->_component, $getTrxnInfo, TRUE);
    if ($this->_context == 'payment_info') {
      $this->assign('paymentInfo', $paymentInfo);
    }
  }

  /**
   * Run page.
   *
   * This typically involves assigning the appropriate
   * smarty variable :)
   *
   * @return string
   *   The content generated by running this page
   */
  public function run() {
    $this->preProcess();
    if ($this->_action) {
      $this->browse();
    }

    return parent::run();
  }

}
