<?php
/**
 * Test Generated example demonstrating the Setting.getfields API.
 *
 * Demonstrate return from getfields - see subfolder for variants
 *
 * @return array
 *   API result array
 */
function setting_getfields_example() {
  $params = [];

  try{
    $result = civicrm_api3('Setting', 'getfields', $params);
  }
  catch (CiviCRM_API3_Exception $e) {
    // Handle error here.
    $errorMessage = $e->getMessage();
    $errorCode = $e->getErrorCode();
    $errorData = $e->getExtraParams();
    return [
      'is_error' => 1,
      'error_message' => $errorMessage,
      'error_code' => $errorCode,
      'error_data' => $errorData,
    ];
  }

  return $result;
}

/**
 * Function returns array of result expected from previous function.
 *
 * @return array
 *   API result array
 */
function setting_getfields_expectedresult() {

  $expectedResult = [
    'is_error' => 0,
    'version' => 3,
    'count' => 173,
    'values' => [
      'address_standardization_provider' => [
        'group_name' => 'Address Preferences',
        'group' => 'address',
        'name' => 'address_standardization_provider',
        'type' => 'String',
        'html_type' => 'select',
        'default' => '',
        'add' => '4.1',
        'title' => 'Address Standardization Provider.',
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::addressProvider',
        ],
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => 'CiviCRM includes an optional plugin for interfacing with the United States Postal Services (USPS) Address Standardization web service. You must register to use the USPS service at https://www.usps.com/business/web-tools-apis/address-information.htm. If you are approved, they will provide you with a User ID and the URL for the service. Plugins for other address standardization services may be available from 3rd party developers. If installed, they will be included in the drop-down below. ',
      ],
      'address_standardization_userid' => [
        'group_name' => 'Address Preferences',
        'group' => 'address',
        'name' => 'address_standardization_userid',
        'type' => 'String',
        'html_type' => 'text',
        'default' => '',
        'add' => '4.1',
        'title' => 'Provider service user ID',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'address_standardization_url' => [
        'group_name' => 'Address Preferences',
        'group' => 'address',
        'name' => 'address_standardization_url',
        'type' => 'Text',
        'html_type' => 'text',
        'default' => '',
        'add' => '4.1',
        'title' => 'Provider Service URL',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => 'Web Service URL',
        'validate_callback' => 'CRM_Utils_Rule::url',
      ],
      'hideCountryMailingLabels' => [
        'group_name' => 'Address Preferences',
        'group' => 'address',
        'name' => 'hideCountryMailingLabels',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Hide Country in Mailing Labels when same as domain country',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Do not display the country field in mailing labels when the country is the same as that of the domain',
        'help_text' => '',
      ],
      'tag_unconfirmed' => [
        'group_name' => 'Campaign Preferences',
        'group' => 'campaign',
        'name' => 'tag_unconfirmed',
        'type' => 'String',
        'html_type' => 'text',
        'default' => 'Unconfirmed',
        'add' => '4.1',
        'title' => 'Tag for Unconfirmed Petition Signers',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If set, new contacts that are created when signing a petition are assigned a tag of this name.',
        'help_text' => '',
        'settings_pages' => [
          'campaign' => [
            'weight' => 10,
          ],
        ],
      ],
      'petition_contacts' => [
        'group_name' => 'Campaign Preferences',
        'group' => 'campaign',
        'name' => 'petition_contacts',
        'type' => 'String',
        'html_type' => 'text',
        'default' => 'Petition Contacts',
        'add' => '4.1',
        'title' => 'Petition Signers Group',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'All contacts that have signed a CiviCampaign petition will be added to this group. The group will be created if it does not exist (it is required for email verification).',
        'help_text' => '',
        'settings_pages' => [
          'campaign' => [
            'weight' => 20,
          ],
        ],
      ],
      'civicaseRedactActivityEmail' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'civicaseRedactActivityEmail',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [],
        'default' => 'default',
        'add' => '4.7',
        'title' => 'Redact Activity Email',
        'is_domain' => 1,
        'is_contact' => 0,
        'pseudoconstant' => [
          'callback' => 'CRM_Case_Info::getRedactOptions',
        ],
        'description' => 'Should activity emails be redacted? (Set \"Default\" to load setting from the legacy \"Settings.xml\" file.)',
        'help_text' => '',
      ],
      'civicaseAllowMultipleClients' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'civicaseAllowMultipleClients',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [],
        'default' => 'default',
        'add' => '4.7',
        'title' => 'Allow Multiple Case Clients',
        'is_domain' => 1,
        'is_contact' => 0,
        'pseudoconstant' => [
          'callback' => 'CRM_Case_Info::getMultiClientOptions',
        ],
        'description' => 'How many clients may be associated with a given case? (Set \"Default\" to load setting from the legacy \"Settings.xml\" file.)',
        'help_text' => '',
      ],
      'civicaseNaturalActivityTypeSort' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'civicaseNaturalActivityTypeSort',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [],
        'default' => 'default',
        'add' => '4.7',
        'title' => 'Activity Type Sorting',
        'is_domain' => 1,
        'is_contact' => 0,
        'pseudoconstant' => [
          'callback' => 'CRM_Case_Info::getSortOptions',
        ],
        'description' => 'How to sort activity-types on the \"Manage Case\" screen? (Set \"Default\" to load setting from the legacy \"Settings.xml\" file.)',
        'help_text' => '',
      ],
      'civicaseActivityRevisions' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'civicaseActivityRevisions',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => '',
        'html_type' => 'radio',
        'add' => '4.7',
        'title' => 'Enable Embedded Activity Revisions',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Enable tracking of activity revisions embedded within the \"civicrm_activity\" table. Alternatively, see \"Administer => System Settings => Misc => Logging\".',
        'help_text' => '',
      ],
      'cvv_backoffice_required' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'cvv_backoffice_required',
        'type' => 'Boolean',
        'html_type' => 'radio',
        'quick_form_type' => 'YesNo',
        'default' => '1',
        'add' => '4.1',
        'title' => 'CVV required for backoffice?',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Is the CVV code required for back office credit card transactions',
        'help_text' => 'If set it back-office credit card transactions will required a cvv code. Leave as required unless you have a very strong reason to change',
      ],
      'contribution_invoice_settings' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'contribution_invoice_settings',
        'type' => 'Array',
        'default' => [
          'invoice_prefix' => 'INV_',
          'credit_notes_prefix' => 'CN_',
          'due_date' => '10',
          'due_date_period' => 'days',
          'notes' => '',
          'tax_term' => 'Sales Tax',
          'tax_display_settings' => 'Inclusive',
        ],
        'add' => '4.7',
        'title' => 'Contribution Invoice Settings',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'invoicing' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'invoicing',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'Element',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Enable Tax and Invoicing',
        'is_domain' => 1,
        'is_contact' => 0,
        'on_change' => [
          '0' => 'CRM_Invoicing_Utils::onToggle',
        ],
      ],
      'acl_financial_type' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'acl_financial_type',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'Element',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Enable Access Control by Financial Type',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'help' => [
          'id' => 'acl_financial_type',
        ],
      ],
      'deferred_revenue_enabled' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'deferred_revenue_enabled',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'Element',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Enable Deferred Revenue',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'default_invoice_page' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'default_invoice_page',
        'type' => 'Integer',
        'quick_form_type' => 'Select',
        'default' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Contribute_PseudoConstant::contributionPage',
        ],
        'html_type' => 'select',
        'add' => '4.7',
        'title' => 'Default invoice payment page',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'always_post_to_accounts_receivable' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'always_post_to_accounts_receivable',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'Element',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Always post to Accounts Receivable?',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'update_contribution_on_membership_type_change' => [
        'group_name' => 'Contribute Preferences',
        'group' => 'contribute',
        'name' => 'update_contribution_on_membership_type_change',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'Element',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Automatically update related contributions when Membership Type is changed',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Enabling this setting will update related contribution of membership(s) except if the membership is paid for with a recurring contribution.',
        'help_text' => '',
      ],
      'contact_view_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_view_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'optionGroupName' => 'contact_view_options',
        ],
        'default' => '123456789101113',
        'add' => '4.1',
        'title' => 'Viewing Contacts',
        'is_domain' => '1',
        'is_contact' => 0,
        'description' => 'Select the tabs that should be displayed when viewing a contact record. EXAMPLE: If your organization does not keep track of \'Relationships\', then un-check this option to simplify the screen display. Tabs for Contributions, Pledges, Memberships, Events, Grants and Cases are also hidden if the corresponding component is not enabled. Go to Administer > System Settings > Enable Components to modify the components which are available for your site.',
        'help_text' => '',
        'serialize' => 1,
      ],
      'contact_edit_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_edit_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'optionGroupName' => 'contact_edit_options',
        ],
        'default' => '123456789111214151617',
        'add' => '4.1',
        'title' => 'Editing Contacts',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Select the sections that should be included when adding or editing a contact record. EXAMPLE: If your organization does not record Gender and Birth Date for individuals, then simplify the form by un-checking this option. Drag interface allows you to change the order of the panes displayed on contact add/edit screen.',
        'help_text' => '',
        'serialize' => 1,
      ],
      'advanced_search_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'advanced_search_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'optionGroupName' => 'advanced_search_options',
        ],
        'default' => '123456789101112131516171819',
        'add' => '4.1',
        'title' => 'Contact Search',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Select the sections that should be included in the Basic and Advanced Search forms. EXAMPLE: If you don\'t track Relationships - then you do not need this section included in the advanced search form. Simplify the form by un-checking this option.',
        'serialize' => 1,
      ],
      'user_dashboard_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'user_dashboard_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'optionGroupName' => 'user_dashboard_options',
        ],
        'default' => '1234578',
        'add' => '4.1',
        'title' => 'Contact Dashboard',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Select the sections that should be included in the Contact Dashboard. EXAMPLE: If you don\'t want constituents to view their own contribution history, un-check that option.',
        'help_text' => '',
        'serialize' => 1,
      ],
      'address_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'address_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'optionGroupName' => 'address_options',
        ],
        'default' => '123456891011',
        'add' => '4.1',
        'title' => 'Address Fields',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'serialize' => 1,
      ],
      'address_format' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'address_format',
        'type' => 'String',
        'html_type' => 'textarea',
        'default' => '{contact.address_name}
{contact.street_address}
{contact.supplemental_address_1}
{contact.supplemental_address_2}
{contact.supplemental_address_3}
{contact.city}{, }{contact.state_province}{ }{contact.postal_code}
{contact.country}',
        'add' => '4.1',
        'title' => 'Address Display Format',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'mailing_format' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'mailing_format',
        'type' => 'String',
        'html_type' => 'textarea',
        'default' => '{contact.addressee}
{contact.street_address}
{contact.supplemental_address_1}
{contact.supplemental_address_2}
{contact.supplemental_address_3}
{contact.city}{, }{contact.state_province}{ }{contact.postal_code}
{contact.country}',
        'add' => '4.1',
        'title' => 'Mailing Label Format',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'display_name_format' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'display_name_format',
        'type' => 'String',
        'html_type' => 'textarea',
        'default' => '{contact.individual_prefix}{ }{contact.first_name}{ }{contact.last_name}{ }{contact.individual_suffix}',
        'add' => '4.1',
        'title' => 'Individual Display Name Format',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Display name format for individual contact display names.',
      ],
      'sort_name_format' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'sort_name_format',
        'type' => 'String',
        'html_type' => 'textarea',
        'default' => '{contact.last_name}{, }{contact.first_name}',
        'add' => '4.1',
        'title' => 'Individual Sort Name Format',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Sort name format for individual contact display names.',
      ],
      'remote_profile_submissions' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'remote_profile_submissions',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => '',
        'html_type' => 'radio',
        'add' => '4.7',
        'title' => 'Accept profile submissions from external sites',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, CiviCRM will permit submissions from external sites to profiles. This is disabled by default to limit abuse.',
        'help_text' => '',
      ],
      'allow_alert_autodismissal' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'allow_alert_autodismissal',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => TRUE,
        'html_type' => 'radio',
        'add' => '4.7',
        'title' => 'Allow alerts to auto-dismiss?',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If disabled, CiviCRM will not automatically dismiss any alerts after 10 seconds.',
        'help_text' => '',
      ],
      'editor_id' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'editor_id',
        'type' => 'String',
        'html_type' => 'select',
        'default' => 'CKEditor',
        'add' => '4.1',
        'title' => 'Wysiwig Editor',
        'pseudoconstant' => [
          'optionGroupName' => 'wysiwyg_editor',
          'keyColumn' => 'name',
        ],
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'contact_ajax_check_similar' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_ajax_check_similar',
        'type' => 'String',
        'html_type' => 'radio',
        'default' => '1',
        'add' => '4.1',
        'title' => 'Check for Similar Contacts',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'options' => [
          '1' => 'While Typing',
          '0' => 'When Saving',
          '2' => 'Never',
        ],
      ],
      'ajaxPopupsEnabled' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'ajaxPopupsEnabled',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 1,
        'add' => '4.5',
        'title' => 'Enable Popup Forms',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'activity_assignee_notification' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'activity_assignee_notification',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => '1',
        'add' => '4.1',
        'title' => 'Notify Activity Assignees',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'activity_assignee_notification_ics' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'activity_assignee_notification_ics',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Include ICal Invite to Activity Assignees',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'contact_autocomplete_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_autocomplete_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Search::getContactAutocompleteOptions',
        ],
        'default' => '12',
        'add' => '4.1',
        'title' => 'Autocomplete Contact Search',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Selected fields will be displayed in back-office autocomplete dropdown search results (Quick Search, etc.). Contact Name is always included.',
        'help_text' => '',
        'serialize' => 1,
        'validate_callback' => 'CRM_Admin_Form_Setting_Search::enableOptionOne',
      ],
      'contact_reference_options' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_reference_options',
        'type' => 'String',
        'html_type' => 'checkboxes',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Search::getContactReferenceOptions',
        ],
        'default' => '12',
        'add' => '4.1',
        'title' => 'Contact Reference Options',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Selected fields will be displayed in autocomplete dropdown search results for \'Contact Reference\' custom fields. Contact Name is always included. NOTE: You must assign \'access contact reference fields\' permission to the anonymous role if you want to use custom contact reference fields in profiles on public pages. For most situations, you should use the \'Limit List to Group\' setting when configuring a contact reference field which will be used in public forms to prevent exposing your entire contact list.',
        'help_text' => '',
        'serialize' => 1,
        'validate_callback' => 'CRM_Admin_Form_Setting_Search::enableOptionOne',
      ],
      'contact_smart_group_display' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_smart_group_display',
        'type' => 'String',
        'html_type' => 'radio',
        'default' => '1',
        'add' => '4.7',
        'title' => 'Viewing Smart Groups',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Controls display of the smart groups that a contact is part of in each contact\'s \"Groups\" tab. \"Show on Demand\" provides the best performance, and is recommended for most sites.',
        'help_text' => '',
        'pseudoconstant' => [
          'optionGroupName' => 'contact_smart_group_display',
        ],
      ],
      'smart_group_cache_refresh_mode' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'smart_group_cache_refresh_mode',
        'type' => 'String',
        'html_type' => 'radio',
        'default' => 'opportunistic',
        'add' => '4.7',
        'title' => 'Smart Group Refresh Mode',
        'is_domain' => 1,
        'is_contact' => 0,
        'pseudoconstant' => [
          'callback' => 'CRM_Contact_BAO_GroupContactCache::getModes',
        ],
        'description' => 'Should the smart groups be by cron jobs or user actions',
        'help_text' => 'In \"Opportunistic Flush\" mode, caches are flushed in response to user actions; this mode is broadly compatible but may add latency during form-submissions. In \"Cron Flush\" mode, you should schedule a cron job to flush caches; this can improve latency on form-submissions but requires more setup.',
      ],
      'installed' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'installed',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => '',
        'add' => '4.7',
        'title' => 'System Installed',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'A flag indicating whether this system has run a post-installation routine',
        'help_text' => '',
      ],
      'max_attachments' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'max_attachments',
        'legacy_key' => 'maxAttachments',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
          'maxlength' => 8,
        ],
        'default' => 3,
        'add' => '4.3',
        'title' => 'Maximum Attachments',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Maximum number of files (documents, images, etc.) which can be attached to emails or activities.',
        'help_text' => '',
      ],
      'maxFileSize' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'maxFileSize',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
          'maxlength' => 8,
        ],
        'default' => 3,
        'add' => '4.3',
        'title' => 'Maximum File Size (in MB)',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Maximum Size of file (documents, images, etc.) which can be attached to emails or activities.<br />Note: php.ini should support this file size.',
        'help_text' => '',
      ],
      'contact_undelete' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'contact_undelete',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.3',
        'title' => 'Contact Trash and Undelete',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, deleted contacts will be moved to trash (instead of being destroyed). Users with the proper permission are able to search for the deleted contacts and restore them (or delete permanently).',
        'help_text' => '',
      ],
      'allowPermDeleteFinancial' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'allowPermDeleteFinancial',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => '',
        'add' => '4.3',
        'title' => 'Contact Permanent Delete',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Allow Permanent Delete for contacts who are linked to live financial transactions',
        'help_text' => '',
      ],
      'securityAlert' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'securityAlert',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.4',
        'title' => 'Status Alerts',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, CiviCRM will display pop-up notifications (no more than once per day) for security and misconfiguration issues identified in the system check.',
        'help_text' => '',
      ],
      'doNotAttachPDFReceipt' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'doNotAttachPDFReceipt',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Attach PDF copy to receipts',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, CiviCRM sends PDF receipt as an attachment during event signup or online contribution.',
        'help_text' => '',
      ],
      'recordGeneratedLetters' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'recordGeneratedLetters',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'default' => 'multiple',
        'add' => '4.7',
        'title' => 'Record generated letters',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'When generating a letter (PDF/Word) via mail-merge, how should the letter be recorded?',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Contact_Form_Task_PDFLetterCommon::getLoggingOptions',
        ],
      ],
      'wkhtmltopdfPath' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'wkhtmltopdfPath',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 256,
        ],
        'html_type' => 'text',
        'default' => '',
        'add' => '4.3',
        'title' => 'Path to wkhtmltopdf executable',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'recaptchaOptions' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'recaptchaOptions',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 64,
        ],
        'html_type' => 'text',
        'default' => '',
        'add' => '4.3',
        'title' => 'Recaptcha Options',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'You can specify the reCAPTCHA theme options as comma separated data.(eg: theme:\'blackglass\', lang : \'fr\' ). Check the available options at <a href=\"https://developers.google.com/recaptcha/docs/display#config\">Customizing the Look and Feel of reCAPTCHA</a>.',
        'help_text' => '',
      ],
      'recaptchaPublicKey' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'recaptchaPublicKey',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 64,
        ],
        'html_type' => 'text',
        'default' => '',
        'add' => '4.3',
        'title' => 'Recaptcha Site Key',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'forceRecaptcha' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'forceRecaptcha',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'html_type' => '',
        'default' => 0,
        'title' => 'Force reCAPTCHA on Contribution pages',
        'description' => 'If enabled, reCAPTCHA will show on all contribution pages.',
      ],
      'recaptchaPrivateKey' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'recaptchaPrivateKey',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 64,
        ],
        'html_type' => 'text',
        'default' => '',
        'add' => '4.3',
        'title' => 'Recaptcha Secret Key',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'checksum_timeout' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'checksum_timeout',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 2,
          'maxlength' => 8,
        ],
        'html_type' => 'text',
        'default' => 7,
        'add' => '4.3',
        'title' => 'Checksum Lifespan',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'blogUrl' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'blogUrl',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 128,
        ],
        'html_type' => 'text',
        'default' => '*default*',
        'add' => '4.3',
        'title' => 'Blog Feed URL',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Blog feed URL used by the blog dashlet',
        'help_text' => 'Use \"*default*\" for the system default or override with a custom URL',
      ],
      'communityMessagesUrl' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'communityMessagesUrl',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 128,
        ],
        'html_type' => 'text',
        'default' => '*default*',
        'add' => '4.3',
        'title' => 'Community Messages URL',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Service providing CiviCRM community messages',
        'help_text' => 'Use \"*default*\" for the system default or override with a custom URL',
      ],
      'gettingStartedUrl' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'gettingStartedUrl',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 128,
        ],
        'html_type' => 'text',
        'default' => '*default*',
        'add' => '4.3',
        'title' => 'Getting Started URL',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Service providing the Getting Started data',
        'help_text' => 'Use \"*default*\" for the system default or override with a custom URL',
      ],
      'resCacheCode' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'resCacheCode',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '',
        'add' => '4.3',
        'title' => 'resCacheCode',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Code appended to resource URLs (JS/CSS) to coerce HTTP caching',
        'help_text' => '',
      ],
      'verifySSL' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'verifySSL',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.3',
        'title' => 'Verify SSL?',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If disabled, outbound web-service requests will allow unverified, insecure HTTPS connections',
        'help_text' => 'Unless you are absolutely unable to configure your server to check the SSL certificate of the remote server you should leave this set to Yes',
      ],
      'enableSSL' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'enableSSL',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.5',
        'title' => 'Force SSL?',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, inbound HTTP requests for sensitive pages will be redirected to HTTPS.',
        'help_text' => 'If enabled, inbound HTTP requests for sensitive pages will be redirected to HTTPS.',
      ],
      'wpBasePage' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'wpBasePage',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.3',
        'title' => 'WordPress Base Page',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If set, CiviCRM will use this setting as the base url.',
        'help_text' => 'By default, CiviCRM will generate front-facing pages using the home page at http://wp/ as its base. If you want to use a different template for CiviCRM pages, set the path here.',
      ],
      'secondDegRelPermissions' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'secondDegRelPermissions',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Allow second-degree relationship permissions',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, contacts with the permission to edit a related contact will inherit that contact\'s permission to edit other related contacts',
        'help_text' => '',
      ],
      'enable_components' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'enable_components',
        'type' => 'Array',
        'html_type' => 'checkboxes',
        'default' => '',
        'add' => '4.4',
        'title' => 'Enable Components',
        'is_domain' => '1',
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'on_change' => [
          '0' => 'CRM_Case_Info::onToggleComponents',
          '1' => 'CRM_Core_Component::flushEnabledComponents',
          '2' => 'call://resources/resetCacheCode',
        ],
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::getComponentSelectValues',
        ],
      ],
      'disable_core_css' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'disable_core_css',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.4',
        'title' => 'Disable CiviCRM css',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Prevent the stylesheet \"civicrm.css\" from being loaded.',
        'help_text' => '',
      ],
      'empoweredBy' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'empoweredBy',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.5',
        'title' => 'Display \"empowered by CiviCRM\"',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'When enabled, \"empowered by CiviCRM\" is displayed at the bottom of public forms.',
        'help_text' => '',
      ],
      'logging_no_trigger_permission' => [
        'add' => '4.7',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'help_text' => '(EXPERIMENTAL) If the MySQL user does not have permission to administer triggers, then you must create the triggers outside CiviCRM. No support is provided for this configuration.',
        'name' => 'logging_no_trigger_permission',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'html_type' => '',
        'default' => 0,
        'title' => '(EXPERIMENTAL) MySQL user does not have trigger permissions',
        'description' => 'Set this when you intend to manage trigger creation outside of CiviCRM',
      ],
      'logging' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'logging',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'html_type' => '',
        'default' => 0,
        'title' => 'Logging',
        'description' => 'If enabled, all actions will be logged with a complete record of changes.',
        'validate_callback' => 'CRM_Logging_Schema::checkLoggingSupport',
        'on_change' => [
          '0' => 'CRM_Logging_Schema::onToggle',
        ],
      ],
      'logging_uniqueid_date' => [
        'add' => '4.7',
        'help_text' => 'This is the date when CRM-18193 was implemented',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'logging_uniqueid_date',
        'type' => 'Date',
        'quick_form_type' => 'DateTime',
        'html_type' => '',
        'default' => '',
        'title' => 'Logging Unique ID not recorded before',
        'description' => 'This is the date when CRM-18193 was implemented',
      ],
      'logging_all_tables_uniquid' => [
        'add' => '4.7',
        'help_text' => 'This indicates there are no tables holdng pre-uniqid log_conn_id values (CRM-18193)',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'logging_all_tables_uniquid',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'html_type' => '',
        'default' => 0,
        'title' => 'All tables use Unique Connection ID',
        'description' => 'Do some tables pre-date CRM-18193?',
      ],
      'userFrameworkUsersTableName' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'userFrameworkUsersTableName',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '32',
          'maxlength' => '64',
        ],
        'default' => 'users',
        'title' => 'CMS Users Table Name',
        'description' => '',
      ],
      'wpLoadPhp' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'wpLoadPhp',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.6',
        'title' => 'WordPress Path to wp-load.php',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'CiviCRM will use this setting as path to bootstrap WP.',
        'help_text' => '',
      ],
      'secure_cache_timeout_minutes' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'secure_cache_timeout_minutes',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
          'maxlength' => 8,
        ],
        'default' => 20,
        'add' => '4.7',
        'title' => 'Secure Cache Timeout',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Maximum number of minutes that secure form data should linger',
        'help_text' => '',
      ],
      'site_id' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'site_id',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '',
        'add' => '4.6',
        'title' => 'Unique Site ID',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'recentItemsMaxCount' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'recentItemsMaxCount',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
          'maxlength' => 3,
        ],
        'default' => 20,
        'add' => '4.7',
        'title' => 'Size of \"Recent Items\" stack',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'How many items should CiviCRM store in it\'s \"Recently viewed\" list.',
        'help_text' => '',
      ],
      'recentItemsProviders' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'recentItemsProviders',
        'type' => 'Array',
        'html_type' => 'Select',
        'quick_form_type' => 'Select',
        'html_attributes' => [
          'multiple' => 1,
          'class' => 'crm-select2',
        ],
        'default' => '',
        'add' => '4.7',
        'title' => 'Recent Items Providers',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'What providers may save views in CiviCRM\'s \"Recently viewed\" list. If empty, all are in.',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Utils_Recent::getProviders',
        ],
      ],
      'dedupe_default_limit' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'dedupe_default_limit',
        'type' => 'Integer',
        'default' => 0,
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'add' => '4.7',
        'title' => 'Default limit for dedupe screen',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Default to only loading matches against this number of contacts',
        'help_text' => 'Deduping larger databases can crash the server. By configuring a limit other than 0 here the dedupe query will only search for matches against a limited number of contacts.',
      ],
      'syncCMSEmail' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'syncCMSEmail',
        'type' => 'Boolean',
        'html_type' => 'YesNo',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.7',
        'title' => 'Sync CMS Email',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, then CMS email id will be synchronised with CiviCRM contacts\'s primary email.',
        'help_text' => '',
      ],
      'preserve_activity_tab_filter' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'preserve_activity_tab_filter',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.7',
        'title' => 'Preserve activity filters as a user preference',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'When enabled, any filter settings a user selects on the contact\'s Activity tab will be remembered as they visit other contacts.',
      ],
      'do_not_notify_assignees_for' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'do_not_notify_assignees_for',
        'type' => 'Array',
        'add' => '4.7',
        'is_domain' => 1,
        'is_contact' => 0,
        'default' => [],
        'title' => 'Do not notify assignees for',
        'description' => 'These activity types will be excluded from automated email notifications to assignees.',
        'html_type' => 'select',
        'html_attributes' => [
          'multiple' => 1,
          'class' => 'huge crm-select2',
        ],
        'pseudoconstant' => [
          'optionGroupName' => 'activity_type',
        ],
        'quick_form_type' => 'Select',
      ],
      'menubar_position' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'menubar_position',
        'type' => 'String',
        'html_type' => 'select',
        'default' => 'over-cms-menu',
        'add' => '5.12',
        'title' => 'Menubar position',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Location of the CiviCRM main menu.',
        'help_text' => '',
        'options' => [
          'over-cms-menu' => 'Replace website menu',
          'below-cms-menu' => 'Below website menu',
          'above-crm-container' => 'Above content area',
          'none' => 'None - disable menu',
        ],
      ],
      'menubar_color' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'menubar_color',
        'type' => 'String',
        'html_type' => 'color',
        'default' => '#1b1b1b',
        'add' => '5.13',
        'title' => 'Menubar color',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Color of the CiviCRM main menu.',
        'help_text' => '',
        'validate_callback' => 'CRM_Utils_Color::normalize',
      ],
      'requestableMimeTypes' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'requestableMimeTypes',
        'type' => 'String',
        'html_type' => 'Text',
        'default' => 'image/jpeg,image/pjpeg,image/gif,image/x-png,image/png,image/jpg,text/html,application/pdf',
        'add' => '5.13',
        'title' => 'Mime Types that can be passed as URL params',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Acceptable Mime Types that can be used as part of file urls',
        'help_text' => '',
      ],
      'theme_frontend' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'theme_frontend',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'pseudoconstant' => [
          'callback' => 'call://themes/getAvailable',
        ],
        'default' => 'default',
        'add' => '5.16',
        'title' => 'Frontend Theme',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Theme to use on frontend pages',
        'help_text' => '',
      ],
      'theme_backend' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'theme_backend',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'pseudoconstant' => [
          'callback' => 'call://themes/getAvailable',
        ],
        'default' => 'default',
        'add' => '5.16',
        'title' => 'Backend Theme',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Theme to use on backend pages',
        'help_text' => '',
      ],
      'http_timeout' => [
        'group_name' => 'CiviCRM Preferences',
        'group' => 'core',
        'name' => 'http_timeout',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
          'maxlength' => 3,
        ],
        'default' => 5,
        'add' => '5.14',
        'title' => 'HTTP request timeout',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'How long should HTTP requests through Guzzle application run for in seconds',
        'help_text' => 'Set the number of seconds http requests should run for before terminating',
      ],
      'assetCache' => [
        'group_name' => 'Developer Preferences',
        'group' => 'developer',
        'name' => 'assetCache',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [],
        'default' => 'auto',
        'add' => '4.7',
        'title' => 'Asset Caching',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Store computed JS/CSS content in cache files? (Note: In \"Auto\" mode, the \"Debug\" setting will determine whether to activate the cache.)',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => '\Civi\Core\AssetBuilder::getCacheModes',
        ],
      ],
      'userFrameworkLogging' => [
        'group_name' => 'Developer Preferences',
        'group' => 'developer',
        'name' => 'userFrameworkLogging',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Enable Drupal Watchdog Logging',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Set this value to Yes if you want CiviCRM error/debugging messages to appear in the Drupal error logs',
        'help_text' => 'Set this value to Yes if you want CiviCRM error/debugging messages the appear in your CMS\' error log. In the case of Drupal, this will cause all CiviCRM error messages to appear in the watchdog (assuming you have Drupal\'s watchdog enabled)',
      ],
      'debug_enabled' => [
        'group_name' => 'Developer Preferences',
        'group' => 'developer',
        'name' => 'debug_enabled',
        'config_key' => 'debug',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Enable Debugging',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Set this value to Yes if you want to use one of CiviCRM\'s debugging tools. This feature should NOT be enabled for production sites',
        'help_text' => 'Do not turn this on on production sites',
      ],
      'backtrace' => [
        'group_name' => 'Developer Preferences',
        'group' => 'developer',
        'name' => 'backtrace',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Display Backtrace',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Set this value to Yes if you want to display a backtrace listing when a fatal error is encountered. This feature should NOT be enabled for production sites',
      ],
      'environment' => [
        'group_name' => 'Developer Preferences',
        'group' => 'developer',
        'name' => 'environment',
        'type' => 'String',
        'html_type' => 'Select',
        'quick_form_type' => 'Select',
        'default' => 'Production',
        'pseudoconstant' => [
          'optionGroupName' => 'environment',
        ],
        'add' => '4.7',
        'title' => 'Environment',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Setting to define the environment in which this CiviCRM instance is running.',
        'on_change' => [
          '0' => 'CRM_Core_BAO_Setting::onChangeEnvironmentSetting',
        ],
      ],
      'fatalErrorHandler' => [
        'group_name' => 'Developer Preferences',
        'group' => 'developer',
        'name' => 'fatalErrorHandler',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '',
        'add' => '4.3',
        'title' => 'Fatal Error Handler',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Enter the path and class for a custom PHP error-handling function if you want to override built-in CiviCRM error handling for your site.',
      ],
      'uploadDir' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'Directory Preferences',
        'group' => 'directory',
        'name' => 'uploadDir',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'title' => 'Temporary Files Directory',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => 'File system path where temporary CiviCRM files - such as import data files - are uploaded.',
      ],
      'imageUploadDir' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'Directory Preferences',
        'group' => 'directory',
        'name' => 'imageUploadDir',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'title' => 'Image Directory',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'File system path where image files are uploaded. Currently, this path is used for images associated with premiums (CiviContribute thank-you gifts).',
        'help_text' => '',
      ],
      'customFileUploadDir' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'Directory Preferences',
        'group' => 'directory',
        'name' => 'customFileUploadDir',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'title' => 'Custom Files Directory',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Path where documents and images which are attachments to contact records are stored (e.g. contact photos, resumes, contracts, etc.). These attachments are defined using \'file\' type custom fields.',
        'help_text' => '',
      ],
      'customTemplateDir' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'Directory Preferences',
        'group' => 'directory',
        'name' => 'customTemplateDir',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'title' => 'Custom Template Directory',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Path where site specific templates are stored if any. This directory is searched first if set. Custom JavaScript code can be added to templates by creating files named templateFile.extra.tpl. (learn more...)',
        'help_text' => '',
      ],
      'customPHPPathDir' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'Directory Preferences',
        'group' => 'directory',
        'name' => 'customPHPPathDir',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'title' => 'Custom PHP Directory',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Path where site specific PHP code files are stored if any. This directory is searched first if set.',
        'help_text' => '',
      ],
      'extensionsDir' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group_name' => 'Directory Preferences',
        'group' => 'directory',
        'name' => 'extensionsDir',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'title' => 'Extensions Directory',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Path where CiviCRM extensions are stored.',
        'help_text' => '',
      ],
      'enable_cart' => [
        'name' => 'enable_cart',
        'group_name' => 'Event Preferences',
        'settings_pages' => [
          'event' => [
            'weight' => 10,
          ],
        ],
        'group' => 'event',
        'type' => 'Boolean',
        'quick_form_type' => 'CheckBox',
        'default' => 0,
        'add' => '4.1',
        'title' => 'Use Shopping Cart Style Event Registration',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'This feature allows users to register for more than one event at a time. When enabled, users will add event(s) to a \"cart\" and then pay for them all at once. Enabling this setting will affect online registration for all active events. The code is an alpha state, and you will potentially need to have developer resources to debug and fix sections of the codebase while testing and deploying it',
        'help_text' => '',
        'documentation_link' => [
          'page' => 'CiviEvent Cart Checkout',
          'resource' => 'wiki',
        ],
      ],
      'show_events' => [
        'name' => 'show_events',
        'group_name' => 'Event Preferences',
        'group' => 'event',
        'settings_pages' => [
          'event' => [
            'weight' => 20,
          ],
        ],
        'type' => 'Integer',
        'quick_form_type' => 'Select',
        'default' => 10,
        'add' => '4.5',
        'title' => 'Dashboard entries',
        'html_type' => 'select',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Configure how many events should be shown on the dashboard. This overrides the default value of 10 entries.',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::getDashboardEntriesCount',
        ],
      ],
      'ext_repo_url' => [
        'group_name' => 'Extension Preferences',
        'group' => 'ext',
        'name' => 'ext_repo_url',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 128,
        ],
        'html_type' => 'text',
        'default' => 'https://civicrm.org/extdir/ver={ver}|cms={uf}',
        'add' => '4.3',
        'title' => 'Extension Repo URL',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'customTranslateFunction' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'customTranslateFunction',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '30',
          'maxlength' => '100',
        ],
        'default' => '',
        'title' => 'Custom Translate Function',
        'description' => '',
      ],
      'monetaryThousandSeparator' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'monetaryThousandSeparator',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
        ],
        'default' => ',',
        'add' => '4.3',
        'title' => 'Thousands Separator',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'monetaryDecimalPoint' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'monetaryDecimalPoint',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 2,
        ],
        'default' => '.',
        'add' => '4.3',
        'title' => 'Decimal Delimiter',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'moneyformat' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'moneyformat',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '%c %a',
        'add' => '4.3',
        'title' => 'Monetary Amount Display',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'moneyvalueformat' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'moneyvalueformat',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '%!i',
        'add' => '4.3',
        'title' => 'Monetary Value Display',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'defaultCurrency' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'defaultCurrency',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'default' => 'USD',
        'add' => '4.3',
        'title' => 'Default Currency',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Default currency assigned to contributions and other monetary transactions.',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Localization::getCurrencySymbols',
        ],
        'on_change' => [
          '0' => 'CRM_Admin_Form_Setting_Localization::onChangeDefaultCurrency',
        ],
      ],
      'defaultContactCountry' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'defaultContactCountry',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [],
        'add' => '4.4',
        'title' => 'Default Country',
        'is_domain' => 1,
        'is_contact' => 0,
        'is_required' => '',
        'description' => 'This value is selected by default when adding a new contact address.',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Localization::getAvailableCountries',
        ],
      ],
      'defaultContactStateProvince' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'defaultContactStateProvince',
        'type' => 'Integer',
        'quick_form_type' => 'ChainSelect',
        'html_type' => 'ChainSelect',
        'default' => '',
        'title' => 'Default State/Province',
        'description' => 'This value is selected by default when adding a new contact address.',
      ],
      'countryLimit' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'countryLimit',
        'type' => 'Array',
        'quick_form_type' => 'Element',
        'html_type' => 'advmultiselect',
        'html_attributes' => [
          'size' => 5,
          'style' => 'width:150px',
          'class' => 'advmultiselect',
        ],
        'default' => [],
        'add' => '4.3',
        'title' => 'Available Countries',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Localization::getAvailableCountries',
        ],
      ],
      'provinceLimit' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'provinceLimit',
        'type' => 'Array',
        'quick_form_type' => 'Element',
        'html_type' => 'advmultiselect',
        'html_attributes' => [
          'size' => 5,
          'style' => 'width:150px',
          'class' => 'advmultiselect',
        ],
        'default' => [],
        'add' => '4.3',
        'title' => 'Available States and Provinces (by Country)',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Localization::getAvailableCountries',
        ],
      ],
      'inheritLocale' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'inheritLocale',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.3',
        'title' => 'Inherit CMS Language',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'dateformatDatetime' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatDatetime',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '%B %E%f, %Y %l:%M %P',
        'add' => '4.3',
        'title' => 'Date Format: Complete Date and Time',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'dateformatFull' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatFull',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '%B %E%f, %Y',
        'add' => '4.3',
        'title' => 'Date Format: Complete Date',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'dateformatPartial' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatPartial',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'default' => '%B %Y',
        'add' => '4.3',
        'title' => 'Date Format: Month and Year',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'dateformatTime' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatTime',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '12',
          'maxlength' => '60',
        ],
        'default' => '%l:%M %P',
        'title' => 'Date Format: Time Only',
        'description' => '',
      ],
      'dateformatYear' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatYear',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '12',
          'maxlength' => '60',
        ],
        'default' => '%Y',
        'title' => 'Date Format: Year Only',
        'description' => '',
      ],
      'dateformatFinancialBatch' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatFinancialBatch',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '12',
          'maxlength' => '60',
        ],
        'default' => '%m/%d/%Y',
        'title' => 'Date Format: Financial Batch',
        'description' => '',
      ],
      'dateformatshortdate' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateformatshortdate',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '12',
          'maxlength' => '60',
        ],
        'default' => '%m/%d/%Y',
        'title' => 'Date Format: Short date Month Day Year',
        'description' => '',
      ],
      'dateInputFormat' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'dateInputFormat',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::getDatePluginInputFormats',
        ],
        'default' => 'mm/dd/yy',
        'title' => 'Date Input Format',
        'description' => '',
      ],
      'fieldSeparator' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'fieldSeparator',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '2',
          'maxlength' => '8',
        ],
        'default' => ',',
        'title' => 'Import / Export Field Separator',
        'description' => 'Global CSV separator character. Modify this setting to enable import and export of different kinds of CSV files (for example: \',\' \';\' \':\' \'|\' ).',
      ],
      'fiscalYearStart' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'fiscalYearStart',
        'type' => 'Array',
        'quick_form_type' => 'MonthDay',
        'html_type' => 'MonthDay',
        'default' => [
          'M' => 1,
          'd' => 1,
        ],
        'title' => 'Fiscal Year Start',
        'description' => '',
      ],
      'languageLimit' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'languageLimit',
        'type' => 'Array',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'multiple' => 1,
          'class' => 'crm-select2',
        ],
        'default' => '',
        'add' => '4.3',
        'title' => 'Available Languages (Multi-lingual)',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Core_I18n::languages',
        ],
      ],
      'uiLanguages' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'uiLanguages',
        'type' => 'Array',
        'quick_form_type' => 'Select',
        'html_type' => 'select',
        'html_attributes' => [
          'multiple' => 1,
          'class' => 'crm-select2',
        ],
        'default' => '',
        'add' => '5.9',
        'title' => 'Available Languages',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => 'User Interface languages available to users',
        'pseudoconstant' => [
          'callback' => 'CRM_Core_I18n::languages',
        ],
      ],
      'lcMessages' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'lcMessages',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'default' => 'en_US',
        'add' => '4.3',
        'title' => 'Default Language',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Localization::getDefaultLocaleOptions',
        ],
        'on_change' => [
          '0' => 'CRM_Admin_Form_Setting_Localization::onChangeLcMessages',
        ],
      ],
      'legacyEncoding' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'legacyEncoding',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '12',
          'maxlength' => '30',
        ],
        'default' => 'Windows-1252',
        'title' => 'Legacy Encoding',
        'description' => 'If import files are NOT encoded as UTF-8, specify an alternate character encoding for these files. The default of Windows-1252 will work for Excel-created .CSV files on many computers.',
      ],
      'timeInputFormat' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'timeInputFormat',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::getTimeFormats',
        ],
        'default' => '1',
        'title' => 'Time Input Format',
        'description' => '',
        'on_change' => [
          '0' => 'CRM_Core_BAO_PreferencesDate::onChangeSetting',
        ],
      ],
      'weekBegins' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'weekBegins',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'pseudoconstant' => [
          'callback' => 'CRM_Utils_Date::getFullWeekdayNames',
        ],
        'default' => 0,
        'add' => '4.7',
        'title' => 'Week begins on',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'contact_default_language' => [
        'group_name' => 'Localization Preferences',
        'group' => 'localization',
        'name' => 'contact_default_language',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Localization::getDefaultLanguageOptions',
        ],
        'default' => '*default*',
        'add' => '4.7',
        'title' => 'Default Language for contacts',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Default language (if any) for contact records',
        'help_text' => 'If a contact is created with no language this setting will determine the language data (if any) to save.You may or may not wish to make an assumption here about whether it matches the site language',
      ],
      'profile_double_optin' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'profile_double_optin',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => '1',
        'add' => '4.1',
        'title' => 'Enable Double Opt-in for Profile Group(s) field',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'When CiviMail is enabled, users who \"subscribe\" to a group from a profile Group(s) checkbox will receive a confirmation email. They must respond (opt-in) before they are added to the group.',
        'help_text' => '',
      ],
      'track_civimail_replies' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'track_civimail_replies',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.1',
        'title' => 'Track replies using VERP in Reply-To header',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If checked, mailings will default to tracking replies using VERP-ed Reply-To. ',
        'help_text' => '',
        'validate_callback' => 'CRM_Core_BAO_Setting::validateBoolSetting',
      ],
      'civimail_workflow' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'civimail_workflow',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.1',
        'title' => 'Enable workflow support for CiviMail',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Drupal-only. Rules module must be enabled (beta feature - use with caution).',
        'help_text' => '',
      ],
      'civimail_server_wide_lock' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'civimail_server_wide_lock',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.1',
        'title' => 'Enable global server wide lock for CiviMail',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'replyTo' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'replyTo',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.6',
        'title' => 'Enable Custom Reply-To',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Allow CiviMail users to send mailings with a custom Reply-To header',
        'help_text' => '',
      ],
      'mailing_backend' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'mailing_backend',
        'type' => 'Array',
        'html_type' => 'checkbox',
        'default' => [
          'outBound_option' => '3',
        ],
        'add' => '4.1',
        'title' => 'Mailing Backend',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'profile_add_to_group_double_optin' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'profile_add_to_group_double_optin',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.1',
        'title' => 'Enable Double Opt-in for Profiles which use the \"Add to Group\" setting',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'When CiviMail is enabled and a profile uses the \"Add to Group\" setting, users who complete the profile form will receive a confirmation email. They must respond (opt-in) before they are added to the group.',
        'help_text' => '',
      ],
      'disable_mandatory_tokens_check' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'disable_mandatory_tokens_check',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.4',
        'title' => 'Disable check for mandatory tokens',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Don\'t check for presence of mandatory tokens (domain address; unsubscribe/opt-out) before sending mailings. WARNING: Mandatory tokens are a safe-guard which facilitate compliance with the US CAN-SPAM Act. They should only be disabled if your organization adopts other mechanisms for compliance or if your organization is not subject to CAN-SPAM.',
        'help_text' => '',
      ],
      'dedupe_email_default' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'dedupe_email_default',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 1,
        'add' => '4.5',
        'title' => 'CiviMail dedupes e-mail addresses by default',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Set the \"dedupe e-mail\" option when sending a new mailing to \"true\" by default.',
        'help_text' => '',
      ],
      'hash_mailing_url' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'hash_mailing_url',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.5',
        'title' => 'Hashed Mailing URL\'s',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, a randomized hash key will be used to reference the mailing URL in the mailing.viewUrl token, instead of the mailing ID',
        'help_text' => '',
      ],
      'civimail_multiple_bulk_emails' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'civimail_multiple_bulk_emails',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => 0,
        'add' => '4.5',
        'title' => 'Enable multiple bulk email address for a contact.',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'CiviMail will deliver a copy of the email to each bulk email listed for the contact. Enabling this setting will also change the options for the \"Email on Hold\" field in Advanced Search.',
        'help_text' => '',
      ],
      'include_message_id' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'include_message_id',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'default' => '',
        'add' => '4.5',
        'title' => 'Enable CiviMail to generate Message-ID header',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'mailerBatchLimit' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'mailerBatchLimit',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 4,
          'maxlength' => 8,
        ],
        'default' => 0,
        'add' => '4.7',
        'title' => 'Mailer Batch Limit',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Throttle email delivery by setting the maximum number of emails sent during each CiviMail run (0 = unlimited).',
        'help_text' => '',
      ],
      'mailerJobSize' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'mailerJobSize',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 4,
          'maxlength' => 8,
        ],
        'default' => 0,
        'add' => '4.7',
        'title' => 'Mailer Job Size',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If you want to utilize multi-threading enter the size you want your sub jobs to be split into. Recommended values are between 1,000 and 10,000. Use a lower value if your server has multiple cron jobs running simultaneously, but do not use values smaller than 1,000. Enter \"0\" to disable multi-threading and process mail as one single job - batch limits still apply.',
        'help_text' => '',
      ],
      'mailerJobsMax' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'mailerJobsMax',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 4,
          'maxlength' => 8,
        ],
        'default' => 0,
        'add' => '4.7',
        'title' => 'Mailer Cron Job Limit',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'The maximum number of mailer delivery jobs executing simultaneously (0 = allow as many processes to execute as started by cron)',
        'help_text' => '',
      ],
      'mailThrottleTime' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'mailThrottleTime',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 4,
          'maxlength' => 8,
        ],
        'default' => 0,
        'add' => '4.7',
        'title' => 'Mailer Throttle Time',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'The time to sleep in between each e-mail in micro seconds. Setting this above 0 allows you to control the rate at which e-mail messages are sent to the mail server, avoiding filling up the mail queue very quickly. Set to 0 to disable.',
        'help_text' => '',
      ],
      'verpSeparator' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'verpSeparator',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 4,
          'maxlength' => 32,
        ],
        'default' => '.',
        'add' => '4.7',
        'title' => 'VERP Separator',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Separator character used when CiviMail generates VERP (variable envelope return path) Mail-From addresses.',
        'help_text' => '',
      ],
      'write_activity_record' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'write_activity_record',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'CheckBox',
        'default' => '1',
        'add' => '4.7',
        'title' => 'Enable CiviMail to create activities on delivery',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'simple_mail_limit' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'simple_mail_limit',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => 4,
          'maxlength' => 8,
        ],
        'default' => 50,
        'title' => 'Simple mail limit',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'The number of emails sendable via simple mail. Make sure you understand the implications for your spam reputation and legal requirements for bulk emails before editing. As there is some risk both to your spam reputation and the products if this is misused it is a hidden setting',
        'help_text' => 'CiviCRM forces users sending more than this number of mails to use CiviMails. CiviMails have additional precautions: not sending to contacts who do not want bulk mail, adding domain name and opt out links. You should familiarise yourself with the law relevant to you on bulk mailings if changing this setting. For the US https://en.wikipedia.org/wiki/CAN-SPAM_Act_of_2003 is a good place to start.',
      ],
      'auto_recipient_rebuild' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'auto_recipient_rebuild',
        'type' => 'Boolean',
        'html_type' => 'checkbox',
        'quick_form_type' => 'CheckBox',
        'default' => '1',
        'title' => 'Enable automatic CiviMail recipient count display',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Enable this setting to rebuild recipient list automatically during composing mail. Disable will allow you to rebuild recipient manually.',
        'help_text' => 'CiviMail automatically fetches recipient list and count whenever mailing groups are included or excluded while composing bulk mail. This phenomena may degrade performance for large sites, so disable this setting to build and fetch recipients for selected groups, manually.',
      ],
      'allow_mail_from_logged_in_contact' => [
        'group_name' => 'Mailing Preferences',
        'group' => 'mailing',
        'name' => 'allow_mail_from_logged_in_contact',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'title' => 'Allow mail from logged in contact',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Allow sending email from the logged in contact\'s email address',
        'help_text' => 'CiviCRM allows you to send email from the domain from email addresses and the logged in contact id addresses by default. Disable this if you only want to allow the domain from addresses to be used.',
      ],
      'geoAPIKey' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Map Preferences',
        'group' => 'map',
        'name' => 'geoAPIKey',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '32',
          'maxlength' => '64',
        ],
        'default' => '',
        'title' => 'Geo Provider Key',
        'description' => 'Enter the API key or Application ID associated with your geocoding provider (not required for Yahoo).',
      ],
      'geoProvider' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Map Preferences',
        'group' => 'map',
        'name' => 'geoProvider',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::geoProvider',
        ],
        'default' => '',
        'title' => 'Geocoding Provider',
        'description' => 'This can be the same or different from the mapping provider selected.',
      ],
      'mapAPIKey' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Map Preferences',
        'group' => 'map',
        'name' => 'mapAPIKey',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_type' => 'text',
        'html_attributes' => [
          'size' => '32',
          'maxlength' => '64',
        ],
        'default' => '',
        'title' => 'Map Provider Key',
        'description' => 'Enter your API Key or Application ID. An API Key is required for the Google Maps API. Refer to developers.google.com for the latest information.',
      ],
      'mapProvider' => [
        'add' => '4.7',
        'help_text' => '',
        'is_domain' => 1,
        'is_contact' => 0,
        'group_name' => 'Map Preferences',
        'group' => 'map',
        'name' => 'mapProvider',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::mapProvider',
        ],
        'default' => '',
        'title' => 'Mapping Provider',
        'description' => 'Choose the mapping provider that has the best coverage for the majority of your contact addresses.',
      ],
      'default_renewal_contribution_page' => [
        'group_name' => 'Member Preferences',
        'group' => 'member',
        'name' => 'default_renewal_contribution_page',
        'type' => 'Integer',
        'html_type' => 'select',
        'default' => '',
        'pseudoconstant' => [
          'callback' => 'CRM_Contribute_PseudoConstant::contributionPage',
        ],
        'add' => '4.1',
        'title' => 'Default online membership renewal page',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If you select a default online contribution page for self-service membership renewals, a \"renew\" link pointing to that page will be displayed on the Contact Dashboard for memberships which were entered offline. You will need to ensure that the membership block for the selected online contribution page includes any currently available memberships.',
        'help_text' => '',
      ],
      'is_enabled' => [
        'group_name' => 'Multi Site Preferences',
        'group' => 'multisite',
        'name' => 'is_enabled',
        'title' => 'Enable Multi Site Configuration',
        'html_type' => 'checkbox',
        'type' => 'Boolean',
        'default' => 0,
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Make CiviCRM aware of multiple domains. You should configure a domain group if enabled',
        'documentation_link' => [
          'page' => 'Multi Site Installation',
          'resource' => 'wiki',
        ],
        'help_text' => '',
        'settings_pages' => [
          'multisite' => [
            'weight' => 10,
          ],
        ],
      ],
      'domain_group_id' => [
        'group_name' => 'Multi Site Preferences',
        'group' => 'multisite',
        'name' => 'domain_group_id',
        'title' => 'Multisite Domain Group',
        'type' => 'Integer',
        'html_type' => 'entity_reference',
        'entity_reference_options' => [
          'entity' => 'Group',
          'select' => [
            'minimumInputLength' => 0,
          ],
        ],
        'default' => 0,
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Contacts created on this site are added to this group',
        'help_text' => '',
        'settings_pages' => [
          'multisite' => [
            'weight' => 20,
          ],
        ],
      ],
      'event_price_set_domain_id' => [
        'group_name' => 'Multi Site Preferences',
        'group' => 'multisite',
        'name' => 'event_price_set_domain_id',
        'title' => 'Domain Event Price Set',
        'type' => 'Integer',
        'default' => 0,
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'uniq_email_per_site' => [
        'group_name' => 'Multi Site Preferences',
        'group' => 'multisite',
        'name' => 'uniq_email_per_site',
        'type' => 'Integer',
        'title' => 'Unique Email per Domain?',
        'default' => 0,
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'search_autocomplete_count' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'search_autocomplete_count',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'number',
        'default' => 10,
        'add' => '4.3',
        'title' => 'Autocomplete Results',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'The maximum number of contacts to show at a time when typing in an autocomplete field.',
        'help_text' => '',
      ],
      'enable_innodb_fts' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'enable_innodb_fts',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.4',
        'title' => 'InnoDB Full Text Search',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Enable InnoDB full-text search optimizations. (Requires MySQL 5.6+)',
        'help_text' => '',
        'on_change' => [
          '0' => [
            '0' => 'CRM_Core_InnoDBIndexer',
            '1' => 'onToggleFts',
          ],
        ],
      ],
      'fts_query_mode' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'fts_query_mode',
        'type' => 'String',
        'quick_form_type' => 'Element',
        'html_attributes' => [
          'size' => 64,
          'maxlength' => 64,
        ],
        'html_type' => 'text',
        'default' => 'simple',
        'add' => '4.5',
        'title' => 'How to handle full-tet queries',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => '',
        'help_text' => '',
      ],
      'includeOrderByClause' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'includeOrderByClause',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.6',
        'title' => 'Include Order By Clause',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If disabled, the search results will not be ordered. This may improve response time on search results on large datasets',
        'help_text' => '',
      ],
      'includeWildCardInName' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'includeWildCardInName',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.6',
        'title' => 'Automatic Wildcard',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, wildcards are automatically added to the beginning AND end of the search term when users search for contacts by Name. EXAMPLE: Searching for \'ada\' will return any contact whose name includes those letters - e.g. \'Adams, Janet\', \'Nadal, Jorge\', etc. If disabled, a wildcard is added to the end of the search term only. EXAMPLE: Searching for \'ada\' will return any contact whose last name begins with those letters - e.g. \'Adams, Janet\' but NOT \'Nadal, Jorge\'. Disabling this feature will speed up search significantly for larger databases, but users must manually enter wildcards (\'%\' or \'_\') to the beginning of the search term if they want to find all records which contain those letters. EXAMPLE: \'%ada\' will return \'Nadal, Jorge\'.',
        'help_text' => '',
      ],
      'includeEmailInName' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'includeEmailInName',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.6',
        'title' => 'Include Email',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, email addresses are automatically included when users search by Name. Disabling this feature will speed up search significantly for larger databases, but users will need to use the Email search fields (from Advanced Search, Search Builder, or Profiles) to find contacts by email address.',
        'help_text' => '',
      ],
      'includeNickNameInName' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'includeNickNameInName',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 0,
        'add' => '4.6',
        'title' => 'Include Nickname',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, nicknames are automatically included when users search by Name.',
        'help_text' => '',
      ],
      'includeAlphabeticalPager' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'includeAlphabeticalPager',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.6',
        'title' => 'Include Alphabetical Pager',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If disabled, the alphabetical pager will not be displayed on the search screens. This will improve response time on search results on large datasets.',
        'help_text' => '',
      ],
      'smartGroupCacheTimeout' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'smartGroupCacheTimeout',
        'type' => 'Integer',
        'quick_form_type' => 'Element',
        'html_type' => 'number',
        'default' => 5,
        'add' => '4.6',
        'title' => 'Smart group cache timeout',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'The number of minutes to cache smart group contacts. We strongly recommend that this value be greater than zero, since a value of zero means no caching at all. If your contact data changes frequently, you should set this value to at least 5 minutes.',
        'help_text' => '',
      ],
      'defaultSearchProfileID' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'defaultSearchProfileID',
        'type' => 'Integer',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [
          'class' => 'crm-select2',
        ],
        'pseudoconstant' => [
          'callback' => 'CRM_Admin_Form_Setting_Search::getAvailableProfiles',
        ],
        'default' => '',
        'add' => '4.6',
        'title' => 'Default Contact Search Profile',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If set, this will be the default profile used for contact search.',
        'help_text' => '',
      ],
      'prevNextBackend' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'prevNextBackend',
        'type' => 'String',
        'quick_form_type' => 'Select',
        'html_type' => 'Select',
        'html_attributes' => [],
        'default' => 'default',
        'add' => '5.9',
        'title' => 'PrevNext Cache',
        'is_domain' => 1,
        'is_contact' => 0,
        'pseudoconstant' => [
          'callback' => 'CRM_Core_BAO_PrevNextCache::getPrevNextBackends',
        ],
        'description' => 'When performing a search, how should the search-results be cached?',
        'help_text' => '',
      ],
      'searchPrimaryDetailsOnly' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'searchPrimaryDetailsOnly',
        'type' => 'Boolean',
        'quick_form_type' => 'YesNo',
        'default' => 1,
        'add' => '4.7',
        'title' => 'Search Primary Details Only',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'If enabled, only primary details (eg contact\'s primary email, phone, etc) will be included in Basic and Advanced Search results. Disabling this feature will allow users to match contacts using any email, phone etc detail.',
        'help_text' => '',
      ],
      'quicksearch_options' => [
        'group_name' => 'Search Preferences',
        'group' => 'Search Preferences',
        'name' => 'quicksearch_options',
        'type' => 'string',
        'serialize' => 1,
        'html_type' => 'checkboxes',
        'sortable' => TRUE,
        'pseudoconstant' => [
          'callback' => 'CRM_Core_SelectValues::quicksearchOptions',
        ],
        'default' => [
          '0' => 'sort_name',
          '1' => 'contact_id',
          '2' => 'external_identifier',
          '3' => 'first_name',
          '4' => 'last_name',
          '5' => 'email',
          '6' => 'phone_numeric',
          '7' => 'street_address',
          '8' => 'city',
          '9' => 'postal_code',
          '10' => 'job_title',
        ],
        'add' => '5.8',
        'title' => 'Quicksearch options',
        'is_domain' => '1',
        'is_contact' => 0,
        'description' => 'Which fields can be searched on in the menubar quicksearch box? Don\'t see your custom field here? Make sure it is marked as Searchable.',
        'help_text' => '',
      ],
      'userFrameworkResourceURL' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group' => 'url',
        'group_name' => 'URL Preferences',
        'name' => 'userFrameworkResourceURL',
        'title' => 'CiviCRM Resource URL',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Absolute URL of the location where the civicrm module or component has been installed.',
        'help_text' => '',
        'validate_callback' => 'CRM_Utils_Rule::urlish',
      ],
      'imageUploadURL' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group' => 'url',
        'group_name' => 'URL Preferences',
        'title' => 'Image Upload URL',
        'name' => 'imageUploadURL',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'URL of the location for uploaded image files.',
        'help_text' => '',
        'validate_callback' => 'CRM_Utils_Rule::urlish',
      ],
      'customCSSURL' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group' => 'url',
        'group_name' => 'URL Preferences',
        'name' => 'customCSSURL',
        'title' => 'Custom CSS URL',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'You can modify the look and feel of CiviCRM by adding your own stylesheet. For small to medium sized modifications, use your css file to override some of the styles in civicrm.css. Or if you need to make drastic changes, you can choose to disable civicrm.css completely.',
        'help_text' => '',
        'validate_callback' => 'CRM_Utils_Rule::urlish',
      ],
      'extensionsURL' => [
        'bootstrap_comment' => 'This is a boot setting which may be loaded during bootstrap. Defaults are loaded via SettingsBag::getSystemDefaults().',
        'group' => 'url',
        'group_name' => 'URL Preferences',
        'title' => 'Extension Resource URL',
        'name' => 'extensionsURL',
        'type' => 'String',
        'html_type' => 'text',
        'quick_form_type' => 'Element',
        'default' => '',
        'add' => '4.1',
        'is_domain' => 1,
        'is_contact' => 0,
        'description' => 'Base URL for extension resources (images, stylesheets, etc). This should match extensionsDir.',
        'help_text' => '',
        'validate_callback' => 'CRM_Utils_Rule::urlish',
      ],
    ],
  ];

  return $expectedResult;
}

/*
* This example has been generated from the API test suite.
* The test that created it is called "testGetFields"
* and can be found at:
* https://github.com/civicrm/civicrm-core/blob/master/tests/phpunit/api/v3/SettingTest.php
*
* You can see the outcome of the API tests at
* https://test.civicrm.org/job/CiviCRM-Core-Matrix/
*
* To Learn about the API read
* https://docs.civicrm.org/dev/en/latest/api/
*
* Browse the API on your own site with the API Explorer. It is in the main
* CiviCRM menu, under: Support > Development > API Explorer.
*
* Read more about testing here
* https://docs.civicrm.org/dev/en/latest/testing/
*
* API Standards documentation:
* https://docs.civicrm.org/dev/en/latest/framework/api-architecture/
*/
