/*
 * Copyright (c) 2001-2004 MUSIC TECHNOLOGY GROUP (MTG)
 *                         UNIVERSITAT POMPEU FABRA
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include "FreqShift.hxx"
#include "ProcessingFactory.hxx"

namespace CLAM
{

namespace Hidden
{
	static const char * metadata[] = {
		"key", "FreqShift",
	//	"category", "Spectral Transformations",
	//	"description", "FreqShift",
		0
	};
	static FactoryRegistrator<ProcessingFactory, FreqShift> reg = metadata;
}


bool FreqShift::Do(const Spectrum& in, Spectrum& out)
{

	if ( !mConfig.GetPreserveOuts() )
	{
		out = in; //TODO big cludge for streaming
	}

	//xamat: todo, we just hope the spectrum is in mag/phase format
	DataArray& iMagArray =  in.GetMagBuffer();
	DataArray& iPhaseArray = in.GetPhaseBuffer();
	TSize spectrumSize = in.GetSize();
	//I need to keep a copy of the magnitude array to guarantee inplace processing is possible
	mOMagArray.Resize(spectrumSize);
	mOMagArray.SetSize(spectrumSize);
	mOPhaseArray.Resize(spectrumSize);
	mOPhaseArray.SetSize(spectrumSize);
	
	//actually this is one over the spectral resolution, but it will be better for what I need afterwords
	TData spectralResolution = spectrumSize/in.GetSpectralRange();
	int amount = Round(mShiftAmount.GetLastValue() * spectralResolution);
	
	for(int i = 0; i<spectrumSize; i++)
	{
		if(i<amount)
		{
			mOMagArray[i] = 0;
			mOPhaseArray[i] = 0;
		}
		else if(i>spectrumSize+amount)
		{
			mOMagArray[i] = 0;
			mOPhaseArray[i] = 0;
		}
		else
		{
			mOMagArray[i] = iMagArray[i-amount];
			mOPhaseArray[i] = iPhaseArray[i-amount];
		}
	}
	out.SetMagBuffer(mOMagArray);
	out.SetPhaseBuffer(mOPhaseArray);
	return true;
}


}

