/* $Id: hawki_alloc.c,v 1.1 2008/11/26 09:53:31 cgarcia Exp $
 *
 * This file is part of the HAWKI Pipeline
 * Copyright (C) 2002,2003 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * $Author: cgarcia $
 * $Date: 2008/11/26 09:53:31 $
 * $Revision: 1.1 $
 * $Name: hawki-1_8_12 $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

/*-----------------------------------------------------------------------------
                                   Includes
 -----------------------------------------------------------------------------*/

#include <cpl.h>
#include "hawki_utils.h"
#include "hawki_alloc.h"

/*----------------------------------------------------------------------------*/
/**
 * @defgroup hawki_alloc       Allocation rutines
 */
/*----------------------------------------------------------------------------*/

/**@{*/

/** 
  @brief  Deallocates a set of four tables  
  @param  tables  The tables to deallocate
  @return   0 if everything is ok, -1 otherwise

 */ 
int hawki_table_delete(cpl_table ** table)
{
    int idet;
    
    for(idet = 0; idet < HAWKI_NB_DETECTORS; ++idet)
        cpl_table_delete(table[idet]);
    cpl_free(table);
    if(cpl_errorstate_get() != CPL_ERROR_NONE)
        return -1;
    return 0;
}

/** 
  @brief  Allocates a set of four tables  
  @param  nrow  The number of rows of each table
  @return   The allocated tables

 */ 
cpl_table ** hawki_table_new(int nrow)
{
    int idet;
    cpl_table ** tables;
    
    tables = cpl_malloc(sizeof(cpl_table *) * HAWKI_NB_DETECTORS);
    for(idet = 0; idet < HAWKI_NB_DETECTORS; ++idet)
        tables[idet] = cpl_table_new(nrow);
    
    if(cpl_errorstate_get() != CPL_ERROR_NONE)
        return NULL;
    return tables;    
}

/**@}*/
