#include "netbuffer"

void Netbuffer::copy (Netbuffer const &other) {
    debugmsg("Netbuffer: copying other\n");
    
    buf_sz   	= other.buf_sz;
    buf_alloced = other.buf_alloced;
    LOCK_MALLOC;
    buf_data = (char*)malloc(buf_alloced);
    UNLOCK_MALLOC;
    if (!buf_data)
	throw Error("Memory fault in Netbuffer::copy");

    memcpy (buf_data, other.buf_data, buf_alloced);
}
