## 113.00.00

- Upgraded from OCaml `4.02.1` to `4.02.2`

## 112.24.00

- Added syntax to use `Sexp.to_string_mach` rather than `Sexp.to_string_hum`.

  Added syntax `%{sexp#mach:<type>}`, which is like `%{sexp:<type>}`,
  except it calls `Sexplib.Sexp.to_string_mach` instead of
  `Sexplib.Sexp.to_string_hum`.

  In fact, you can put any identifier after the `sexp#` and it will call
  `Sexplib.Sexp.to_string_<that identifier>`; however, there are no other
  such functions right now.

## 112.17.00

- Changed `%{M.x}` to call `M.x` instead of `M.Format.x`.

  This is more natural and makes it easy to call arbitrary other
  functions.
- Added syntax `%{M#x}`, which calls `M.to_string_x`.

  This makes it easy to use existing modules, since calling functions
  `to_string` or `to_string_x` is already the convention.

## 112.01.00

- Fixed uses of `printf=-style`format strings that have unspecified
  behavior in OCaml 4.02 and will become errors.
- Support substitution in format string (lost with 4.02 compatibility)

## 111.25.00

- Fix 4.02 compatibility.

## 111.21.00

- Fixed a bug in which custom-printf syntax was incompatible with
  labeled arguments.

    For example, the preprocessor used to raise an exception on this code:

        let f ~labeled_arg:() fmt = ksprintf (fun _ -> ()) fmt in
        f !"hello" ~labeled_arg:()

## 111.03.00

- Simplified the code generated by `pa_custom_printf` to make it
  more readable.

## 109.60.00

- Compatibility with warning 7 (method override)

## 109.27.00

- Added missing registration of `custom_printf`'s Camlp4 filter so
  that it works in the toplevel.

## 109.14.00

- initial import
  Added support for `%{<Module>}` in `printf`-style format strings.

    If you put `!` before a format string, it allows the use of a spec
    like `%{<Module>}` in the format string.  For example, using
    `%{Time}` wraps `Time.to_string` around the appropriate argument.

    It also allows different formats for a given type:
    `%{<Module>.<identifier>}` wraps `<Module>.Format.<identifier>`
    around the appropriate argument.  For example, `%{Float.pretty}`
    would wrap `Float.Format.pretty` around the appropriate argument.

