/* This file is -*-C++-*-
------------------------------------------------------------------------------
denef - Decode NEF image files
Copyright (C) 2000 Daniel Stephens (daniel@cheeseplant.org)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
------------------------------------------------------------------------------

$Id: interp.h,v 1.6 2000/09/18 07:51:43 daniel Exp $

*/

#ifndef INTERP_H_INCLUDED
#define INTERP_H_INCLUDED

#include "nefdata.h"

class ifInterpolator
{
private:
public:
    virtual ~ifInterpolator();

    virtual int Fringe() const = 0;
    virtual int Max_Width() const = 0;
    virtual int Max_Height() const = 0;

    virtual void Interpolate(const nefImageData &nef,
			     int xofs, int yofs, int wid, int hgt,
			     fullImageData &result,
			     int rxofs, int ryofs) = 0;
};

class nullInterpolator : public ifInterpolator
{
public:
    nullInterpolator();
    ~nullInterpolator();
    
    int Fringe() const;
    int Max_Width() const;
    int Max_Height() const;

    void Interpolate(const nefImageData &nef,
		     int xofs, int yofs, int wid, int hgt,
		     fullImageData &result,
		     int rxofs, int ryofs);
};

class basicInterpolator : public ifInterpolator
{
public:
    basicInterpolator();
    ~basicInterpolator();
    
    int Fringe() const;
    int Max_Width() const;
    int Max_Height() const;

    void Interpolate(const nefImageData &nef,
		     int xofs, int yofs, int wid, int hgt,
		     fullImageData &result,
		     int rxofs, int ryofs);
};

class luminanceInterpolator : public ifInterpolator
{
private:
    double *tmpY,*tmpCr,*tmpCb;
public:
    luminanceInterpolator();
    ~luminanceInterpolator();
    
    int Fringe() const;
    int Max_Width() const;
    int Max_Height() const;

    void Interpolate(const nefImageData &nef,
		     int xofs, int yofs, int wid, int hgt,
		     fullImageData &result,
		     int rxofs, int ryofs);
};

class gradientLuminanceInterpolator : public ifInterpolator
{
private:
    double *tmpY,*tmpCr,*tmpCb;
public:
    gradientLuminanceInterpolator();
    ~gradientLuminanceInterpolator();
    
    int Fringe() const;
    int Max_Width() const;
    int Max_Height() const;

    void Interpolate(const nefImageData &nef,
		     int xofs, int yofs, int wid, int hgt,
		     fullImageData &result,
		     int rxofs, int ryofs);
};

class rgbInterpolator : public ifInterpolator
{
private:
    double *tmpRed,*tmpGreen,*tmpBlue;
public:
    rgbInterpolator();
    ~rgbInterpolator();
    
    int Fringe() const;
    int Max_Width() const;
    int Max_Height() const;

    void Interpolate(const nefImageData &nef,
		     int xofs, int yofs, int wid, int hgt,
		     fullImageData &result,
		     int rxofs, int ryofs);
};

#endif /* INTERP_H_INCLUDED */







