/*
 
   Derby - Class org.apache.derby.client.net.ClientJDBCObjectFactoryImpl42
 
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at
 
      http://www.apache.org/licenses/LICENSE-2.0
 
   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
 
 */

package org.apache.derby.client.net;

import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import org.apache.derby.client.am.SqlException;

import org.apache.derby.client.ClientPooledConnection;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientCallableStatement;
import org.apache.derby.client.am.ClientCallableStatement42;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.LogicalCallableStatement;
import org.apache.derby.client.am.LogicalCallableStatement42;
import org.apache.derby.client.am.LogicalPreparedStatement;
import org.apache.derby.client.am.LogicalPreparedStatement42;
import org.apache.derby.client.am.ClientPreparedStatement;
import org.apache.derby.client.am.ClientPreparedStatement42;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClientResultSet;
import org.apache.derby.client.am.MaterialStatement;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.StatementCacheInteractor;
import org.apache.derby.client.am.stmtcache.StatementKey;

/**
 * Implements the ClientJDBCObjectFactory interface and returns the JDBC 4.2
 * specific classes.
 */
public class ClientJDBCObjectFactoryImpl42 extends ClientJDBCObjectFactoryImpl
{
    /**
     * This method is overridden on JVM 8 to take advantage of long
     * update counts.
     */
    protected   BatchUpdateException   newBatchUpdateException
        ( String message, String sqlState, int errorCode, long[] updateCounts, SqlException cause )
    {
        return new BatchUpdateException(
            message,
            sqlState,
            errorCode,
            updateCounts,
            cause);
    }

    /**
     * Returns a PreparedStatement.
     */
    public ClientPreparedStatement newPreparedStatement(Agent agent,
            ClientConnection connection,
            String sql,Section section,ClientPooledConnection cpc) 
            throws SqlException {
        return new ClientPreparedStatement42(agent,connection,sql,section,cpc);
    }
    
    /**
     *
     * This method returns an instance of PreparedStatement
     * which implements java.sql.PreparedStatement.
     * It has the ClientPooledConnection as one of its parameters
     * this is used to raise the Statement Events when the prepared
     * statement is closed.
     */
    public ClientPreparedStatement newPreparedStatement(Agent agent,
            ClientConnection connection,
            String sql,int type,int concurrency,
            int holdability,int autoGeneratedKeys,
            String [] columnNames,
            int[] columnIndexes, ClientPooledConnection cpc) 
            throws SqlException {

        return new ClientPreparedStatement42(
            agent,
            connection,
            sql,
            type,
            concurrency,
            holdability,
            autoGeneratedKeys,
            columnNames,
            columnIndexes,
            cpc);
    }

    /**
     * Returns a new logical prepared statement object.
     */
    public LogicalPreparedStatement newLogicalPreparedStatement(
            PreparedStatement ps,
            StatementKey stmtKey,
            StatementCacheInteractor cacheInteractor) {
        return new LogicalPreparedStatement42(ps, stmtKey, cacheInteractor);
    }
    
    /**
     * returns an instance of org.apache.derby.client.net.NetResultSet
     */
    public ClientResultSet newNetResultSet(Agent netAgent,
            MaterialStatement netStatement,
            Cursor cursor,int qryprctyp,int sqlcsrhld,
            int qryattscr,int qryattsns,int qryattset,long qryinsid,
            int actualResultSetType,int actualResultSetConcurrency,
            int actualResultSetHoldability) throws SqlException {
        return new NetResultSet42((NetAgent)netAgent,(NetStatement)netStatement,
                cursor,
                qryprctyp, sqlcsrhld, qryattscr, qryattsns, qryattset, qryinsid,
                actualResultSetType,actualResultSetConcurrency,
                actualResultSetHoldability);
    }

    /** return a ClientCallableStatement42 object */
    public ClientCallableStatement newCallableStatement(Agent agent,
            ClientConnection connection,
            String sql,int type,int concurrency,
            int holdability,ClientPooledConnection cpc) throws SqlException {

        return new ClientCallableStatement42(
            agent,
            connection,
            sql,
            type,
            concurrency,
            holdability,
            cpc);
    }

    /**
     * Returns a new logical callable statement object.
     */
    public LogicalCallableStatement newLogicalCallableStatement(
            CallableStatement cs,
            StatementKey stmtKey,
            StatementCacheInteractor cacheInteractor) {
        return new LogicalCallableStatement42(cs, stmtKey, cacheInteractor);
    }
    
}

    

