/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 by Stephen McInerney                   *
 *   spm@stedee.id.au                                                      *
 *                                                                         *
 *   $Id: messages.c 58 2006-01-02 10:40:49Z steve $
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/************************************************************************
 ************************************************************************
 * messages.c
 *
 *  All the various messages to be used
 *
 ************************************************************************
 ************************************************************************/

#include "dnshistory.h"

int g_verbosity = VERBOSE0;                     /* How many extra stuff to show. If 0, none
                                                   Bigger numbers, show more. */

/************************************************************************
 *                              MESSAGES                                *
 *                                                                      *
 * Are of the format msg_<level>_<name>                                 *
 *  Where level is:                                                     *
 *    I :- Informational                                                *
 *    W :- Warning                                                      *
 *    E :- Error, but not fatal                                         *
 *    F :- Fatal Error                                                  *
 *                                                                      *
 *    vx : - where x is numerical from 1 (1,2,3 etc)                    *
 *              is a debugging/verbosity message                        *
 *              The higher the number, the less likely to be seen       *
 ************************************************************************/
const char *msg_I_number_bad_lines = "INFO: Log Files(s) had BAD lines: ";


const char *msg_W_exceeded_verbosity = "WARN: Too many 'v' options. Setting to Max Verbosness";
const char *msg_W_line_too_big = "WARN: Line too big. Ignoring.";
const char *msg_W_re_match_failed = "WARN: PCRE: No match. Line Number: %lu\n  %s";
const char *msg_W_re_match_error = "WARN: PCRE: Matching error. Line Number: %lu\n  %s";
const char *msg_W_mismatched_lines = "WARN: Possibly Mismatched Log Lines. Line Number: %lu\n ++ %s -- %s";
const char *msg_W_import_line_too_long = "WARN: Import line too long: %lu\n";
const char *msg_W_import_line_failure = "WARN: Failed to import line: %lu\n";

const char *msg_namelookup_try_agin = "Name could not be looked up at this time; Try again later";
const char *msg_namelookup_default = "Some other error occoured: ";

const char *msg_v1_hashdb = "Entering: Open Hash DB";
const char *msg_v2_create_hashdb = "Creating Hash DB: ";
const char *msg_v2_create_dbcache = "Setting Cache Size for Hash DB: ";
const char *msg_v2_no_dbcache = "Cache <= 0. Not Creating. Size: ";


const char *msg_E_log_misordered = "ERROR! Current Time is older than 1st logged time entry: ";
const char *msg_E_re_too_many_substrings = "ERROR! Too many substrings. Line Number: %lu  Max Substrings: %d\n";
const char *msg_E_ip_conversion = "ERROR! IP conversion: %d - %s\n";

const char *msg_E_substring_extraction = "ERROR! Failed to extract substring: %d  Line Number: %lu\n";
const char *msg_E_pcre_no_memory = " PCRE: Insufficient Memory.%s\n";
const char *msg_E_pcre_nonexist_substring = " PCRE: Substring doesn't exist.%s\n";
const char *msg_E_pcre_unknown = " PCRE: Unknown PCRE Error: %d\n";

const char *msg_E_thread_stack_resize = "ERROR! Thread Stack Resize: %d\n";
const char *msg_E_thread_creation = "ERROR! Thread Creation: %d\n";
const char *msg_E_thread_lock = "ERROR! Thread Locking: %d\n";
const char *msg_E_thread_unlock = "ERROR! Thread Unlocking: %d\n";

const char *msg_F_db_create = "FATAL ERROR! DB Create Failure: %s\n";
const char *msg_F_db_cache = "FATAL ERROR! DB Set Cache Size Failure: %s\n";
const char *msg_F_db_close = "FATAL ERROR! Error closing DB. Possible Corruption! : %d\n";
const char *msg_F_db_cursor = "FATAL ERROR! DB Cursor Creation Failure.%s\n";

const char *msg_F_file_open = "FATAL ERROR! Failed to open file: %s\n";
const char *msg_F_mem_alloc_hash = "FATAL ERROR! Failed to allocate memory for hash data.%s\n";
const char *msg_F_memory_alloc = "FATAL ERROR! Failed to allocate memory.%s\n";

const char *msg_F_pcre_failed_compilation = "FATAL ERROR! PCRE compilation failed at offset";
const char *msg_F_run_start_datetime = "FATAL ERROR! Can't extract starting date/time. Sorry things didn't work out...";
const char *msg_F_vital_substring = "FATAL ERROR! Failed to extract vital substring: %d\n";

const char *msg_F_incompatible_options = "FATAL ERROR! Incompatible Option Settings!";
const char *msg_F_mismatched_lines = "FATAL ERROR! Totally Mismatched Log Lines. Line Number %lu\n %s %s\n";
const char *msg_F_early_log_termination = "FATAL ERROR! Recombine Log has terminated early! Line: %lu\n";

/************************************************************************
 ************************************************************************
 *                      END OF FILE                                     *
 ************************************************************************
 ************************************************************************/
