// -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 2 -*-
// vi: set et ts=4 sw=2 sts=2:
#include <config.h>

#define  DUNE_FUNCTION_HH_SILENCE_DEPRECATION

#include <iostream>

#include <dune/common/exceptions.hh>
#include <dune/common/parallel/mpihelper.hh>

#include <dune/grid/uggrid.hh>
#include <dune/grid/io/file/gmshreader.hh>

#include <dune/localfunctions/test/test-localfe.hh>

#include <dune/functions/functionspacebases/nedelecbasis.hh>
#include <dune/functions/functionspacebases/raviartthomasbasis.hh>


using namespace Dune;

int main (int argc, char* argv[]) try
{
  Dune::MPIHelper::instance(argc, argv);

  // Generate grid for testing
  const int dim = 2;
  using Grid = UGGrid<dim>;

  const std::string path = std::string(DUNE_GRID_EXAMPLE_GRIDS_PATH) + "gmsh/";

  std::string filename = path + "curved2d.msh";
  std::shared_ptr<Grid> grid = GmshReader<Grid>::read(filename);

  using GridView = typename Grid::LeafGridView;
  GridView gridView = grid->leafGridView();

  ///////////////////////////////////////////////////////////////////////
  //  Test GlobalValuedLocalFiniteElement for a H(div)-conforming space
  //  We use the Raviart-Thomas basis.
  ///////////////////////////////////////////////////////////////////////

  using Basis = Functions::RaviartThomasBasis<GridView,0>;
  Basis rtBasis(gridView);

  auto localView = rtBasis.localView();

  for (const auto& element : elements(gridView))
  {
    localView.bind(element);

    testFE(localView.tree().finiteElement(), DisableNone, 1 /* diffOrder */);
  }

  ///////////////////////////////////////////////////////////////////////
  //  Test GlobalValuedLocalFiniteElement for a H(curl)-conforming space
  //  We use the Nedelec basis of the first kind.
  ///////////////////////////////////////////////////////////////////////

  using namespace Functions::BasisFactory;
  {
    auto nedelecBasis = makeBasis(gridView, nedelec<1,1,double>());

    auto localView = nedelecBasis.localView();

    for (const auto& element : elements(gridView))
    {
      localView.bind(element);
      testFE(localView.tree().finiteElement(), DisableNone, 1 /* diffOrder */);
    }
  }

} catch (Exception &e)
{
  std::cerr << "Dune reported error: " << e.what() << std::endl;
  return 1;
}
