! (C) Copyright 2005- ECMWF.
! (C) Copyright 2013- Meteo France.
! 
! This software is licensed under the terms of the Apache Licence Version 2.0
! which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
! In applying this licence, ECMWF does not waive the privileges and immunities
! granted to it by virtue of its status as an intergovernmental organisation
! nor does it submit to any jurisdiction.
!

!! C bindings to the MPI and MPL routines
!! Please include "mpl.h" for the C interfaces

FUNCTION FORTRAN_MPI_ABORT(KRC) BIND(C,NAME="fortran_mpi_abort") RESULT(IRET)
    USE MPL_MPIF, ONLY : MPI_COMM_WORLD
    IMPLICIT NONE
    INTEGER,INTENT(IN),VALUE :: KRC
    INTEGER :: IRET
    CALL MPI_ABORT(MPI_COMM_WORLD,KRC,IRET)
END FUNCTION FORTRAN_MPI_ABORT

FUNCTION FORTRAN_MPI_INITIALIZED() BIND(C,NAME="fortran_mpi_initialized") RESULT(IRET)
    IMPLICIT NONE
    INTEGER :: IRET
    INTEGER :: IERROR
    LOGICAL :: LINIT
    CALL MPI_INITIALIZED(LINIT,IERROR)
    IF (LINIT) THEN
      IRET = 1
    ELSE
      IRET = 0
    ENDIF
END FUNCTION FORTRAN_MPI_INITIALIZED

FUNCTION MPL_INIT_BINDC() BIND(C,NAME="mpl_init") RESULT(KERROR)
    USE ISO_C_BINDING, ONLY : C_INT
    USE MPL_MODULE,    ONLY : MPL_INIT
    IMPLICIT NONE
    INTEGER(KIND=C_INT) :: KERROR
    CALL MPL_INIT(KERROR=KERROR,LDINFO=.FALSE.)
END FUNCTION MPL_INIT_BINDC

FUNCTION MPL_END_BINDC() BIND(C,NAME="mpl_end") RESULT(KERROR)
    USE ISO_C_BINDING, ONLY : C_INT
    USE MPL_MODULE,    ONLY : MPL_END
    IMPLICIT NONE
    INTEGER(KIND=C_INT) :: KERROR
    CALL MPL_END(KERROR=KERROR)
END FUNCTION MPL_END_BINDC

FUNCTION MPL_MYRANK_BINDC() BIND(C,NAME="mpl_myrank") RESULT(MYRANK)
    USE ISO_C_BINDING, ONLY : C_INT
    USE MPL_MODULE,    ONLY : MPL_MYRANK
    IMPLICIT NONE
    INTEGER(KIND=C_INT) :: MYRANK
    MYRANK = MPL_MYRANK()
END FUNCTION

FUNCTION MPL_COMM_BINDC() BIND(C,NAME="mpl_comm") RESULT(NCOMM)
    USE ISO_C_BINDING, ONLY : C_INT
    USE MPL_MODULE,    ONLY : MPL_COMM
    IMPLICIT NONE
    INTEGER(KIND=C_INT) :: NCOMM
    NCOMM = MPL_COMM
END FUNCTION

FUNCTION MPL_COMM_OML_BINDC(OML_THREAD) BIND(C,NAME="mpl_comm_oml") RESULT(NCOMM)
    USE ISO_C_BINDING, ONLY : C_INT
    USE MPL_MODULE,    ONLY : MPL_COMM_OML
    IMPLICIT NONE
    INTEGER(KIND=C_INT) :: NCOMM
    INTEGER(KIND=C_INT), VALUE, INTENT(IN) :: OML_THREAD
    NCOMM = MPL_COMM_OML(OML_THREAD)
END FUNCTION


! SUBROUTINE CMPL_ABORT(CDMESS)
! USE MPL_MODULE
! IMPLICIT NONE
! CHARACTER(LEN=*) CDMESS
! CALL MPL_ABORT(CDMESS)
! END SUBROUTINE CMPL_ABORT

! FUNCTION CMPL_NPROC()
! USE MPL_MODULE
! IMPLICIT NONE
! INTEGER CMPL_NPROC
! CMPL_NPROC=MPL_NPROC()
! END FUNCTION CMPL_NPROC

! FUNCTION CMPL_MYRANK()
! USE MPL_MODULE
! IMPLICIT NONE
! INTEGER CMPL_MYRANK
! CMPL_MYRANK=MPL_MYRANK()
! END FUNCTION CMPL_MYRANK

! SUBROUTINE CMPL_BARRIER(KERROR)
! USE MPL_MODULE
! IMPLICIT NONE
! INTEGER KERROR
! CALL MPL_BARRIER(KERROR=KERROR)
! END SUBROUTINE CMPL_BARRIER

! SUBROUTINE CMPL_END(KERROR)
! USE MPL_MODULE
! IMPLICIT NONE
! INTEGER KERROR
! CALL MPL_END(KERROR=KERROR)
! END SUBROUTINE CMPL_END

! SUBROUTINE CMPL_GETARG(KARGNO, CDARG)
! USE MPL_MODULE
! IMPLICIT NONE
! INTEGER KARGNO
! CHARACTER(LEN=*) CDARG
! CALL MPL_GETARG(KARGNO, CDARG)
! END SUBROUTINE CMPL_GETARG

! FUNCTION CMPL_IARGC()
! USE MPL_MODULE
! IMPLICIT NONE
! INTEGER CMPL_IARGC
! CMPL_IARGC = MPL_IARGC()
! END FUNCTION CMPL_IARGC
