/* backend.c generated by valac 0.36.1.697-2b74, the Vala compiler
 * generated from backend.vala, do not modify */

/*
 * Copyright (C) 2013 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <folks-test.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define ORG_BLUEZ_TYPE_MOCK (org_bluez_mock_get_type ())
#define ORG_BLUEZ_MOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_TYPE_MOCK, orgbluezMock))
#define ORG_BLUEZ_IS_MOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_TYPE_MOCK))
#define ORG_BLUEZ_MOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_TYPE_MOCK, orgbluezMockIface))

typedef struct _orgbluezMock orgbluezMock;
typedef struct _orgbluezMockIface orgbluezMockIface;

#define ORG_BLUEZ_TYPE_MOCK_PROXY (org_bluez_mock_proxy_get_type ())
typedef GDBusProxy orgbluezMockProxy;
typedef GDBusProxyClass orgbluezMockProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define ORG_BLUEZ_OBEX_TYPE_MOCK (org_bluez_obex_mock_get_type ())
#define ORG_BLUEZ_OBEX_MOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_OBEX_TYPE_MOCK, orgbluezobexMock))
#define ORG_BLUEZ_OBEX_IS_MOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_OBEX_TYPE_MOCK))
#define ORG_BLUEZ_OBEX_MOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_OBEX_TYPE_MOCK, orgbluezobexMockIface))

typedef struct _orgbluezobexMock orgbluezobexMock;
typedef struct _orgbluezobexMockIface orgbluezobexMockIface;

#define ORG_BLUEZ_OBEX_TYPE_MOCK_PROXY (org_bluez_obex_mock_proxy_get_type ())
enum  {
	ORG_BLUEZ_OBEX_MOCK_TRANSFER_CREATED_SIGNAL,
	ORG_BLUEZ_OBEX_MOCK_LAST_SIGNAL
};
static guint org_bluez_obex_mock_signals[ORG_BLUEZ_OBEX_MOCK_LAST_SIGNAL] = {0};
typedef GDBusProxy orgbluezobexMockProxy;
typedef GDBusProxyClass orgbluezobexMockProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK (org_bluez_obex_transfer1_mock_get_type ())
#define ORG_BLUEZ_OBEX_TRANSFER1_MOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK, orgbluezobextransfer1Mock))
#define ORG_BLUEZ_OBEX_TRANSFER1_IS_MOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK))
#define ORG_BLUEZ_OBEX_TRANSFER1_MOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK, orgbluezobextransfer1MockIface))

typedef struct _orgbluezobextransfer1Mock orgbluezobextransfer1Mock;
typedef struct _orgbluezobextransfer1MockIface orgbluezobextransfer1MockIface;

#define ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK_PROXY (org_bluez_obex_transfer1_mock_proxy_get_type ())
typedef GDBusProxy orgbluezobextransfer1MockProxy;
typedef GDBusProxyClass orgbluezobextransfer1MockProxyClass;

#define BLUEZ_TEST_TYPE_BACKEND (bluez_test_backend_get_type ())
#define BLUEZ_TEST_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BLUEZ_TEST_TYPE_BACKEND, BluezTestBackend))
#define BLUEZ_TEST_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BLUEZ_TEST_TYPE_BACKEND, BluezTestBackendClass))
#define BLUEZ_TEST_IS_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BLUEZ_TEST_TYPE_BACKEND))
#define BLUEZ_TEST_IS_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BLUEZ_TEST_TYPE_BACKEND))
#define BLUEZ_TEST_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BLUEZ_TEST_TYPE_BACKEND, BluezTestBackendClass))

typedef struct _BluezTestBackend BluezTestBackend;
typedef struct _BluezTestBackendClass BluezTestBackendClass;
typedef struct _BluezTestBackendPrivate BluezTestBackendPrivate;
enum  {
	BLUEZ_TEST_BACKEND_DUMMY_PROPERTY,
	BLUEZ_TEST_BACKEND_LAST_PROPERTY
};
static GParamSpec* bluez_test_backend_properties[BLUEZ_TEST_BACKEND_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _bluez_test_backend_unref0(var) ((var == NULL) ? NULL : (var = (bluez_test_backend_unref (var), NULL)))
typedef struct _BluezTestParamSpecBackend BluezTestParamSpecBackend;

struct _orgbluezMockIface {
	GTypeInterface parent_iface;
	gchar* (*add_adapter) (orgbluezMock* self, const gchar* device_name, const gchar* system_name, GError** error);
	gchar* (*add_device) (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, const gchar* alias, GError** error);
	void (*pair_device) (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error);
	void (*block_device) (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error);
};

struct _orgbluezobexMockIface {
	GTypeInterface parent_iface;
};

struct _orgbluezobextransfer1MockIface {
	GTypeInterface parent_iface;
	void (*update_status) (orgbluezobextransfer1Mock* self, gboolean is_complete, GError** error);
};

struct _BluezTestBackend {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BluezTestBackendPrivate * priv;
};

struct _BluezTestBackendClass {
	GTypeClass parent_class;
	void (*finalize) (BluezTestBackend *self);
};

struct _BluezTestBackendPrivate {
	orgbluezMock* _mock_bluez;
	orgfreedesktopDBusMock* _mock_bluez_base;
	orgbluezobexMock* _mock_obex;
	orgfreedesktopDBusMock* _mock_obex_base;
};

struct _Block1Data {
	int _ref_count_;
	BluezTestBackend* self;
	gchar* vcard;
};

struct _BluezTestParamSpecBackend {
	GParamSpec parent_instance;
};


static gpointer bluez_test_backend_parent_class = NULL;

GType org_bluez_mock_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_mock_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_mock_get_type (void) G_GNUC_CONST;
gchar* org_bluez_mock_add_adapter (orgbluezMock* self, const gchar* device_name, const gchar* system_name, GError** error);
gchar* org_bluez_mock_add_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, const gchar* alias, GError** error);
void org_bluez_mock_pair_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error);
void org_bluez_mock_block_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error);
static void org_bluez_mock_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gchar* org_bluez_mock_proxy_add_adapter (orgbluezMock* self, const gchar* device_name, const gchar* system_name, GError** error);
static gchar* org_bluez_mock_proxy_add_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, const gchar* alias, GError** error);
static void org_bluez_mock_proxy_pair_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error);
static void org_bluez_mock_proxy_block_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error);
static void org_bluez_mock_proxy_org_bluez_mock_interface_init (orgbluezMockIface* iface);
static void _dbus_org_bluez_mock_add_adapter (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_mock_add_device (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_mock_pair_device (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_org_bluez_mock_block_device (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void org_bluez_mock_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* org_bluez_mock_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean org_bluez_mock_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _org_bluez_mock_unregister_object (gpointer user_data);
GType org_bluez_obex_mock_get_type (void) G_GNUC_CONST;
GType org_bluez_obex_mock_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_obex_mock_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
static void g_cclosure_user_marshal_VOID__STRING_BOXED_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void org_bluez_obex_mock_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_org_bluez_obex_mock_transfer_created (orgbluezobexMock* self, GVariant* parameters);
static void org_bluez_obex_mock_proxy_org_bluez_obex_mock_interface_init (orgbluezobexMockIface* iface);
static void org_bluez_obex_mock_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* org_bluez_obex_mock_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean org_bluez_obex_mock_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_org_bluez_obex_mock_transfer_created (GObject* _sender, const gchar* path, GHashTable* filters, const gchar* transfer_filename, gpointer* _data);
static void _org_bluez_obex_mock_unregister_object (gpointer user_data);
GType org_bluez_obex_transfer1_mock_proxy_get_type (void) G_GNUC_CONST;
guint org_bluez_obex_transfer1_mock_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType org_bluez_obex_transfer1_mock_get_type (void) G_GNUC_CONST;
void org_bluez_obex_transfer1_mock_update_status (orgbluezobextransfer1Mock* self, gboolean is_complete, GError** error);
static void org_bluez_obex_transfer1_mock_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void org_bluez_obex_transfer1_mock_proxy_update_status (orgbluezobextransfer1Mock* self, gboolean is_complete, GError** error);
static void org_bluez_obex_transfer1_mock_proxy_org_bluez_obex_transfer1_mock_interface_init (orgbluezobextransfer1MockIface* iface);
static void _dbus_org_bluez_obex_transfer1_mock_update_status (orgbluezobextransfer1Mock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void org_bluez_obex_transfer1_mock_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* org_bluez_obex_transfer1_mock_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean org_bluez_obex_transfer1_mock_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _org_bluez_obex_transfer1_mock_unregister_object (gpointer user_data);
gpointer bluez_test_backend_ref (gpointer instance);
void bluez_test_backend_unref (gpointer instance);
GParamSpec* bluez_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void bluez_test_value_set_backend (GValue* value, gpointer v_object);
void bluez_test_value_take_backend (GValue* value, gpointer v_object);
gpointer bluez_test_value_get_backend (const GValue* value);
GType bluez_test_backend_get_type (void) G_GNUC_CONST;
#define BLUEZ_TEST_BACKEND_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BLUEZ_TEST_TYPE_BACKEND, BluezTestBackendPrivate))
void bluez_test_backend_set_up (BluezTestBackend* self);
void bluez_test_backend_tear_down (BluezTestBackend* self);
gulong bluez_test_backend_create_simple_device_with_vcard (BluezTestBackend* self, const gchar* vcard, gchar* * adapter_path, gchar* * device_path);
orgbluezMock* bluez_test_backend_get_mock_bluez (BluezTestBackend* self);
const gchar* bluez_test_backend_get_primary_device_address (BluezTestBackend* self);
gulong bluez_test_backend_set_simple_device_vcard (BluezTestBackend* self, const gchar* vcard);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
orgbluezobexMock* bluez_test_backend_get_mock_obex (BluezTestBackend* self);
static void __lambda4_ (Block1Data* _data1_, const gchar* p, GHashTable* f, const gchar* v);
static void ___lambda4__org_bluez_obex_mock_transfer_created (orgbluezobexMock* _sender, const gchar* path, GHashTable* filters, const gchar* transfer_filename, gpointer self);
BluezTestBackend* bluez_test_backend_new (void);
BluezTestBackend* bluez_test_backend_construct (GType object_type);
orgfreedesktopDBusMock* bluez_test_backend_get_mock_bluez_base (BluezTestBackend* self);
orgfreedesktopDBusMock* bluez_test_backend_get_mock_obex_base (BluezTestBackend* self);
static void bluez_test_backend_finalize (BluezTestBackend * obj);

static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_adapter_device_name = {-1, "device_name", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_adapter_system_name = {-1, "system_name", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_adapter_result = {-1, "result", "s"};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_add_adapter_in[] = {&_org_bluez_mock_dbus_arg_info_add_adapter_device_name, &_org_bluez_mock_dbus_arg_info_add_adapter_system_name, NULL};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_add_adapter_out[] = {&_org_bluez_mock_dbus_arg_info_add_adapter_result, NULL};
static const GDBusMethodInfo _org_bluez_mock_dbus_method_info_add_adapter = {-1, "AddAdapter", (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_add_adapter_in), (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_add_adapter_out)};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_device_adapter_device_name = {-1, "adapter_device_name", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_device_device_address = {-1, "device_address", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_device_alias = {-1, "alias", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_add_device_result = {-1, "result", "s"};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_add_device_in[] = {&_org_bluez_mock_dbus_arg_info_add_device_adapter_device_name, &_org_bluez_mock_dbus_arg_info_add_device_device_address, &_org_bluez_mock_dbus_arg_info_add_device_alias, NULL};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_add_device_out[] = {&_org_bluez_mock_dbus_arg_info_add_device_result, NULL};
static const GDBusMethodInfo _org_bluez_mock_dbus_method_info_add_device = {-1, "AddDevice", (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_add_device_in), (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_add_device_out)};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_pair_device_adapter_device_name = {-1, "adapter_device_name", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_pair_device_device_address = {-1, "device_address", "s"};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_pair_device_in[] = {&_org_bluez_mock_dbus_arg_info_pair_device_adapter_device_name, &_org_bluez_mock_dbus_arg_info_pair_device_device_address, NULL};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_pair_device_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_mock_dbus_method_info_pair_device = {-1, "PairDevice", (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_pair_device_in), (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_pair_device_out)};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_block_device_adapter_device_name = {-1, "adapter_device_name", "s"};
static const GDBusArgInfo _org_bluez_mock_dbus_arg_info_block_device_device_address = {-1, "device_address", "s"};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_block_device_in[] = {&_org_bluez_mock_dbus_arg_info_block_device_adapter_device_name, &_org_bluez_mock_dbus_arg_info_block_device_device_address, NULL};
static const GDBusArgInfo * const _org_bluez_mock_dbus_arg_info_block_device_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_mock_dbus_method_info_block_device = {-1, "BlockDevice", (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_block_device_in), (GDBusArgInfo **) (&_org_bluez_mock_dbus_arg_info_block_device_out)};
static const GDBusMethodInfo * const _org_bluez_mock_dbus_method_info[] = {&_org_bluez_mock_dbus_method_info_add_adapter, &_org_bluez_mock_dbus_method_info_add_device, &_org_bluez_mock_dbus_method_info_pair_device, &_org_bluez_mock_dbus_method_info_block_device, NULL};
static const GDBusSignalInfo * const _org_bluez_mock_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _org_bluez_mock_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _org_bluez_mock_dbus_interface_info = {-1, "org.bluez.Mock", (GDBusMethodInfo **) (&_org_bluez_mock_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_mock_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_mock_dbus_property_info)};
static const GDBusInterfaceVTable _org_bluez_mock_dbus_interface_vtable = {org_bluez_mock_dbus_interface_method_call, org_bluez_mock_dbus_interface_get_property, org_bluez_mock_dbus_interface_set_property};
static const GDBusMethodInfo * const _org_bluez_obex_mock_dbus_method_info[] = {NULL};
static const GDBusArgInfo _org_bluez_obex_mock_dbus_arg_info_transfer_created_path = {-1, "path", "s"};
static const GDBusArgInfo _org_bluez_obex_mock_dbus_arg_info_transfer_created_filters = {-1, "filters", "a{sv}"};
static const GDBusArgInfo _org_bluez_obex_mock_dbus_arg_info_transfer_created_transfer_filename = {-1, "transfer_filename", "s"};
static const GDBusArgInfo * const _org_bluez_obex_mock_dbus_arg_info_transfer_created[] = {&_org_bluez_obex_mock_dbus_arg_info_transfer_created_path, &_org_bluez_obex_mock_dbus_arg_info_transfer_created_filters, &_org_bluez_obex_mock_dbus_arg_info_transfer_created_transfer_filename, NULL};
static const GDBusSignalInfo _org_bluez_obex_mock_dbus_signal_info_transfer_created = {-1, "TransferCreated", (GDBusArgInfo **) (&_org_bluez_obex_mock_dbus_arg_info_transfer_created)};
static const GDBusSignalInfo * const _org_bluez_obex_mock_dbus_signal_info[] = {&_org_bluez_obex_mock_dbus_signal_info_transfer_created, NULL};
static const GDBusPropertyInfo * const _org_bluez_obex_mock_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _org_bluez_obex_mock_dbus_interface_info = {-1, "org.bluez.obex.Mock", (GDBusMethodInfo **) (&_org_bluez_obex_mock_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_obex_mock_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_obex_mock_dbus_property_info)};
static const GDBusInterfaceVTable _org_bluez_obex_mock_dbus_interface_vtable = {org_bluez_obex_mock_dbus_interface_method_call, org_bluez_obex_mock_dbus_interface_get_property, org_bluez_obex_mock_dbus_interface_set_property};
static const GDBusArgInfo _org_bluez_obex_transfer1_mock_dbus_arg_info_update_status_is_complete = {-1, "is_complete", "b"};
static const GDBusArgInfo * const _org_bluez_obex_transfer1_mock_dbus_arg_info_update_status_in[] = {&_org_bluez_obex_transfer1_mock_dbus_arg_info_update_status_is_complete, NULL};
static const GDBusArgInfo * const _org_bluez_obex_transfer1_mock_dbus_arg_info_update_status_out[] = {NULL};
static const GDBusMethodInfo _org_bluez_obex_transfer1_mock_dbus_method_info_update_status = {-1, "UpdateStatus", (GDBusArgInfo **) (&_org_bluez_obex_transfer1_mock_dbus_arg_info_update_status_in), (GDBusArgInfo **) (&_org_bluez_obex_transfer1_mock_dbus_arg_info_update_status_out)};
static const GDBusMethodInfo * const _org_bluez_obex_transfer1_mock_dbus_method_info[] = {&_org_bluez_obex_transfer1_mock_dbus_method_info_update_status, NULL};
static const GDBusSignalInfo * const _org_bluez_obex_transfer1_mock_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _org_bluez_obex_transfer1_mock_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _org_bluez_obex_transfer1_mock_dbus_interface_info = {-1, "org.bluez.obex.transfer1.Mock", (GDBusMethodInfo **) (&_org_bluez_obex_transfer1_mock_dbus_method_info), (GDBusSignalInfo **) (&_org_bluez_obex_transfer1_mock_dbus_signal_info), (GDBusPropertyInfo **) (&_org_bluez_obex_transfer1_mock_dbus_property_info)};
static const GDBusInterfaceVTable _org_bluez_obex_transfer1_mock_dbus_interface_vtable = {org_bluez_obex_transfer1_mock_dbus_interface_method_call, org_bluez_obex_transfer1_mock_dbus_interface_get_property, org_bluez_obex_transfer1_mock_dbus_interface_set_property};

gchar* org_bluez_mock_add_adapter (orgbluezMock* self, const gchar* device_name, const gchar* system_name, GError** error) {
#line 33 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 33 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return ORG_BLUEZ_MOCK_GET_INTERFACE (self)->add_adapter (self, device_name, system_name, error);
#line 270 "backend.c"
}


gchar* org_bluez_mock_add_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, const gchar* alias, GError** error) {
#line 37 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 37 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return ORG_BLUEZ_MOCK_GET_INTERFACE (self)->add_device (self, adapter_device_name, device_address, alias, error);
#line 279 "backend.c"
}


void org_bluez_mock_pair_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error) {
#line 41 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (self != NULL);
#line 41 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	ORG_BLUEZ_MOCK_GET_INTERFACE (self)->pair_device (self, adapter_device_name, device_address, error);
#line 288 "backend.c"
}


void org_bluez_mock_block_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error) {
#line 45 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (self != NULL);
#line 45 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	ORG_BLUEZ_MOCK_GET_INTERFACE (self)->block_device (self, adapter_device_name, device_address, error);
#line 297 "backend.c"
}


static void org_bluez_mock_base_init (orgbluezMockIface * iface) {
#line 30 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	static gboolean initialized = FALSE;
#line 30 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (!initialized) {
#line 30 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		initialized = TRUE;
#line 308 "backend.c"
	}
}


GType org_bluez_mock_get_type (void) {
	static volatile gsize org_bluez_mock_type_id__volatile = 0;
	if (g_once_init_enter (&org_bluez_mock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (orgbluezMockIface), (GBaseInitFunc) org_bluez_mock_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType org_bluez_mock_type_id;
		org_bluez_mock_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezMock", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (org_bluez_mock_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (org_bluez_mock_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_mock_proxy_get_type);
		g_type_set_qdata (org_bluez_mock_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.Mock");
		g_type_set_qdata (org_bluez_mock_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_mock_dbus_interface_info));
		g_type_set_qdata (org_bluez_mock_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_mock_register_object);
		g_once_init_leave (&org_bluez_mock_type_id__volatile, org_bluez_mock_type_id);
	}
	return org_bluez_mock_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (orgbluezMockProxy, org_bluez_mock_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_TYPE_MOCK, org_bluez_mock_proxy_org_bluez_mock_interface_init) )
static void org_bluez_mock_proxy_class_init (orgbluezMockProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_mock_proxy_g_signal;
}


static void org_bluez_mock_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void org_bluez_mock_proxy_init (orgbluezMockProxy* self) {
}


static gchar* org_bluez_mock_proxy_add_adapter (orgbluezMock* self, const gchar* device_name, const gchar* system_name, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp0_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Mock", "AddAdapter");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (device_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (system_name));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static gchar* org_bluez_mock_proxy_add_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, const gchar* alias, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp1_;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Mock", "AddDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (adapter_device_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (device_address));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (alias));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp1_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	g_object_unref (_reply_message);
	return _result;
}


static void org_bluez_mock_proxy_pair_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Mock", "PairDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (adapter_device_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (device_address));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_mock_proxy_block_device (orgbluezMock* self, const gchar* adapter_device_name, const gchar* device_address, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.Mock", "BlockDevice");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (adapter_device_name));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (device_address));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_mock_proxy_org_bluez_mock_interface_init (orgbluezMockIface* iface) {
	iface->add_adapter = org_bluez_mock_proxy_add_adapter;
	iface->add_device = org_bluez_mock_proxy_add_device;
	iface->pair_device = org_bluez_mock_proxy_pair_device;
	iface->block_device = org_bluez_mock_proxy_block_device;
}


static void _dbus_org_bluez_mock_add_adapter (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* device_name = NULL;
	GVariant* _tmp2_;
	gchar* system_name = NULL;
	GVariant* _tmp3_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	device_name = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	system_name = g_variant_dup_string (_tmp3_, NULL);
	g_variant_unref (_tmp3_);
	result = org_bluez_mock_add_adapter (self, device_name, system_name, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (device_name);
	_g_free0 (system_name);
}


static void _dbus_org_bluez_mock_add_device (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* adapter_device_name = NULL;
	GVariant* _tmp4_;
	gchar* device_address = NULL;
	GVariant* _tmp5_;
	gchar* alias = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	adapter_device_name = g_variant_dup_string (_tmp4_, NULL);
	g_variant_unref (_tmp4_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	device_address = g_variant_dup_string (_tmp5_, NULL);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	alias = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	result = org_bluez_mock_add_device (self, adapter_device_name, device_address, alias, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (adapter_device_name);
	_g_free0 (device_address);
	_g_free0 (alias);
}


static void _dbus_org_bluez_mock_pair_device (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* adapter_device_name = NULL;
	GVariant* _tmp7_;
	gchar* device_address = NULL;
	GVariant* _tmp8_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp7_ = g_variant_iter_next_value (&_arguments_iter);
	adapter_device_name = g_variant_dup_string (_tmp7_, NULL);
	g_variant_unref (_tmp7_);
	_tmp8_ = g_variant_iter_next_value (&_arguments_iter);
	device_address = g_variant_dup_string (_tmp8_, NULL);
	g_variant_unref (_tmp8_);
	org_bluez_mock_pair_device (self, adapter_device_name, device_address, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (adapter_device_name);
	_g_free0 (device_address);
}


static void _dbus_org_bluez_mock_block_device (orgbluezMock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* adapter_device_name = NULL;
	GVariant* _tmp9_;
	gchar* device_address = NULL;
	GVariant* _tmp10_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp9_ = g_variant_iter_next_value (&_arguments_iter);
	adapter_device_name = g_variant_dup_string (_tmp9_, NULL);
	g_variant_unref (_tmp9_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	device_address = g_variant_dup_string (_tmp10_, NULL);
	g_variant_unref (_tmp10_);
	org_bluez_mock_block_device (self, adapter_device_name, device_address, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_g_free0 (adapter_device_name);
	_g_free0 (device_address);
}


static void org_bluez_mock_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AddAdapter") == 0) {
		_dbus_org_bluez_mock_add_adapter (object, parameters, invocation);
	} else if (strcmp (method_name, "AddDevice") == 0) {
		_dbus_org_bluez_mock_add_device (object, parameters, invocation);
	} else if (strcmp (method_name, "PairDevice") == 0) {
		_dbus_org_bluez_mock_pair_device (object, parameters, invocation);
	} else if (strcmp (method_name, "BlockDevice") == 0) {
		_dbus_org_bluez_mock_block_device (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* org_bluez_mock_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean org_bluez_mock_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint org_bluez_mock_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_mock_dbus_interface_info), &_org_bluez_mock_dbus_interface_vtable, data, _org_bluez_mock_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _org_bluez_mock_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void g_cclosure_user_marshal_VOID__STRING_BOXED_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_BOXED_STRING) (gpointer data1, const char* arg_1, gpointer arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_BOXED_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (n_param_values == 4);
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		data1 = closure->data;
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		data2 = param_values->data[0].v_pointer;
#line 698 "backend.c"
	} else {
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		data1 = param_values->data[0].v_pointer;
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		data2 = closure->data;
#line 704 "backend.c"
	}
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	callback = (GMarshalFunc_VOID__STRING_BOXED_STRING) (marshal_data ? marshal_data : cc->callback);
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	callback (data1, g_value_get_string (param_values + 1), g_value_get_boxed (param_values + 2), g_value_get_string (param_values + 3), data2);
#line 710 "backend.c"
}


static void org_bluez_obex_mock_base_init (orgbluezobexMockIface * iface) {
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	static gboolean initialized = FALSE;
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (!initialized) {
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		initialized = TRUE;
#line 53 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		org_bluez_obex_mock_signals[ORG_BLUEZ_OBEX_MOCK_TRANSFER_CREATED_SIGNAL] = g_signal_new ("transfer-created", ORG_BLUEZ_OBEX_TYPE_MOCK, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__STRING_BOXED_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_HASH_TABLE, G_TYPE_STRING);
#line 723 "backend.c"
	}
}


GType org_bluez_obex_mock_get_type (void) {
	static volatile gsize org_bluez_obex_mock_type_id__volatile = 0;
	if (g_once_init_enter (&org_bluez_obex_mock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (orgbluezobexMockIface), (GBaseInitFunc) org_bluez_obex_mock_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType org_bluez_obex_mock_type_id;
		org_bluez_obex_mock_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezobexMock", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (org_bluez_obex_mock_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (org_bluez_obex_mock_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_obex_mock_proxy_get_type);
		g_type_set_qdata (org_bluez_obex_mock_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.Mock");
		g_type_set_qdata (org_bluez_obex_mock_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_obex_mock_dbus_interface_info));
		g_type_set_qdata (org_bluez_obex_mock_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_obex_mock_register_object);
		g_once_init_leave (&org_bluez_obex_mock_type_id__volatile, org_bluez_obex_mock_type_id);
	}
	return org_bluez_obex_mock_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (orgbluezobexMockProxy, org_bluez_obex_mock_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_OBEX_TYPE_MOCK, org_bluez_obex_mock_proxy_org_bluez_obex_mock_interface_init) )
static void org_bluez_obex_mock_proxy_class_init (orgbluezobexMockProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_obex_mock_proxy_g_signal;
}


static void _dbus_handle_org_bluez_obex_mock_transfer_created (orgbluezobexMock* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	gchar* path = NULL;
	GVariant* _tmp11_;
	GHashTable* filters = NULL;
	GVariant* _tmp12_;
	GHashTable* _tmp13_;
	GVariantIter _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	gchar* transfer_filename = NULL;
	GVariant* _tmp17_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	path = g_variant_dup_string (_tmp11_, NULL);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp13_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp14_, _tmp12_);
	while (g_variant_iter_loop (&_tmp14_, "{?*}", &_tmp15_, &_tmp16_)) {
		g_hash_table_insert (_tmp13_, g_variant_dup_string (_tmp15_, NULL), g_variant_get_variant (_tmp16_));
	}
	filters = _tmp13_;
	g_variant_unref (_tmp12_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	transfer_filename = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	g_signal_emit_by_name (self, "transfer-created", path, filters, transfer_filename);
	_g_free0 (path);
	_g_hash_table_unref0 (filters);
	_g_free0 (transfer_filename);
}


static void org_bluez_obex_mock_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "TransferCreated") == 0) {
		_dbus_handle_org_bluez_obex_mock_transfer_created ((orgbluezobexMock*) proxy, parameters);
	}
}


static void org_bluez_obex_mock_proxy_init (orgbluezobexMockProxy* self) {
}


static void org_bluez_obex_mock_proxy_org_bluez_obex_mock_interface_init (orgbluezobexMockIface* iface) {
}


static void org_bluez_obex_mock_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* org_bluez_obex_mock_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean org_bluez_obex_mock_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_org_bluez_obex_mock_transfer_created (GObject* _sender, const gchar* path, GHashTable* filters, const gchar* transfer_filename, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp18_;
	GHashTableIter _tmp19_;
	gpointer _tmp20_;
	gpointer _tmp21_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (path));
	g_hash_table_iter_init (&_tmp19_, filters);
	g_variant_builder_init (&_tmp18_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp19_, &_tmp20_, &_tmp21_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp20_;
		_value = (GVariant*) _tmp21_;
		g_variant_builder_add (&_tmp18_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp18_));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (transfer_filename));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.bluez.obex.Mock", "TransferCreated", _arguments, NULL);
}


guint org_bluez_obex_mock_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_obex_mock_dbus_interface_info), &_org_bluez_obex_mock_dbus_interface_vtable, data, _org_bluez_obex_mock_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "transfer-created", (GCallback) _dbus_org_bluez_obex_mock_transfer_created, data);
	return result;
}


static void _org_bluez_obex_mock_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_org_bluez_obex_mock_transfer_created, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void org_bluez_obex_transfer1_mock_update_status (orgbluezobextransfer1Mock* self, gboolean is_complete, GError** error) {
#line 67 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (self != NULL);
#line 67 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	ORG_BLUEZ_OBEX_TRANSFER1_MOCK_GET_INTERFACE (self)->update_status (self, is_complete, error);
#line 888 "backend.c"
}


static void org_bluez_obex_transfer1_mock_base_init (orgbluezobextransfer1MockIface * iface) {
#line 64 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	static gboolean initialized = FALSE;
#line 64 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (!initialized) {
#line 64 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		initialized = TRUE;
#line 899 "backend.c"
	}
}


GType org_bluez_obex_transfer1_mock_get_type (void) {
	static volatile gsize org_bluez_obex_transfer1_mock_type_id__volatile = 0;
	if (g_once_init_enter (&org_bluez_obex_transfer1_mock_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (orgbluezobextransfer1MockIface), (GBaseInitFunc) org_bluez_obex_transfer1_mock_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType org_bluez_obex_transfer1_mock_type_id;
		org_bluez_obex_transfer1_mock_type_id = g_type_register_static (G_TYPE_INTERFACE, "orgbluezobextransfer1Mock", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (org_bluez_obex_transfer1_mock_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (org_bluez_obex_transfer1_mock_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) org_bluez_obex_transfer1_mock_proxy_get_type);
		g_type_set_qdata (org_bluez_obex_transfer1_mock_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.bluez.obex.transfer1.Mock");
		g_type_set_qdata (org_bluez_obex_transfer1_mock_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_org_bluez_obex_transfer1_mock_dbus_interface_info));
		g_type_set_qdata (org_bluez_obex_transfer1_mock_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) org_bluez_obex_transfer1_mock_register_object);
		g_once_init_leave (&org_bluez_obex_transfer1_mock_type_id__volatile, org_bluez_obex_transfer1_mock_type_id);
	}
	return org_bluez_obex_transfer1_mock_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (orgbluezobextransfer1MockProxy, org_bluez_obex_transfer1_mock_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK, org_bluez_obex_transfer1_mock_proxy_org_bluez_obex_transfer1_mock_interface_init) )
static void org_bluez_obex_transfer1_mock_proxy_class_init (orgbluezobextransfer1MockProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = org_bluez_obex_transfer1_mock_proxy_g_signal;
}


static void org_bluez_obex_transfer1_mock_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void org_bluez_obex_transfer1_mock_proxy_init (orgbluezobextransfer1MockProxy* self) {
}


static void org_bluez_obex_transfer1_mock_proxy_update_status (orgbluezobextransfer1Mock* self, gboolean is_complete, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.bluez.obex.transfer1.Mock", "UpdateStatus");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (is_complete));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void org_bluez_obex_transfer1_mock_proxy_org_bluez_obex_transfer1_mock_interface_init (orgbluezobextransfer1MockIface* iface) {
	iface->update_status = org_bluez_obex_transfer1_mock_proxy_update_status;
}


static void _dbus_org_bluez_obex_transfer1_mock_update_status (orgbluezobextransfer1Mock* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean is_complete = FALSE;
	GVariant* _tmp22_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp22_ = g_variant_iter_next_value (&_arguments_iter);
	is_complete = g_variant_get_boolean (_tmp22_);
	g_variant_unref (_tmp22_);
	org_bluez_obex_transfer1_mock_update_status (self, is_complete, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void org_bluez_obex_transfer1_mock_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "UpdateStatus") == 0) {
		_dbus_org_bluez_obex_transfer1_mock_update_status (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* org_bluez_obex_transfer1_mock_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean org_bluez_obex_transfer1_mock_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint org_bluez_obex_transfer1_mock_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_org_bluez_obex_transfer1_mock_dbus_interface_info), &_org_bluez_obex_transfer1_mock_dbus_interface_vtable, data, _org_bluez_obex_transfer1_mock_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _org_bluez_obex_transfer1_mock_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


/**
   * Set up the mock D-Bus interfaces.
   *
   * This must be called before every different unit test. It creates D-Bus
   * proxies for the dbusmock objects, auto-launching python-dbusmock if
   * necessary.
   *
   * The required D-Bus service files must previously have been set up with the
   * buses which are in use. This is done in
   * {@link TestCase.create_transient_dir}.
   *
   * @since 0.9.7
   */
void bluez_test_backend_set_up (BluezTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 162 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (self != NULL);
#line 1064 "backend.c"
	{
		orgbluezMock* _tmp0_ = NULL;
		orgbluezMock* _tmp1_;
		orgbluezMock* _tmp2_;
		orgfreedesktopDBusMock* _tmp3_ = NULL;
		orgfreedesktopDBusMock* _tmp4_;
		orgfreedesktopDBusMock* _tmp5_;
		orgbluezobexMock* _tmp6_ = NULL;
		orgbluezobexMock* _tmp7_;
		orgbluezobexMock* _tmp8_;
		orgfreedesktopDBusMock* _tmp9_ = NULL;
		orgfreedesktopDBusMock* _tmp10_;
		orgfreedesktopDBusMock* _tmp11_;
#line 169 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp1_ = g_initable_new (ORG_BLUEZ_TYPE_MOCK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.bluez.Mock", "g-interface-info", g_type_get_qdata (ORG_BLUEZ_TYPE_MOCK, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 169 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp0_ = (orgbluezMock*) _tmp1_;
#line 169 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1084 "backend.c"
			goto __catch0_g_error;
		}
#line 168 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp2_ = _tmp0_;
#line 168 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp0_ = NULL;
#line 168 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (self->priv->_mock_bluez);
#line 168 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		self->priv->_mock_bluez = _tmp2_;
#line 171 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp4_ = g_initable_new (ORG_FREEDESKTOP_DBUS_TYPE_MOCK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez", "g-bus-type", G_BUS_TYPE_SYSTEM, "g-object-path", "/", "g-interface-name", "org.freedesktop.DBus.Mock", "g-interface-info", g_type_get_qdata (ORG_FREEDESKTOP_DBUS_TYPE_MOCK, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 171 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp3_ = (orgfreedesktopDBusMock*) _tmp4_;
#line 171 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 171 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp0_);
#line 1103 "backend.c"
			goto __catch0_g_error;
		}
#line 170 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp5_ = _tmp3_;
#line 170 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp3_ = NULL;
#line 170 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (self->priv->_mock_bluez_base);
#line 170 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		self->priv->_mock_bluez_base = _tmp5_;
#line 174 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp7_ = g_initable_new (ORG_BLUEZ_OBEX_TYPE_MOCK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/", "g-interface-name", "org.bluez.obex.Mock", "g-interface-info", g_type_get_qdata (ORG_BLUEZ_OBEX_TYPE_MOCK, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 174 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp6_ = (orgbluezobexMock*) _tmp7_;
#line 174 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 174 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp3_);
#line 174 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp0_);
#line 1124 "backend.c"
			goto __catch0_g_error;
		}
#line 173 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp8_ = _tmp6_;
#line 173 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp6_ = NULL;
#line 173 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (self->priv->_mock_obex);
#line 173 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		self->priv->_mock_obex = _tmp8_;
#line 176 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp10_ = g_initable_new (ORG_FREEDESKTOP_DBUS_TYPE_MOCK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/", "g-interface-name", "org.freedesktop.DBus.Mock", "g-interface-info", g_type_get_qdata (ORG_FREEDESKTOP_DBUS_TYPE_MOCK, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 176 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp9_ = (orgfreedesktopDBusMock*) _tmp10_;
#line 176 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 176 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp6_);
#line 176 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp3_);
#line 176 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp0_);
#line 1147 "backend.c"
			goto __catch0_g_error;
		}
#line 175 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp11_ = _tmp9_;
#line 175 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp9_ = NULL;
#line 175 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (self->priv->_mock_obex_base);
#line 175 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		self->priv->_mock_obex_base = _tmp11_;
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (_tmp9_);
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (_tmp6_);
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (_tmp3_);
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (_tmp0_);
#line 1166 "backend.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp12_;
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		e1 = _inner_error_;
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_inner_error_ = NULL;
#line 181 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		bluez_test_backend_tear_down (self);
#line 183 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp12_ = e1->message;
#line 183 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_error ("backend.vala:183: Error connecting to mock object: %s", _tmp12_);
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_error_free0 (e1);
#line 1185 "backend.c"
	}
	__finally0:
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_clear_error (&_inner_error_);
#line 166 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		return;
#line 1196 "backend.c"
	}
}


/**
   * Tear down the mock D-Bus interfaces.
   *
   * This must be called after every different unit test. It undoes
   * {@link Backend.set_up}, although the python-dbusmock processes are kept
   * around and reset, rather than being killed.
   *
   * @since 0.9.7
   */
void bluez_test_backend_tear_down (BluezTestBackend* self) {
	GError * _inner_error_ = NULL;
#line 196 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (self != NULL);
#line 1214 "backend.c"
	{
		orgfreedesktopDBusMock* _tmp0_;
		orgfreedesktopDBusMock* _tmp1_;
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp0_ = self->priv->_mock_obex_base;
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		org_freedesktop_dbus_mock_reset (_tmp0_, &_inner_error_);
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1226 "backend.c"
				goto __catch1_g_io_error;
			}
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_clear_error (&_inner_error_);
#line 201 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return;
#line 1235 "backend.c"
		}
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp1_ = self->priv->_mock_bluez_base;
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		org_freedesktop_dbus_mock_reset (_tmp1_, &_inner_error_);
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1245 "backend.c"
				goto __catch1_g_io_error;
			}
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_clear_error (&_inner_error_);
#line 202 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return;
#line 1254 "backend.c"
		}
	}
	goto __finally1;
	__catch1_g_io_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp2_;
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		e1 = _inner_error_;
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_inner_error_ = NULL;
#line 206 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp2_ = e1->message;
#line 206 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_error ("backend.vala:206: Error resetting python-dbusmock state: %s", _tmp2_);
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_error_free0 (e1);
#line 1272 "backend.c"
	}
	__finally1:
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_clear_error (&_inner_error_);
#line 199 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		return;
#line 1283 "backend.c"
	}
#line 212 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_obex_base);
#line 212 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_obex_base = NULL;
#line 213 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_bluez_base);
#line 213 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_bluez_base = NULL;
#line 214 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_obex);
#line 214 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_obex = NULL;
#line 215 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_bluez);
#line 215 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_bluez = NULL;
#line 1301 "backend.c"
}


/**
   * Create a simple Bluetooth device with the given vCard.
   *
   * Create a new Bluetooth adapter (``hci0``) and a new Bluetooth device (with
   * address {@link Backend.primary_device_address}). Pair with the Bluetooth
   * device and simulate it having the given ``vcard`` (potentially containing
   * multiple whitespace-separated entries) as its address book.
   *
   * On error this function will abort the test.
   *
   * @param vcard series of vCards for the device’s address book
   * @param adapter_path optional return location for the adapter’s D-Bus object
   * path
   * @param device_path optional return location for the device’s D-Bus object
   * path
   * @return ID of the signal returning the vCard, as per
   * {@link Backend.set_simple_device_vcard}
   *
   * @since 0.9.7
   */
gulong bluez_test_backend_create_simple_device_with_vcard (BluezTestBackend* self, const gchar* vcard, gchar* * adapter_path, gchar* * device_path) {
	gchar* _vala_adapter_path = NULL;
	gchar* _vala_device_path = NULL;
	gulong result = 0UL;
	gulong _tmp22_ = 0UL;
	GError * _inner_error_ = NULL;
#line 238 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 238 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (vcard != NULL, 0UL);
#line 1335 "backend.c"
	{
		gchar* _tmp0_ = NULL;
		orgbluezMock* _tmp1_;
		orgbluezMock* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp5_;
		gchar* _tmp6_ = NULL;
		orgbluezMock* _tmp7_;
		orgbluezMock* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp13_;
		orgbluezMock* _tmp14_;
		orgbluezMock* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp19_;
		gulong _tmp20_;
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp1_ = bluez_test_backend_get_mock_bluez (self);
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp2_ = _tmp1_;
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp3_ = org_bluez_mock_add_adapter (_tmp2_, "hci0", "Test System", &_inner_error_);
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp0_ = _tmp3_;
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1365 "backend.c"
			gulong _tmp4_ = 0UL;
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1369 "backend.c"
				goto __catch2_g_io_error;
			}
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_clear_error (&_inner_error_);
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return _tmp4_;
#line 1378 "backend.c"
		}
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp5_ = _tmp0_;
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp0_ = NULL;
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_free0 (_vala_adapter_path);
#line 244 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_vala_adapter_path = _tmp5_;
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp7_ = bluez_test_backend_get_mock_bluez (self);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp8_ = _tmp7_;
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp9_ = bluez_test_backend_get_primary_device_address (self);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp10_ = _tmp9_;
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp11_ = org_bluez_mock_add_device (_tmp8_, "hci0", _tmp10_, "My Phone", &_inner_error_);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp6_ = _tmp11_;
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1402 "backend.c"
			gulong _tmp12_ = 0UL;
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_tmp0_);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1408 "backend.c"
				goto __catch2_g_io_error;
			}
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_tmp0_);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_clear_error (&_inner_error_);
#line 246 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return _tmp12_;
#line 1419 "backend.c"
		}
#line 245 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp13_ = _tmp6_;
#line 245 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp6_ = NULL;
#line 245 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_free0 (_vala_device_path);
#line 245 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_vala_device_path = _tmp13_;
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp14_ = bluez_test_backend_get_mock_bluez (self);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp15_ = _tmp14_;
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp16_ = bluez_test_backend_get_primary_device_address (self);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp17_ = _tmp16_;
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		org_bluez_mock_pair_device (_tmp15_, "hci0", _tmp17_, &_inner_error_);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1441 "backend.c"
			gulong _tmp18_ = 0UL;
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_tmp6_);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_tmp0_);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			if (_inner_error_->domain == G_IO_ERROR) {
#line 1449 "backend.c"
				goto __catch2_g_io_error;
			}
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_tmp6_);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_tmp0_);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_clear_error (&_inner_error_);
#line 250 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return _tmp18_;
#line 1462 "backend.c"
		}
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp19_ = vcard;
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp20_ = bluez_test_backend_set_simple_device_vcard (self, _tmp19_);
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		result = _tmp20_;
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_free0 (_tmp6_);
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_free0 (_tmp0_);
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (adapter_path) {
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			*adapter_path = _vala_adapter_path;
#line 1478 "backend.c"
		} else {
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_vala_adapter_path);
#line 1482 "backend.c"
		}
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (device_path) {
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			*device_path = _vala_device_path;
#line 1488 "backend.c"
		} else {
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_free0 (_vala_device_path);
#line 1492 "backend.c"
		}
#line 253 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		return result;
#line 1496 "backend.c"
	}
	goto __finally2;
	__catch2_g_io_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp21_;
#line 241 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		e1 = _inner_error_;
#line 241 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_inner_error_ = NULL;
#line 257 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp21_ = e1->message;
#line 257 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_error ("backend.vala:257: Error setting up mock BlueZ device: %s", _tmp21_);
#line 241 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_error_free0 (e1);
#line 1513 "backend.c"
	}
	__finally2:
#line 241 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 241 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_clear_error (&_inner_error_);
#line 241 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return _tmp22_;
#line 1522 "backend.c"
}


/**
   * Set the vCard to be returned by a simple Bluetooth device.
   *
   * This sets the vCard which will be returned indefinitely. It returns a
   * signal ID which may be disconnected with:
   * {{{
   * this.mock_obex.disconnect (signal_id);
   * }}}
   * to prevent the vCard being returned in future.
   *
   * @param vcard series of vCards for the device’s address book
   * @return ID of the signal returning the vCard
   *
   * @since 0.9.7
   */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return _data1_;
#line 1546 "backend.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1555 "backend.c"
		BluezTestBackend* self;
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		self = _data1_->self;
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_free0 (_data1_->vcard);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_bluez_test_backend_unref0 (self);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_slice_free (Block1Data, _data1_);
#line 1565 "backend.c"
	}
}


static void __lambda4_ (Block1Data* _data1_, const gchar* p, GHashTable* f, const gchar* v) {
	BluezTestBackend* self;
	orgbluezobextransfer1Mock* proxy = NULL;
	GError * _inner_error_ = NULL;
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self = _data1_->self;
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (p != NULL);
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (f != NULL);
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (v != NULL);
#line 1582 "backend.c"
	{
		const gchar* _tmp0_;
		const gchar* _tmp1_;
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp0_ = v;
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp1_ = _data1_->vcard;
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_file_set_contents (_tmp0_, _tmp1_, (gssize) -1, &_inner_error_);
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			if (_inner_error_->domain == G_FILE_ERROR) {
#line 1596 "backend.c"
				goto __catch3_g_file_error;
			}
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (proxy);
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			g_clear_error (&_inner_error_);
#line 286 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return;
#line 1607 "backend.c"
		}
	}
	goto __finally3;
	__catch3_g_file_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		e1 = _inner_error_;
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_inner_error_ = NULL;
#line 290 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp2_ = v;
#line 290 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp3_ = e1->message;
#line 290 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_error ("backend.vala:290: Error writing vCard transfer file ‘%s’: %s", _tmp2_, _tmp3_);
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_error_free0 (e1);
#line 1628 "backend.c"
	}
	__finally3:
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (proxy);
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_clear_error (&_inner_error_);
#line 284 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		return;
#line 1641 "backend.c"
	}
	{
		orgbluezobextransfer1Mock* _tmp4_ = NULL;
		const gchar* _tmp5_;
		orgbluezobextransfer1Mock* _tmp6_;
		orgbluezobextransfer1Mock* _tmp7_;
		orgbluezobextransfer1Mock* _tmp8_;
#line 297 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp5_ = p;
#line 297 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp6_ = g_initable_new (ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK_PROXY, NULL, &_inner_error_, "g-flags", 0, "g-name", "org.bluez.obex", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", _tmp5_, "g-interface-name", "org.bluez.obex.transfer1.Mock", "g-interface-info", g_type_get_qdata (ORG_BLUEZ_OBEX_TRANSFER1_TYPE_MOCK, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
#line 297 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp4_ = (orgbluezobextransfer1Mock*) _tmp6_;
#line 297 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1657 "backend.c"
			goto __catch4_g_error;
		}
#line 296 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp7_ = _tmp4_;
#line 296 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp4_ = NULL;
#line 296 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (proxy);
#line 296 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		proxy = _tmp7_;
#line 298 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp8_ = proxy;
#line 298 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		org_bluez_obex_transfer1_mock_update_status (_tmp8_, TRUE, &_inner_error_);
#line 298 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 298 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			_g_object_unref0 (_tmp4_);
#line 1676 "backend.c"
			goto __catch4_g_error;
		}
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (_tmp4_);
#line 1681 "backend.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e1 = NULL;
		const gchar* _tmp9_;
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		e1 = _inner_error_;
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_inner_error_ = NULL;
#line 302 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_tmp9_ = e1->message;
#line 302 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_error ("backend.vala:302: Error activating transfer: %s", _tmp9_);
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_error_free0 (e1);
#line 1698 "backend.c"
	}
	__finally4:
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		_g_object_unref0 (proxy);
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_clear_error (&_inner_error_);
#line 294 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		return;
#line 1711 "backend.c"
	}
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (proxy);
#line 1715 "backend.c"
}


static void ___lambda4__org_bluez_obex_mock_transfer_created (orgbluezobexMock* _sender, const gchar* path, GHashTable* filters, const gchar* transfer_filename, gpointer self) {
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	__lambda4_ (self, path, filters, transfer_filename);
#line 1722 "backend.c"
}


gulong bluez_test_backend_set_simple_device_vcard (BluezTestBackend* self, const gchar* vcard) {
	gulong result = 0UL;
	Block1Data* _data1_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	orgbluezobexMock* _tmp2_;
	orgbluezobexMock* _tmp3_;
	gulong _tmp4_;
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (vcard != NULL, 0UL);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_data1_->_ref_count_ = 1;
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_data1_->self = bluez_test_backend_ref (self);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp0_ = vcard;
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_free0 (_data1_->vcard);
#line 276 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_data1_->vcard = _tmp1_;
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp2_ = bluez_test_backend_get_mock_obex (self);
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp3_ = _tmp2_;
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp4_ = g_signal_connect_data (_tmp3_, "transfer-created", (GCallback) ___lambda4__org_bluez_obex_mock_transfer_created, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	result = _tmp4_;
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	block1_data_unref (_data1_);
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_data1_ = NULL;
#line 280 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return result;
#line 1766 "backend.c"
}


BluezTestBackend* bluez_test_backend_construct (GType object_type) {
	BluezTestBackend* self = NULL;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self = (BluezTestBackend*) g_type_create_instance (object_type);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return self;
#line 1776 "backend.c"
}


BluezTestBackend* bluez_test_backend_new (void) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return bluez_test_backend_construct (BLUEZ_TEST_TYPE_BACKEND);
#line 1783 "backend.c"
}


orgbluezMock* bluez_test_backend_get_mock_bluez (BluezTestBackend* self) {
	orgbluezMock* result;
	orgbluezMock* _tmp0_;
#line 102 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 102 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp0_ = self->priv->_mock_bluez;
#line 102 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	result = _tmp0_;
#line 102 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return result;
#line 1798 "backend.c"
}


orgfreedesktopDBusMock* bluez_test_backend_get_mock_bluez_base (BluezTestBackend* self) {
	orgfreedesktopDBusMock* result;
	orgfreedesktopDBusMock* _tmp0_;
#line 112 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp0_ = self->priv->_mock_bluez_base;
#line 112 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	result = _tmp0_;
#line 112 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return result;
#line 1813 "backend.c"
}


orgbluezobexMock* bluez_test_backend_get_mock_obex (BluezTestBackend* self) {
	orgbluezobexMock* result;
	orgbluezobexMock* _tmp0_;
#line 123 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp0_ = self->priv->_mock_obex;
#line 123 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	result = _tmp0_;
#line 123 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return result;
#line 1828 "backend.c"
}


orgfreedesktopDBusMock* bluez_test_backend_get_mock_obex_base (BluezTestBackend* self) {
	orgfreedesktopDBusMock* result;
	orgfreedesktopDBusMock* _tmp0_;
#line 133 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 133 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_tmp0_ = self->priv->_mock_obex_base;
#line 133 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	result = _tmp0_;
#line 133 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return result;
#line 1843 "backend.c"
}


const gchar* bluez_test_backend_get_primary_device_address (BluezTestBackend* self) {
	const gchar* result;
#line 146 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 146 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	result = "00:00:00:00:00:00";
#line 146 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return result;
#line 1855 "backend.c"
}


static void bluez_test_value_backend_init (GValue* value) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	value->data[0].v_pointer = NULL;
#line 1862 "backend.c"
}


static void bluez_test_value_backend_free_value (GValue* value) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (value->data[0].v_pointer) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		bluez_test_backend_unref (value->data[0].v_pointer);
#line 1871 "backend.c"
	}
}


static void bluez_test_value_backend_copy_value (const GValue* src_value, GValue* dest_value) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (src_value->data[0].v_pointer) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		dest_value->data[0].v_pointer = bluez_test_backend_ref (src_value->data[0].v_pointer);
#line 1881 "backend.c"
	} else {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1885 "backend.c"
	}
}


static gpointer bluez_test_value_backend_peek_pointer (const GValue* value) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return value->data[0].v_pointer;
#line 1893 "backend.c"
}


static gchar* bluez_test_value_backend_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (collect_values[0].v_pointer) {
#line 1900 "backend.c"
		BluezTestBackend * object;
		object = collect_values[0].v_pointer;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		if (object->parent_instance.g_class == NULL) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1907 "backend.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1911 "backend.c"
		}
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		value->data[0].v_pointer = bluez_test_backend_ref (object);
#line 1915 "backend.c"
	} else {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		value->data[0].v_pointer = NULL;
#line 1919 "backend.c"
	}
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return NULL;
#line 1923 "backend.c"
}


static gchar* bluez_test_value_backend_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BluezTestBackend ** object_p;
	object_p = collect_values[0].v_pointer;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (!object_p) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1934 "backend.c"
	}
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (!value->data[0].v_pointer) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		*object_p = NULL;
#line 1940 "backend.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		*object_p = value->data[0].v_pointer;
#line 1944 "backend.c"
	} else {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		*object_p = bluez_test_backend_ref (value->data[0].v_pointer);
#line 1948 "backend.c"
	}
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return NULL;
#line 1952 "backend.c"
}


GParamSpec* bluez_test_param_spec_backend (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BluezTestParamSpecBackend* spec;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BLUEZ_TEST_TYPE_BACKEND), NULL);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return G_PARAM_SPEC (spec);
#line 1966 "backend.c"
}


gpointer bluez_test_value_get_backend (const GValue* value) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BLUEZ_TEST_TYPE_BACKEND), NULL);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return value->data[0].v_pointer;
#line 1975 "backend.c"
}


void bluez_test_value_set_backend (GValue* value, gpointer v_object) {
	BluezTestBackend * old;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BLUEZ_TEST_TYPE_BACKEND));
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	old = value->data[0].v_pointer;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (v_object) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BLUEZ_TEST_TYPE_BACKEND));
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		value->data[0].v_pointer = v_object;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		bluez_test_backend_ref (value->data[0].v_pointer);
#line 1995 "backend.c"
	} else {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		value->data[0].v_pointer = NULL;
#line 1999 "backend.c"
	}
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (old) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		bluez_test_backend_unref (old);
#line 2005 "backend.c"
	}
}


void bluez_test_value_take_backend (GValue* value, gpointer v_object) {
	BluezTestBackend * old;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BLUEZ_TEST_TYPE_BACKEND));
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	old = value->data[0].v_pointer;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (v_object) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BLUEZ_TEST_TYPE_BACKEND));
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		value->data[0].v_pointer = v_object;
#line 2024 "backend.c"
	} else {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		value->data[0].v_pointer = NULL;
#line 2028 "backend.c"
	}
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (old) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		bluez_test_backend_unref (old);
#line 2034 "backend.c"
	}
}


static void bluez_test_backend_class_init (BluezTestBackendClass * klass) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	bluez_test_backend_parent_class = g_type_class_peek_parent (klass);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	((BluezTestBackendClass *) klass)->finalize = bluez_test_backend_finalize;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_type_class_add_private (klass, sizeof (BluezTestBackendPrivate));
#line 2046 "backend.c"
}


static void bluez_test_backend_instance_init (BluezTestBackend * self) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv = BLUEZ_TEST_BACKEND_GET_PRIVATE (self);
#line 90 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_bluez = NULL;
#line 91 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_bluez_base = NULL;
#line 92 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_obex = NULL;
#line 93 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->priv->_mock_obex_base = NULL;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self->ref_count = 1;
#line 2063 "backend.c"
}


static void bluez_test_backend_finalize (BluezTestBackend * obj) {
	BluezTestBackend * self;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUEZ_TEST_TYPE_BACKEND, BluezTestBackend);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_signal_handlers_destroy (self);
#line 90 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_bluez);
#line 91 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_bluez_base);
#line 92 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_obex);
#line 93 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	_g_object_unref0 (self->priv->_mock_obex_base);
#line 2081 "backend.c"
}


/**
 * Controller for a mock BlueZ backend.
 *
 * This contains control methods to instantiate and manipulate a mock BlueZ
 * service over D-Bus, for the purposes of testing the folks BlueZ backend.
 *
 * The mock service uses python-dbusmock, with control messages being sent to
 * ``*.Mock`` interfaces on the D-Bus objects. Those control interfaces are
 * exposed as {@link Backend.mock_bluez}, {@link Backend.mock_bluez_base},
 * {@link Backend.mock_obex} and {@link Backend.mock_obex_base}.
 *
 * @since 0.9.7
 */
GType bluez_test_backend_get_type (void) {
	static volatile gsize bluez_test_backend_type_id__volatile = 0;
	if (g_once_init_enter (&bluez_test_backend_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { bluez_test_value_backend_init, bluez_test_value_backend_free_value, bluez_test_value_backend_copy_value, bluez_test_value_backend_peek_pointer, "p", bluez_test_value_backend_collect_value, "p", bluez_test_value_backend_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BluezTestBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluez_test_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluezTestBackend), 0, (GInstanceInitFunc) bluez_test_backend_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType bluez_test_backend_type_id;
		bluez_test_backend_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BluezTestBackend", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&bluez_test_backend_type_id__volatile, bluez_test_backend_type_id);
	}
	return bluez_test_backend_type_id__volatile;
}


gpointer bluez_test_backend_ref (gpointer instance) {
	BluezTestBackend * self;
	self = instance;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	g_atomic_int_inc (&self->ref_count);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	return instance;
#line 2119 "backend.c"
}


void bluez_test_backend_unref (gpointer instance) {
	BluezTestBackend * self;
	self = instance;
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		BLUEZ_TEST_BACKEND_GET_CLASS (self)->finalize (self);
#line 88 "/opt/gnome/source/folks/tests/lib/bluez/backend.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2132 "backend.c"
	}
}



