/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#define _C_MPAV_
#include <mpav.h>


int main( int argc, char *argv[] )
{
  int slave = 0;
  
  int c = 0;
  int option_index = 0;

  // BEGIN: Handle cmdline options
  while ( ( c = getopt_long( argc, argv, 
			     short_options, long_options,
			     &option_index ) ) != -1 )
    {
      switch ( c )
	{
	case 0: // long opt
	  if ( strcmp( long_options[ option_index ].name, "help" ) == 0 )
	    {
	      show_help( argv[ 0 ] );
	      return( 0 );
	    }
	  else if ( strcmp( long_options[ option_index ].name, "version" ) == 0 )
	    {
	      show_version();
	      return( 0 );
	    }
	  else if ( strcmp( long_options[ option_index ].name, "slave" ) == 0 )
	    slave = 1;
	  else if ( strcmp( long_options[ option_index ].name, "mpfile" ) == 0 )
	    sharedfile = optarg;
	  else if ( strcmp( long_options[ option_index ].name, "render-plugin" ) == 0 )
	    plugin_render.name = optarg;
	  break;

	  // Short opts
	case 'h':
	  show_help( argv[ 0 ] );
	  return( 0 );
	  break;

	case 'v':
	  show_version();
	  return( 0 );
	  break;

	case 's':
	  slave = 1;
	  break;

	case 'f':
	  sharedfile = optarg;
	  break;

	case 'r':
	  plugin_render.name = optarg;
	  break;

	default:
	  return( -1 );
	  break;	    
	}
    }

  if ( ! sharedfile )
    {
      sharedfile = (char *)calloc( ( strlen( getenv( "HOME" ) ) + strlen( SHARED_FILE ) ) + 2, 
				   sizeof( char ) );
      sprintf( sharedfile, "%s/%s", getenv( "HOME" ), SHARED_FILE );      
    }
  // END: Handle cmdline options

  
  
  /* SDL Init */
  if ( SDL_Init( SDL_INIT_VIDEO ) )
    {
      fprintf( stderr, "SDL ERROR: %s\n", SDL_GetError() );
      return( -1 );
    }
  TTF_Init();

  // Call Data import
  if ( data_import_init() )
    return( -1 );

  // Call Screen updater
  if ( screen_init() )
    return( -1 );

  // Call SDL Event handler
  if ( event_init() )
    return( -1 );

  // Call Slave (stdin interface) handler
  if ( slave )
    if ( slave_init() )
      return( -1 );

  while ( ! the_end )
    {
      sleep( 1 );
    }

  // End Slave 
  if ( slave )
    slave_quit();

  // End Event handler
  event_quit();

  // End Screen Updater
  screen_quit();

  // End Data Import
  data_import_quit();

  /* SDL Quit */
  TTF_Quit();
  SDL_Quit();


  return( 0 );
}

void show_help( char *progname )
{
  int i = 0;
  int j = 0;     // used along with 'size' to align descriptions
  int size = 20; // vide j
  show_version();

  printf( "Usage:\n\t%s [options]\nOptions:\n", progname );
  while ( long_options[ i ].name )
    {
      if ( long_options[ i ].val )
	printf( "   -%c,", long_options[ i ].val );
      else
	printf( "       " );

      printf( " --%s", long_options[ i ].name );
      j = strlen( long_options[ i ].name );
      if ( long_options[ i ].has_arg == required_argument )
	{
	  printf( "=%s", long_options_arg_desc[ i ] );
	  j += strlen( long_options_arg_desc[ i ] ) + 1;
	}
      else if ( long_options[ i ].has_arg == optional_argument )
	{
	  printf( "[=%s]", long_options_arg_desc[ i ] );
	  j += strlen( long_options_arg_desc[ i ] ) + 3;
	}
      // align to the left
      for (; j < size; j++)
	printf( " " );

      printf( " %s.\n", long_options_desc[ i ] );

      i++;
    }
  printf( "\n" );
}

void show_version()
{
  printf( "MPlayer Audio Visualization v.%s\n"
	  "Copyright (C) 2003 Gustavo Sverzut Barbieri <gustavo.barbieri@ic.unicamp.br>\n"
	  "*** This is GNU GPL software. ***\n"
	  "   This is free software; see the source for copying conditions.\n"
	  "   There is NO warranty; not even for MERCHANTABILITY or "
	  "FITNESS FOR A PARTICULAR PURPOSE.\n\n",
	  MPAV_VERSION );
}

