'''OpenGL extension EXT.bindable_uniform

This module customises the behaviour of the 
OpenGL.raw.GL.EXT.bindable_uniform to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension introduces the concept of bindable uniforms to the OpenGL
	Shading Language.  A uniform variable can be declared bindable, which
	means that the storage for the uniform is not allocated by the
	compiler/linker anymore, but is backed by a buffer object.  This buffer
	object is bound to the bindable uniform through the new command
	UniformBufferEXT().  Binding needs to happen after linking a program
	object.
	
	Binding different buffer objects to a bindable uniform allows an
	application to easily use different "uniform data sets", without having to
	re-specify the data every time.
	
	A buffer object can be bound to bindable uniforms in different program
	objects. If those bindable uniforms are all of the same type, accessing a
	bindable uniform in program object A will result in the same data if the
	same access is made in program object B.  This provides a mechanism for
	'environment uniforms', uniform values that can be shared among multiple
	program objects.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/EXT/bindable_uniform.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL import _types
from OpenGL.raw.GL.EXT.bindable_uniform import *
from OpenGL.raw.GL.EXT.bindable_uniform import _EXTENSION_NAME

def glInitBindableUniformEXT():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )

### END AUTOGENERATED SECTION