import System.Environment
import Text.CSL
import Text.CSL.Test
import Text.JSON.Generic

main :: IO ()
main = do
  args <- getArgs
  case args of
    [c,r] -> readStruff c r [] >>= putStrLn
    _ -> error "usage:    kljlkjljlkjlkjl"

readStruff :: String -> String -> String -> IO String
readStruff c r s = do
  c' <- readFile c
  r' <- readBiblioFile r
  return $ mode "citation" ++ result [] ++ citationItems r' ++ csl c' ++ input r'

mode :: String -> String
mode s = ">>===== MODE =====>>\n" ++ s ++ "\n<<===== MODE =====<<\n\n"

result :: String -> String
result s = ">>===== RESULT =====>>\n" ++ s ++ "\n<<===== RESULT =====<<\n\n"

citationItems :: [Reference] -> String
citationItems l = ">>===== CITATION-ITEMS =====>>\n[\n    [\n" ++ toId ++
                  "\n    ]\n]\n<<===== CITATION-ITEMS =====<<\n\n"
    where
      toId = foldr addComma [] toStringList
      addComma x xs = if length xs < 1 then x ++ xs else x ++ ",\n" ++ xs
      toStringList = flip map l $ \x -> "        {\n            \"id\": \"" ++ refId x ++ "\"\n        }"

csl :: String -> String
csl s = ">>===== CSL =====>>\n" ++ s ++ "<<===== CSL =====<<\n\n"

input :: [Reference] -> String
input s = ">>===== INPUT =====>>\n" ++ encodeJSON s ++ "\n<<===== INPUT =====<<\n\n"
