// types.h
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Author: riley@google.com (Michael Riley)
//
// \file
// Various type definitions (mostly for Google compatibility).

#include <cstdlib>       // for ssize_t
#include <stdint.h>      // *int*_t

#include <fst/compat.h>  // for DISALLOW_COPY_AND_ASSIGN

#ifndef FST_LIB_TYPES_H__
#define FST_LIB_TYPES_H__

typedef int8_t int8;
typedef int16_t int16;
typedef int32_t int32;
typedef int64_t int64;

typedef uint8_t uint8;
typedef uint16_t uint16;
typedef uint32_t uint32;
typedef uint64_t uint64;

#endif  // FST_LIB_TYPES_H__
