{- This module was generated from data in the Kate syntax
   highlighting file literate-curry.xml, version 0.2, by Björn Peemöller (bjp@informatik.uni-kiel.de) -}

module Text.Highlighting.Kate.Syntax.LiterateCurry
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Curry
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Literate Curry"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.lcurry"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Literate Curry","Text")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Literate Curry","Text") -> return ()
      ("Literate Curry","Code") -> (popContext) >> pEndLine
      ("Literate Curry","normals") -> return ()
      ("Literate Curry","multiline") -> pushContext ("Literate Curry","lineend") >> return ()
      ("Literate Curry","lineend") -> return ()
      ("Literate Curry","restart") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'5c'7b'2d'5b'5e'23'5d = compileRegex "\\{-[^#]"

parseRules ("Literate Curry","Text") =
  (((pColumn 0 >> pDetectChar False '>' >>= withAttribute OtherTok) >>~ pushContext ("Literate Curry","Code"))
   <|>
   ((pColumn 0 >> pDetectChar False '<' >>= withAttribute OtherTok) >>~ pushContext ("Literate Curry","Code"))
   <|>
   ((pString False "\\begin{code}" >>= withAttribute NormalTok) >>~ pushContext ("Literate Curry","normals"))
   <|>
   ((pString False "\\begin{spec}" >>= withAttribute NormalTok) >>~ pushContext ("Literate Curry","normals"))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Curry","Text")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Curry","Code") =
  (((pRegExpr regex_'5c'7b'2d'5b'5e'23'5d >>= withAttribute CommentTok) >>~ pushContext ("Literate Curry","multiline"))
   <|>
   ((Text.Highlighting.Kate.Syntax.Curry.parseExpression (Just ("Curry",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Curry","Code")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Curry","normals") =
  (((pString False "\\end{code}" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pString False "\\end{spec}" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Curry.parseExpression (Just ("Curry",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Curry","normals")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Curry","multiline") =
  (((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Curry","multiline")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Literate Curry","lineend") =
  (((pColumn 0 >> pDetectChar False '>' >>= withAttribute OtherTok) >>~ pushContext ("Literate Curry","restart"))
   <|>
   ((pColumn 0 >> pDetectChar False '<' >>= withAttribute OtherTok) >>~ pushContext ("Literate Curry","restart"))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Curry","lineend")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Literate Curry","restart") =
  (((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext >> popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Literate Curry","restart")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Curry", _) = Text.Highlighting.Kate.Syntax.Curry.parseExpression Nothing

parseRules x = parseRules ("Literate Curry","Text") <|> fail ("Unknown context" ++ show x)
