{- This module was generated from data in the Kate syntax
   highlighting file fasm.xml, version 0.2, by rCX (rCX12@yahoo.com) -}

module Text.Highlighting.Kate.Syntax.Fasm
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Intel x86 (FASM)"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.asm;*.inc;*.fasm"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Intel x86 (FASM)","Normal")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = False, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Intel x86 (FASM)","Normal") -> return ()
      ("Intel x86 (FASM)","Comment") -> (popContext) >> pEndLine
      ("Intel x86 (FASM)","Preprocessor") -> (popContext) >> pEndLine
      ("Intel x86 (FASM)","String") -> (popContext) >> pEndLine
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_registers = Set.fromList $ words $ "rax eax ax ah al rbx ebx bx bh bl rcx ecx cx ch cl rdx edx dx dh dl rbp ebp bp rsi esi si rdi edi di rsp esp sp r8 r9 r10 r11 r12 r13 r14 r15 cs ds es fs gs ss cr0 cr2 cr3 cr4 dr0 dr1 dr2 dr3 dr6 dr7 st mm0 mm1 mm2 mm3 mm4 mm5 mm6 mm7 xmm0 xmm1 xmm2 xmm3 xmm4 xmm5 xmm6 xmm7"
list_instructions = Set.fromList $ words $ "aaa aad aam aas adc add addpd addps addsd addss addsubpd addsubps and andnpd andnps andpd andps arpl bound bsf bsr bswap bt btc btr bts call cbw cwde cwd cdq cdqe cqo clc cld clgi cli clts clflush cmc cmova cmovae cmovb cmovbe cmovc cmove cmovg cmovge cmovl cmovle cmovna cmovnae cmovnb cmovnbe cmovnc cmovne cmovng cmovnge cmovnl cmovnle cmovno cmovnp cmovns cmovnz cmovo cmovp cmovpe cmovpo cmovs cmovz cmp cmpeqpd cmpeqps cmpeqsd cmpeqss cmplepd cmpleps cmplesd cmpless cmpltpd cmpltps cmpltsd cmpltss cmpneqpd cmpneqps cmpneqsd cmpneqss cmpnlepd cmpnleps cmpnlesd cmpnless cmpnltpd cmpnltps cmpnltsd cmpnltss cmpordpd cmpordps cmpordsd cmpordss cmppd cmpps cmps cmpsb cmpsd cmpss cmpsw cmpunordpd cmpunordps cmpunordsd cmpunordss cmpxchg cmpxchg486 cmpxchg8b cmpxchg16b comisd comiss cpuid cvtdq2pd cvtdq2ps cvtpd2dq cvtpd2pi cvtpd2ps cvtpi2pd cvtpi2ps cvtps2dq cvtps2pd cvtps2pi cvtsd2si cvtsd2ss cvtsi2sd cvtsi2ss cvtss2sd cvtss2si cvttpd2dq cvttpd2pi cvttps2dq cvttps2pi cvttsd2si cvttss2si daa das dec div divpd divps divsd divss emms enter f2xm1 fabs fadd faddp fbld fbstp fchs fclex fnclex fcmovb fcmovbe fcmove fcmovnb fcmovnbe fcmovne fcmovnu fcmovu fcom fcomp fcompp fcomi fcomip fcos fdecstp fdisi feni fdiv fdivr fdivp fdivrp femms ffree ffreep fiadd ficom ficomp fidiv fidivr fild fimul fincstp finit fist fistp fisttp fisub fisubr fld fld1 fldl2e fldl2t fldlg2 fldln2 fldcw fldenv fldpi fldz fmul fmulp fndisi fneni fninit fnop fnsave fnstcw fnstenv fnstsw fnwait fpatan fptan fprem fprem1 frndint frstor fsave fscale fsetpm fsin fsincos fsqrt fst fstp fstcw fstenv fstsw fsub fsubr fsubp fsubrp ftst fucom fucomp fucompp fucomi fucomip fwait fxam fxch fxrstor fxsave fxtract fyl2x fyl2xp1 haddpd haddps hlt hsubpd hsubps ibts idiv imul in inc ins insb insd insw int int1 int3 into invd invlpg invlpga iret iretd iretq iretw ja jae jb jbe jc je jg jge jl jle jna jnae jnb jnbe jnc jne jng jnge jnl jnle jno jnp jns jnz jo jp jpe jpo js jz jcxz jecxz jrcxz jmp lahf lar lddqu ldmxcsr lds les lea leave lfence lfs lgdt lgs lidt lldt lmsw loadall loadall286 lods lodsb lodsd lodsq lodsw loop loope loopne loopnz loopz lsl lss ltr maskmovdqu maskmovq maxpd maxps maxsd maxss mfence minpd minps minsd minss monitor mov movapd movaps movd movddup movdq2q movdqa movdqu movhlps movhpd movhps movlhps movlpd movlps movmskpd movmskps movntdq movnti movntpd movntps movntq movq movq2dq movs movsb movsd movshdup movsldup movsq movss movsx movsxd movsw movupd movups movzx mul mulpd mulps mulsd mulss mwait neg nop not or orpd orps out outs outsb outsw outsd packssdw packsswb packuswb paddb paddd paddq paddsb paddsw paddusb paddusw paddw pand pandn pause pavgb pavgusb pavgw pcmpeqb pcmpeqw pcmpeqd pcmpgtb pcmpgtw pcmpgtd pdistib pextrw pf2id pf2iw pfacc pfadd pfcmpeq pfcmpge pfcmpgt pfmax pfmin pfmul pfnacc pfpnacc pfrcp pfrcpit1 pfrcpit2 pfrsqit1 pfrsqrt pfsub pfsubr pi2fd pi2fw pinsrw pmachriw pmaddwd pmagw pmaxsw pmaxub pminsw pminub pmovmskb pmulhrw pmulhuw pmulhw pmullw pmuludq pmvgezb pmvlzb pmvnzb pmvzb pop popa popaw popad popf popfw popfd popfq por prefetch prefetchnta prefetcht0 prefetcht1 prefetcht2 prefetchw psadbw pshufd pshufhw pshuflw pshufw pslld pslldq psllq psllw psrad psraw psrld psrldq psrlq psrlw psubb psubd psubq psubsb psubsiw psubsw psubusb psubusw psubw pswapd punpckhbw punpckhdq punpckhqdq punpckhwd punpcklbw punpckldq punpcklqdq punpcklwd push pusha pushad pushaw pushf pushfd pushfq pushfw pxor rcl rcr rcpps rcpss rdmsr rdpmc rdshr rdtsc rdtscp ret retf retn rol ror rsdc rsldt rsm rsqrtps rsqrtss rsts sahf sal sar salc sbb scas scasb scasd scasq scasw seta setae setb setbe setc sete setg setge setl setle setna setnae setnb setnbe setnc setne setng setnge setnl setnle setno setnp setns setnz seto setp setpe setpo sets setz sfence sgdt shl shld shr shrd shufpd shufps sidt skinit sldt smi smint smintold smsw sqrtpd sqrtps sqrtsd sqrtss stc std stgi sti stmxcsr stos stosb stosd stosq stosw str sub subpd subps subsd subss svdc svldt svts swapgs syscall sysenter sysexit sysret test ucomisd ucomiss ud0 ud1 ud2 umov unpckhpd unpckhps unpcklpd unpcklps verr verw vmload vmmcall vmrun vmsave wait wbinvd wrmsr wrshr xadd xbts xchg xlat xlatb xor xorpd xorps"
list_Data = Set.fromList $ words $ "db dw du dd dp df dq dt rb rw rd rp rf rq rt file byte word dword pword qword tbyte tword dqword ptr"
list_Preprocessor_Keywords = Set.fromList $ words $ "append at break common display else end equ fix foward if irp irps label local match macro purge repeat rept reverse restore struc times while virtual"
list_Instruction'2dlike_Keywords = Set.fromList $ words $ "align entry extrn format include invoke data load from heap org proc public section segment stack store use16 use32 use64"

regex_'5cs'2a'5bA'2dZa'2dz0'2d9'40'5f'2e'24'3f'5d'2b'3a = compileRegex True "\\s*[A-Za-z0-9@_.$?]+:"
regex_'28cmov'7cfcmov'7cj'7cloop'7cset'29'28a'7cae'7cb'7cbe'7cc'7ce'7cg'7cge'7cl'7cle'7cna'7cnae'7cnb'7cnbe'7cnc'7cne'7cng'7cnge'7cnl'7cnle'7cno'7cnp'7cns'7cnz'7co'7cp'7cpe'7cpo'7cs'7cz'29 = compileRegex True "(cmov|fcmov|j|loop|set)(a|ae|b|be|c|e|g|ge|l|le|na|nae|nb|nbe|nc|ne|ng|nge|nl|nle|no|np|ns|nz|o|p|pe|po|s|z)"
regex_'28'5e'7c'5b_'5ct'2c'5d'2b'29'28'28'5c'24'7c0x'29'7b1'7d'5b0'2d9'5d'2b'5ba'2df0'2d9'5d'2a'7c'5ba'2df0'2d9'5d'2bh'29'28'5b_'5ct'2c'5d'2b'7c'24'29 = compileRegex True "(^|[ \\t,]+)((\\$|0x){1}[0-9]+[a-f0-9]*|[a-f0-9]+h)([ \\t,]+|$)"
regex_'28'5e'7c'5b_'5ct'2c'5d'2b'29'28'5b0'2d7'5d'2b'28q'7co'29'7c'5b01'5d'2bb'29'28'5b_'5ct'2c'5d'2b'7c'24'29 = compileRegex True "(^|[ \\t,]+)([0-7]+(q|o)|[01]+b)([ \\t,]+|$)"

parseRules ("Intel x86 (FASM)","Normal") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_registers >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Data >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_instructions >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Instruction'2dlike_Keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_Preprocessor_Keywords >>= withAttribute OtherTok))
   <|>
   ((pDetectChar False ';' >>= withAttribute CommentTok) >>~ pushContext ("Intel x86 (FASM)","Comment"))
   <|>
   ((pAnyChar "\"'" >>= withAttribute StringTok) >>~ pushContext ("Intel x86 (FASM)","String"))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5cs'2a'5bA'2dZa'2dz0'2d9'40'5f'2e'24'3f'5d'2b'3a >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'28cmov'7cfcmov'7cj'7cloop'7cset'29'28a'7cae'7cb'7cbe'7cc'7ce'7cg'7cge'7cl'7cle'7cna'7cnae'7cnb'7cnbe'7cnc'7cne'7cng'7cnge'7cnl'7cnle'7cno'7cnp'7cns'7cnz'7co'7cp'7cpe'7cpo'7cs'7cz'29 >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5e'7c'5b_'5ct'2c'5d'2b'29'28'28'5c'24'7c0x'29'7b1'7d'5b0'2d9'5d'2b'5ba'2df0'2d9'5d'2a'7c'5ba'2df0'2d9'5d'2bh'29'28'5b_'5ct'2c'5d'2b'7c'24'29 >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'28'5e'7c'5b_'5ct'2c'5d'2b'29'28'5b0'2d7'5d'2b'28q'7co'29'7c'5b01'5d'2bb'29'28'5b_'5ct'2c'5d'2b'7c'24'29 >>= withAttribute BaseNTok))
   <|>
   ((pDetectChar False '$' >>= withAttribute DecValTok))
   <|>
   ((pHlCOct >>= withAttribute BaseNTok))
   <|>
   ((pHlCHex >>= withAttribute BaseNTok))
   <|>
   ((pFloat >>= withAttribute FloatTok))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pHlCChar >>= withAttribute CharTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Intel x86 (FASM)","Normal")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Intel x86 (FASM)","Comment") =
  (currentContext >>= \x -> guard (x == ("Intel x86 (FASM)","Comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Intel x86 (FASM)","Preprocessor") =
  (currentContext >>= \x -> guard (x == ("Intel x86 (FASM)","Preprocessor")) >> pDefault >>= withAttribute OtherTok)

parseRules ("Intel x86 (FASM)","String") =
  (((pAnyChar "\"'" >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Intel x86 (FASM)","String")) >> pDefault >>= withAttribute StringTok))


parseRules x = parseRules ("Intel x86 (FASM)","Normal") <|> fail ("Unknown context" ++ show x)
