{- This module was generated from data in the Kate syntax
   highlighting file idris.xml, version 1.0, by Alexander Shabalin -}

module Text.Highlighting.Kate.Syntax.Idris
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Idris"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.idr"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Idris","code")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStContinuation = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  st <- getState
  if length contexts >= 2
    then case context of
      _ | synStContinuation st -> updateState $ \st -> st{ synStContinuation = False }
      ("Idris","code") -> return ()
      ("Idris","declaration") -> (popContext) >> pEndLine
      ("Idris","directive") -> (popContext) >> pEndLine
      ("Idris","char") -> (popContext) >> pEndLine
      ("Idris","string") -> return ()
      ("Idris","line comment") -> (popContext) >> pEndLine
      ("Idris","block comment") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

list_keywords = Set.fromList $ words $ "abstract auto case class codata covering data default do dsl else if implicit import impossible in index_first index_next infix infixl infixr instance lambda let module mututal namespace of parameters partial pattern postulate prefix private proof public record rewrite static syntax tactics term then total using variable where with"
list_directives = Set.fromList $ words $ "access assert_total default dynamic elim error_handlers error_reverse flag hide include language lib link name provide reflection"
list_tactics = Set.fromList $ words $ "applyTactic attack compute exact fill focus induction intro intros let refine reflect rewrite solve trivial try"

regex_'2d'2d'2d'2a'5b'5e'21'23'5c'24'25'26'5c'2a'5c'2b'2f'3c'3d'3e'5c'3f'5c'40'5c'5e'5c'7c'7e'5c'2e'3a'5d'3f = compileRegex True "---*[^!#\\$%&\\*\\+/<=>\\?\\@\\^\\|~\\.:]?"
regex_'5c'7c'5c'7c'5c'7c'5b'5e'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'2f'3c'3d'3e'5c'3f'5c'40'5c'5e'5c'7c'7e'5c'2e'3a'5d'3f = compileRegex True "\\|\\|\\|[^\\-!#\\$%&\\*\\+/<=>\\?\\@\\^\\|~\\.:]?"
regex_'5cs'2a'28'5ba'2dz'5d'2b'5cs'2b'29'2a'28'5bA'2dZa'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'27'2a'7c'5c'28'5b'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'5c'2e'2f'3c'3d'3e'5c'3f'40'5c'5c'5e'5c'7c'7e'3a'5d'2b'5c'29'29'5cs'2a'3a = compileRegex True "\\s*([a-z]+\\s+)*([A-Za-z][A-Za-z0-9_]*'*|\\([\\-!#\\$%&\\*\\+\\./<=>\\?@\\\\^\\|~:]+\\))\\s*:"
regex_0'5bXx'5d'5b0'2d9A'2dFa'2df'5d'2b = compileRegex True "0[Xx][0-9A-Fa-f]+"
regex_'5cd'2b'5c'2e'5cd'2b'28'5beE'5d'5b'2d'2b'5d'3f'5cd'2b'29'3f = compileRegex True "\\d+\\.\\d+([eE][-+]?\\d+)?"
regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'27'2a'7c'5f'5c'7c'5f'29 = compileRegex True "([A-Z][a-zA-Z0-9_]*'*|_\\|_)"
regex_'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'27'2a = compileRegex True "[a-z][a-zA-Z0-9_]*'*"
regex_'5c'3f'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2b'27'2a = compileRegex True "\\?[a-z][A-Za-z0-9_]+'*"
regex_'28'3a'7c'3d'3e'7c'5c'2d'3e'7c'3c'5c'2d'29 = compileRegex True "(:|=>|\\->|<\\-)"
regex_'28'5b'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'5c'2e'2f'3c'3d'3e'5c'3f'40'5c'5c'5e'5c'7c'7e'3a'5d'2b'7c'5cb'5f'5cb'29 = compileRegex True "([\\-!#\\$%&\\*\\+\\./<=>\\?@\\\\^\\|~:]+|\\b_\\b)"
regex_'60'5bA'2dZa'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'27'2a'60 = compileRegex True "`[A-Za-z][A-Za-z0-9_]*'*`"
regex_'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'27'2a = compileRegex True "[a-z][A-Za-z0-9_]*'*"
regex_'5c'28'5b'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'5c'2e'2f'3c'3d'3e'5c'3f'40'5c'5c'5e'5c'7c'7e'3a'5d'2b'5c'29 = compileRegex True "\\([\\-!#\\$%&\\*\\+\\./<=>\\?@\\\\^\\|~:]+\\)"
regex_'5c'5c'2e = compileRegex True "\\\\."
regex_'22 = compileRegex True "\""

parseRules ("Idris","code") =
  (((pRegExpr regex_'2d'2d'2d'2a'5b'5e'21'23'5c'24'25'26'5c'2a'5c'2b'2f'3c'3d'3e'5c'3f'5c'40'5c'5e'5c'7c'7e'5c'2e'3a'5d'3f >>= withAttribute CommentTok) >>~ pushContext ("Idris","line comment"))
   <|>
   ((pRegExpr regex_'5c'7c'5c'7c'5c'7c'5b'5e'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'2f'3c'3d'3e'5c'3f'5c'40'5c'5e'5c'7c'7e'5c'2e'3a'5d'3f >>= withAttribute CommentTok) >>~ pushContext ("Idris","line comment"))
   <|>
   ((pDetect2Chars False '{' '-' >>= withAttribute CommentTok) >>~ pushContext ("Idris","block comment"))
   <|>
   ((pColumn 0 >> lookAhead (pRegExpr regex_'5cs'2a'28'5ba'2dz'5d'2b'5cs'2b'29'2a'28'5bA'2dZa'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'27'2a'7c'5c'28'5b'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'5c'2e'2f'3c'3d'3e'5c'3f'40'5c'5c'5e'5c'7c'7e'3a'5d'2b'5c'29'29'5cs'2a'3a) >> pushContext ("Idris","declaration") >> currentContext >>= parseRules))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '%' >>= withAttribute KeywordTok) >>~ pushContext ("Idris","directive"))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_tactics >>= withAttribute KeywordTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Idris","char"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Idris","string"))
   <|>
   ((pInt >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_0'5bXx'5d'5b0'2d9A'2dFa'2df'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_0'5bXx'5d'5b0'2d9A'2dFa'2df'5d'2b >>= withAttribute BaseNTok))
   <|>
   ((pRegExpr regex_'5cd'2b'5c'2e'5cd'2b'28'5beE'5d'5b'2d'2b'5d'3f'5cd'2b'29'3f >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'27'2a'7c'5f'5c'7c'5f'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5ba'2dz'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'27'2a >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'5c'3f'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2b'27'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'3a'7c'3d'3e'7c'5c'2d'3e'7c'3c'5c'2d'29 >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'5c'2e'2f'3c'3d'3e'5c'3f'40'5c'5c'5e'5c'7c'7e'3a'5d'2b'7c'5cb'5f'5cb'29 >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'60'5bA'2dZa'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'27'2a'60 >>= withAttribute FunctionTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Idris","code")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Idris","declaration") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pRegExpr regex_'28'5bA'2dZ'5d'5ba'2dzA'2dZ0'2d9'5f'5d'2a'27'2a'7c'5f'5c'7c'5f'29 >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5ba'2dz'5d'5bA'2dZa'2dz0'2d9'5f'5d'2a'27'2a >>= withAttribute FunctionTok))
   <|>
   ((pRegExpr regex_'5c'28'5b'5c'2d'21'23'5c'24'25'26'5c'2a'5c'2b'5c'2e'2f'3c'3d'3e'5c'3f'40'5c'5c'5e'5c'7c'7e'3a'5d'2b'5c'29 >>= withAttribute FunctionTok))
   <|>
   ((pDetectChar False ':' >>= withAttribute OtherTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Idris","declaration")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Idris","directive") =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_directives >>= withAttribute KeywordTok))
   <|>
   (currentContext >>= \x -> guard (x == ("Idris","directive")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Idris","char") =
  (((pRegExpr regex_'5c'5c'2e >>= withAttribute CharTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Idris","char")) >> pDefault >>= withAttribute CharTok))

parseRules ("Idris","string") =
  (((pRegExpr regex_'5c'5c'2e >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'22 >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Idris","string")) >> pDefault >>= withAttribute StringTok))

parseRules ("Idris","line comment") =
  (currentContext >>= \x -> guard (x == ("Idris","line comment")) >> pDefault >>= withAttribute CommentTok)

parseRules ("Idris","block comment") =
  (((pDetect2Chars False '-' '}' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   ((pDetect2Chars False '{' '-' >>= withAttribute CommentTok) >>~ pushContext ("Idris","block comment"))
   <|>
   (currentContext >>= \x -> guard (x == ("Idris","block comment")) >> pDefault >>= withAttribute CommentTok))


parseRules x = parseRules ("Idris","code") <|> fail ("Unknown context" ++ show x)
