package org.mozilla.jss.tests;

import java.util.Arrays;

import org.mozilla.jss.netscape.security.util.Utils;

public class Base64Parsing {
	public static String mime =     "MIICjDCCAXQCAQIwADCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALdt\nHPsAesaTlWRE3pyW6PtDhbQSUt/jYbKSxLMR7uln7YNiL74pYHFNZ9ZrW51GWPF0\nKqldtx6c3zAweynehJtI/AR5pDtHi8bh8L8mqLpsJXgSx5laAGt2n/aAXNxJNS85\n4b/q6lV7k6nIfECsZwTkQV3LCEISjbW9jNLQsuSAV/TznJ3UoEmZh9YMA+cwpBBo\nnLcHxRx+0ymq9R53yUCyAUfLWl0pbfUlCF0EKHJ25et/T8TftzMqdLFJ23gyONdj\nzgPhc0fNN4fKYqvisg/9V+v0NaVR8VtV1yOhRZp4qy+7JCC6veCb1BZtAVfYJYA4\nMj+k9Una6z6Qnjl97VECAwEAAaBHMEUGCSqGSIb3DQEJDjE4MDYwNAYDVR0RBC0w\nK4Ipdm0tMTcxLTEyNC5hYmMuaWRtLmxhYi5lbmcuYnJxLnJlZGhhdC5jb20wDQYJ\nKoZIhvcNAQELBQADggEBAImj0y3AaGwCxlkgkGtlou4eookqD/xnaeckmS3cil5M\nA6Ff1Ec0orcYBTNBIGwjQN7Z7FC/7ALOa4E94AfqFl6kquy4ArxrVsP3OIC5kGE6\nkLcz6F2MJCRuNQdGdxBujlCYyjv4Wr67rLgzeSUD+DGPMehFvdQxTW8VorKBaIxx\ntFtqiFZtEs/9bSVfw0jzC4a5maM77kl819I9TXNwwEjGd3/eNmab42qvp9KvXS6Y\nhTD+sqE5GmL09YvV3KR1vU1o+9iGJF9Nvg8xOROzTCN+U+TKLv982kbOrrKYwdgn\nfYlMwsGlnPuwSNhMH51fxZU5o/F6EXOAdLqIEPEuFQo=\n";
	public static String url_safe = "MIICjDCCAXQCAQIwADCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBALdtHPsAesaTlWRE3pyW6PtDhbQSUt_jYbKSxLMR7uln7YNiL74pYHFNZ9ZrW51GWPF0Kqldtx6c3zAweynehJtI_AR5pDtHi8bh8L8mqLpsJXgSx5laAGt2n_aAXNxJNS854b_q6lV7k6nIfECsZwTkQV3LCEISjbW9jNLQsuSAV_TznJ3UoEmZh9YMA-cwpBBonLcHxRx-0ymq9R53yUCyAUfLWl0pbfUlCF0EKHJ25et_T8TftzMqdLFJ23gyONdjzgPhc0fNN4fKYqvisg_9V-v0NaVR8VtV1yOhRZp4qy-7JCC6veCb1BZtAVfYJYA4Mj-k9Una6z6Qnjl97VECAwEAAaBHMEUGCSqGSIb3DQEJDjE4MDYwNAYDVR0RBC0wK4Ipdm0tMTcxLTEyNC5hYmMuaWRtLmxhYi5lbmcuYnJxLnJlZGhhdC5jb20wDQYJKoZIhvcNAQELBQADggEBAImj0y3AaGwCxlkgkGtlou4eookqD_xnaeckmS3cil5MA6Ff1Ec0orcYBTNBIGwjQN7Z7FC_7ALOa4E94AfqFl6kquy4ArxrVsP3OIC5kGE6kLcz6F2MJCRuNQdGdxBujlCYyjv4Wr67rLgzeSUD-DGPMehFvdQxTW8VorKBaIxxtFtqiFZtEs_9bSVfw0jzC4a5maM77kl819I9TXNwwEjGd3_eNmab42qvp9KvXS6YhTD-sqE5GmL09YvV3KR1vU1o-9iGJF9Nvg8xOROzTCN-U-TKLv982kbOrrKYwdgnfYlMwsGlnPuwSNhMH51fxZU5o_F6EXOAdLqIEPEuFQo";

	public static void main(String[] args) throws Exception {
		byte[] mime_data = Utils.base64decode(mime);
		assert(mime_data.length == 656);

		byte[] url_data = Utils.base64decode(url_safe);
		assert(url_data.length == 656);

		assert(Arrays.equals(mime_data, url_data));
	}
}
