/*
 *  SPDX-FileCopyrightText: 2016 Dmitry Kazakov <dimula73@gmail.com>
 *
 *  SPDX-License-Identifier: GPL-2.0-or-later
 */

#include "kis_derived_resources_test.h"

#include <simpletest.h>
#include <brushengine/kis_paintop_preset.h>

#include <QApplication>

#include <KoCanvasResourceProvider.h>

#include "kis_canvas_resource_provider.h"
#include <util.h>
#include <KisMainWindow.h>
#include <KisDocument.h>
#include <KisPart.h>
#include <KisView.h>
#include <KisViewManager.h>
#include <kis_paintop_settings.h>
#include <KoResourcePaths.h>
#include <kis_config.h>
#include <testutil.h>
#include "opengl/kis_opengl.h"
#include <KisGlobalResourcesInterface.h>

#include  <sdk/tests/testui.h>

void KisDerivedResourcesTest::test()
{
    QScopedPointer<KoCanvasResourceProvider> manager(new KoCanvasResourceProvider());
    KisViewManager::initializeResourceManager(manager.data());

    QApplication::processEvents();

    QString presetFileName = "autobrush_300px.kpp";

    QVariant i;

    KisPaintOpPresetSP preset;
    if (!presetFileName.isEmpty()) {
        QString fullFileName = TestUtil::fetchDataFileLazy(presetFileName);
        preset = KisPaintOpPresetSP(new KisPaintOpPreset(fullFileName));
        bool presetValid = preset->load(KisGlobalResourcesInterface::instance());
        Q_ASSERT(presetValid); Q_UNUSED(presetValid);

        i.setValue(preset);
    }

    QVERIFY(i.isValid());

    QSignalSpy spy(manager.data(), SIGNAL(canvasResourceChanged(int,QVariant)));

    manager->setResource(KoCanvasResource::CurrentPaintOpPreset, i);

    QMap<int, QVariant> expectedSignals;
    expectedSignals[KoCanvasResource::CurrentPaintOpPreset] = QVariant::fromValue(preset);
    expectedSignals[KoCanvasResource::EraserMode] = false;
    expectedSignals[KoCanvasResource::LodSizeThresholdSupported] = true;
    expectedSignals[KoCanvasResource::LodSizeThreshold] = 100;
    expectedSignals[KoCanvasResource::LodAvailability] = true;
    expectedSignals[KoCanvasResource::Opacity] = 1.0;
    expectedSignals[KoCanvasResource::Size] = 300.0;
    expectedSignals[KoCanvasResource::Flow] = 1.0;
    expectedSignals[KoCanvasResource::CurrentEffectiveCompositeOp] = COMPOSITE_OVER;
    expectedSignals[KoCanvasResource::CurrentCompositeOp] = COMPOSITE_OVER;
    expectedSignals[KoCanvasResource::PatternSize] = 0.5;

    // this signal is not generated by the derived resources, but by GUI elements,
    // which are not available in the unittest
    // expectedSignals[KoCanvasResource::EffectiveLodAvailablility] = true;

    auto it = spy.begin();
    for (; it != spy.end(); ++it) {
        const int id = (*it)[0].toInt();
        const QVariant value = (*it)[1];

        if (!expectedSignals.contains(id)) {
            qDebug() << ppVar(id) << ppVar(value);
            QFAIL("Unexpected signal!");
        } else {
            if (expectedSignals[id] != value) {
                qDebug() << ppVar(id) << ppVar(value) << ppVar(expectedSignals[id]);
                QFAIL("Unexpected value!");
            }
        }
    }

    QCOMPARE(spy.size(), expectedSignals.size());

    spy.clear();

    preset->settings()->setPaintOpOpacity(0.8);

    QTest::qWait(200);

    QCOMPARE(spy.size(), 1);
    QCOMPARE(spy[0][0].toInt(), (int)KoCanvasResource::Opacity);
    QCOMPARE(spy[0][1].toDouble(), 0.8);
    spy.clear();
}

KISTEST_MAIN(KisDerivedResourcesTest)
