/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#ifndef UTILS_H
#define UTILS_H

#include <QProcess>
#include <QList>
#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QStringList>
#include <QtNetwork/QHostAddress>

#include <ktemporaryfile.h>

#include "kvpncconfig.h"
#include "toolinfo.h"

/**
 * Provides various help functions.
 */
class Utils : public QObject
{
    Q_OBJECT

public:
    Utils(KVpncConfig* config, QObject *parent = 0);
    ~Utils();

    bool isValidIPv4Address(QString Address);
    bool isValidIPv4NetworkAddress(QString Address);
    bool isValidIPv4BroadcastAddress(QString Address);
    bool isValidIPv4Netmask(QString Netmask);
    bool tunDevExists();
    bool createTunDev();
    bool loadKernelModule(QString Name, QApplication *app);
    bool unloadKernelModule(QString Name, QApplication *app, bool force = true);
    bool doChmod(QString file, QString mode);
    bool resolvConfAvailable();
    QStringList getOpenvpnCiphers();
    QStringList getOpenvpnDigests();
    QList<ToolInfo *>* getToolList();
    ToolInfo* getToolInfo(QString name);
    QString resolveName(QString Name);
    QString removeSpecialCharsForFilename(QString filename);
    QString getNameAndPidOfProgramListen(int port);
    QString getEmailAddressOfCert(QString cert);
    QString getHostname();
    QStringList getSmartcardSlots(QString ProviderLib);
    QStringList getSmartcardCertsFromSlot(QString slot, QString IdType, QString ProviderLib);
    bool getNeedsPassphrase(QString key);
    QStringList getCertsFromCiscoCertStore(QString type = "user");
	QString dec2bin(int n);
	int dottedIpv4Netmask2NetmaskBytes(QString dottedIpv4Netmask);
    QString IpsecAlgoCurrent;

    struct IpsecAlgos {
        QStringList IpsecIkeEncryptionAlgorithms;
        QStringList IpsecIkeHashAlgorithms;
        QStringList IpsecIkeDhGroups;
        QStringList IpsecEspEncryptionAlgorithms;
        QStringList IpsecEspAuthenticationAlgorithms;
        QStringList IpsecCompressionAlgorithms;
    };

    struct PppdCapabilities {
        bool pppdHasMppeRequiredSupport;
        bool pppdHasRequireMppeSupport;
        bool pppdHasReplacedefaultrouteSupport;

        /* options for pppd depending on pppd version */

        // MPPE
        QString RequireMppeOption;
        QString Require128BitMppeOption;
        QString RefuseMppeOption;
        QString Refuse40BitMppeOption;
        QString Refuse128BitMppeOption;
        QString RequireStatelessOption;
        QString RequireStatefulOption;
        bool MppeOptionsInALine; // older pppd need all in one line

        // AUTH
        QString RequireAuthChapOption;
        QString RequireAuthMschapOption;
        QString RequireAuthMschapv2Option;
        QString RequireAuthPapOption;

        bool pppdHasMppeSupport; //< true if pppd has mppe support
        bool oldPppdStyle; //< true if old style was found ('mppe require')
        bool pppdOk; // if pppd could started
    };

    struct IpsecAlgos getKernelCrypto();
    struct IpsecAlgos getIpsecAlgos();
    struct PppdCapabilities checkPppdCapabilities();

public slots:
    void readStdOutCreateTunDev();
    void readStdErrCreateTunDev();
    void readStdOutLoadKernelModule();
    void readStdErrLoadKernelModule();
    void readStdOutRetrieveOpenvpnCiphers();
    void readStdErrRetrieveOpenvpnCiphers();
    void readStdOutRetrieveIpsecAlgos();
    void readStdErrRetrieveIpsecAlgos();
    void readStdOutRetrieveOpenvpnDigests();
    void readStdErrRetrieveOpenvpnDigests();
    void readStdOutGetNameAndPidOfProgramListen();
    void readStdErrGetNameAndPidOfProgramListen();
    void readOutGetEmailAddressOfCert();
    void readOutGetSmartcardSlots();
    void readOutGetSmartcardCertsFromSlot();
    void readOutNeedsPassphrase();
    void readOutGetCertsFromCiscoCertStoreSlot();
    void readPppdtestProcessOutput();
    void readStdOutGetHostname();
    void readStdErrGetHostname();

private:
    bool modprobeSuccess;
    bool toolsTestSuccess;
    bool retrieveOpenvpnCiphers;
    bool retrieveOpenvpnDigests;
    bool retrieveIpsecAlgos;
    bool retrieveNameAndPidOfProgramListen;
    bool retrieveHotsname;
    bool needsPassphrase;
    bool testPppdReplacedefaultroute;
    bool testPppdRequireMppe128;
    bool testPppdMppeRequiredSupport;
    bool testPppdNomppeStatefulSupport;
    bool testPppdStatelessSupport;
    bool testOldPppdStyle;
    bool testPppdRequireMppe;
    bool testPppdMppeRequired;

    QString tooltest_logfile;
    QProcess *ModprobeProcess;
    QProcess *createProcess;
    QProcess *NetworkDeviceTestProcess;
    QProcess *toolsTestProcess;
    QProcess *OpenvpnCiphersProcess;
    QProcess *OpenvpnDigestProcess;
    QProcess *NameAndPidOfProgramListenProcess;
    QProcess *GetEmailAddressOfCertProcess;
    QProcess *GetSmartcardSlotsProcess;
    QProcess *GetSmartcardCertsFromSlotProcess;
    QProcess *GetCertsFromCiscoCertStoreProcess;
    QProcess *NeedsPassphraseProcess;
    QProcess *IpsecAlgosProcess;
    QProcess *TestPppdProcess;
    QProcess *GetHostnameProcess;

    QString resolvedIP;
    bool resolveFinished;
    QList<QHostAddress> list;
    QStringList *env;
    KVpncConfig *GlobalConfig;
    KTemporaryFile *tmpfile;
    bool retrieveValidNetworkdevice;
    bool Pkcs11CertFound;
    QStringList OpenvpnCiphers;
    QStringList OpenvpnDigests;
    QStringList KernelCrypto;
    QString NameAndPidOfProgramListen;
    QString EmailAddressOfCert;
    QString OpenvpnDigestString;
    QString IdType;
    QString Hostname;
    QStringList SmartcardSlots;
    QStringList SmartcardCertsFromSlot;
    QStringList CertsFromCiscoCertStore;

    int CertsFromCiscoCertPos;
    int ListenPort;
    int OpenvpnDigestCount;
    PppdCapabilities pppdcap;
};

#endif
