package tests::UIScalarListWidgetTest;

use strict;

use base qw/ tests::UIListWidgetTest /;

sub test_new {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'widget',
                                         'Lire::UI::ScalarListWidget',
                                         'value' => $self->{'list_value'} );
    $self->assert_isa( 'Lire::UI::ScalarListWidget', $widget );

    my $values_list = $widget->getobj( 'list' );
    $self->assert_isa( 'Curses::UI::Listbox', $values_list );
    $self->assert_isa( 'CODE', $values_list->{'-onchange'} );

    $self->assert_num_equals( 3, scalar @{$values_list->{'-values'}} );
    $self->assert_str_equals( 'string1', $values_list->{'-labels'}{ $self->{'list_value'}->get(0)} );

    my $value_widget = $widget->getobj( 'value_widget' );
    $self->assert_isa( 'Lire::UI::Widget', $value_widget );
    $self->assert_str_equals( 'string1', $value_widget->{'value'}->get() );

    my $buttons = $widget->getobj( 'buttons' );
    $self->assert_isa( 'Curses::UI::Buttonbox', $buttons );
    $self->assert_str_equals( '[Apply]', $buttons->{'-buttons'}[1]{'-label'} );
    $self->assert_isa( 'CODE', $buttons->{'-buttons'}[1]{'-onpress'} );
}

sub test_new_value {
    my $self = $_[0];

    my $widget =
      $self->{'window'}->add( 'list_widget', 'Lire::UI::ScalarListWidget',
                              'value' => $self->{'list_value'} );

    my $value_widget = $widget->getobj( 'value_widget' );
    $value_widget->{'value'}->set( 'A string' );

    my $value = $widget->new_value();
    $self->assert_isa( 'Lire::Config::Scalar', $value );
    $self->assert_str_equals( 'A string', $value->get() );
    $self->assert_str_equals( $value_widget->{'value'}->spec(),
                              $value->spec() );
    $self->assert_str_not_equals( $value_widget->{'value'}, $value );
}

sub test_apply_changes {
    my $self = $_[0];

    my $called = 'onvaluechanged not called';
    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $self->{'list_value'},
                                         'onvaluechanged' => sub { $called = 'called' } );

    my $values_list = $widget->getobj( 'list' );
    my $value_widget = $widget->getobj( 'value_widget' );
    $value_widget->{'value'}->set( 'New value' );
    $values_list->{'-selected'} = undef;
    $widget->do_routine( 'apply-changes' );
    $self->assert_str_equals( 'string1', $widget->{'value'}->get(0)->get() );
    $self->assert_str_equals( 'string2', $widget->{'value'}->get(1)->get() );
    $self->assert_str_equals( 'string3', $widget->{'value'}->get(2)->get() );
    $self->assert_str_equals( 'onvaluechanged not called', $called );

    $values_list->{'-selected'} = 1;
    $widget->do_routine( 'apply-changes' );
    my $value = $widget->{'value'}->get(1);
    $self->assert_str_equals( 'New value', $value->get() );
    $self->assert_str_equals( 'New value', $values_list->{'-labels'}{$value} );
    $self->assert_str_equals( 'called', $called );
}

sub test_value_change_cb {
    my $self = $_[0];

    my $widget = $self->{'window'}->add( 'list_widget', 'Lire::UI::ListWidget',
                                         'value' => $self->{'list_value'} );
    my $values_list = $widget->getobj( 'list' );
    my $value_widget = $widget->getobj( 'value_widget' );
    my $value = $value_widget->{'value'};
    $values_list->{'-selected'} = 1;
    $values_list->run_event( '-onchange' );
    $self->assert_str_equals( 'string2', $value_widget->{'value'}->get() );
    $self->assert_str_equals( 'string2', $value_widget->text() );

    $values_list->{'-selected'} = 0;
    $values_list->run_event( '-onchange' );
    $self->assert_str_equals( 'string1', $value_widget->text() );
    $self->assert_str_equals( 'string1', $value_widget->{'value'}->get() );

    $values_list->{'-selected'} = undef;
    $self->assert_dies( qr/\'-selected\' can never be undefined/,
                        sub { $values_list->run_event( '-onchange' ) } );
    $self->assert_str_equals( 'string1', $value_widget->text() );
    $self->assert_str_equals( 'string1', $value_widget->{'value'}->get() );
}

1;
