/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.http;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URLEncoder;

/**
 * This class is for unit testing HttpClient and HttpServer.
 *
 * @author Elias Ross
 * @version 1.0
 */
public class PerfTest
	extends junit.framework.TestCase
{
	public PerfTest(String name) {
		super(name);
	}

	public static class MyHttpServer extends ThreadedHttpServer {
		public MyHttpServer() throws IOException {
			super();
		}

		/**
		 * Writes a couple of lines.
		 */
		public void handleRequest(Request req)
			throws IOException
		{
			HttpServer s = req.getServer();
			s.readRequest();
			String result = "Have a happy day!\n\nTry try again!\n\n";
			MessageHeader mh; 
			mh = new MessageHeader(MessageHeader.FN_CONTENT_LENGTH, "" + result.length());
			s.writeResponse(new ServerResponse(StatusLine.HTTP11_200_OK, 
				new MessageHeader[] { mh, mh, mh }));
			Writer out = new OutputStreamWriter(s.getOutputStream());
			out.write(result);
			out.flush();
		}
	}

	@SuppressWarnings("deprecation")
	public void testUrlEncode()
		throws Exception
	{
		String k = "key";
		String v = "A note from me & \uabcd you.";
		String nv[] = new String[] { k, v };
		int times = 100;

		long start, end;

		for (int j = 0; j < 4; j++) {

		start = System.currentTimeMillis();
		for (int i = 0; i < times; i++) {
			@SuppressWarnings("unused")
			String str = URLEncoder.encode(k) + "." + URLEncoder.encode(v);
		} 
		end = System.currentTimeMillis();
		System.out.println("java.net.URLEncoder Took " + (end - start) + " MS");

		start = System.currentTimeMillis();
		for (int i = 0; i < times; i++) {
			HttpUtil.urlEncode(nv);
			// String str = new String(b);
		} 
		end = System.currentTimeMillis();
		System.out.println("HttpUtil Took " + (end - start) + " MS");

		}

	}

	/*
	public void testEasyGet()
		throws Exception
	{
		MyHttpServer server = new MyHttpServer();
		Socket s = new Socket("127.0.0.1", server.getPort());
		URL url = new URL("http://localhost/");
		EasyHttpClientFactory factory = new EasyHttpClientFactory2(s);
		EasyHttpClient ec = factory.makeGetClient(url);
		for (int j = 0; j < 5; j++) {
			long start = System.currentTimeMillis();
			for (int i = 0; i < 1000; i++) {
				BufferedReader br = ec.doGet();
				String str = HttpUtil.read(br);
				assertTrue("length", str.length() > 0); 
			} 
			long end = System.currentTimeMillis();
			System.out.println("Took " + (end - start) + " MS");
		}
	}
	*/

}
