/*
 * Definitions for libfsntfs
 *
 * Copyright (C) 2010-2019, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSNTFS_DEFINITIONS_H )
#define _LIBFSNTFS_DEFINITIONS_H

#include <libfsntfs/types.h>

#define LIBFSNTFS_VERSION					20190104

/* The version string
 */
#define LIBFSNTFS_VERSION_STRING				"20190104"

/* The file access
 * bit 1        set to 1 for read access
 * bit 2        set to 1 for write access
 * bit 3-8      not used
 */
enum LIBFSNTFS_ACCESS_FLAGS
{
	LIBFSNTFS_ACCESS_FLAG_READ				= 0x01,
/* Reserved: not supported yet */
	LIBFSNTFS_ACCESS_FLAG_WRITE				= 0x02
};

/* The file access macros
 */
#define LIBFSNTFS_OPEN_READ					( LIBFSNTFS_ACCESS_FLAG_READ )
/* Reserved: not supported yet */
#define LIBFSNTFS_OPEN_WRITE					( LIBFSNTFS_ACCESS_FLAG_WRITE )
/* Reserved: not supported yet */
#define LIBFSNTFS_OPEN_READ_WRITE				( LIBFSNTFS_ACCESS_FLAG_READ | LIBFSNTFS_ACCESS_FLAG_WRITE )

/* The path segment separator
 */
#define LIBFSNTFS_SEPARATOR					'\\'

/* The file attribute flags
 */
enum LIBFSNTFS_FILE_ATTRIBUTE_FLAGS
{
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_READ_ONLY			= 0x00000001UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_HIDDEN			= 0x00000002UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_SYSTEM			= 0x00000004UL,

	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_DIRECTORY			= 0x00000010UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_ARCHIVE			= 0x00000020UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_DEVICE			= 0x00000040UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_NORMAL			= 0x00000080UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_TEMPORARY			= 0x00000100UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_SPARSE_FILE		= 0x00000200UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_REPARSE_POINT		= 0x00000400UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_COMPRESSED		= 0x00000800UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_OFFLINE			= 0x00001000UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_NOT_CONTENT_INDEXED	= 0x00002000UL,
	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_ENCRYPTED			= 0x00004000UL,

	LIBFSNTFS_FILE_ATTRIBUTE_FLAG_VIRTUAL			= 0x00010000UL
};

/* The attribute types
 */
enum LIBFSNTFS_ATTRIBUTE_TYPES
{
	LIBFSNTFS_ATTRIBUTE_TYPE_UNUSED				= 0x00000000UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_STANDARD_INFORMATION		= 0x00000010UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_ATTRIBUTE_LIST			= 0x00000020UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_FILE_NAME			= 0x00000030UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_OBJECT_IDENTIFIER		= 0x00000040UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_SECURITY_DESCRIPTOR		= 0x00000050UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_VOLUME_NAME			= 0x00000060UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_VOLUME_INFORMATION		= 0x00000070UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_DATA				= 0x00000080UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_INDEX_ROOT			= 0x00000090UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_INDEX_ALLOCATION		= 0x000000a0UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_BITMAP				= 0x000000b0UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_REPARSE_POINT			= 0x000000c0UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_EXTENDED_INFORMATION		= 0x000000d0UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_EXTENDED			= 0x000000e0UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_PROPERTY_SET			= 0x000000f0UL,
	LIBFSNTFS_ATTRIBUTE_TYPE_LOGGED_UTILITY_STREAM		= 0x00000100UL,

	LIBFSNTFS_ATTRIBUTE_TYPE_END_OF_ATTRIBUTES		= 0xffffffffUL
};

/* The extent flag definitions
 */
enum LIBFSNTFS_EXTENT_FLAGS
{
	/* The extent is sparse
	 */
        LIBFSNTFS_EXTENT_FLAG_IS_SPARSE				= 0x00000001UL,

	/* The extent is compressed
	 */
        LIBFSNTFS_EXTENT_FLAG_IS_COMPRESSED			= 0x00000002UL
};

#endif /* !defined( _LIBFSNTFS_DEFINITIONS_H ) */

