Name: libfwsi
Version: 20240423
Release: 1
Summary: Library to access the Windows Shell Item format
Group: System Environment/Libraries
License: LGPL-3.0-or-later
Source: %{name}-%{version}.tar.gz
URL: https://github.com/libyal/libfwsi
          
BuildRequires: gcc          

%description -n libfwsi
Library to access the Windows Shell Item format

%package -n libfwsi-static
Summary: Library to access the Windows Shell Item format
Group: Development/Libraries
Requires: libfwsi = %{version}-%{release}

%description -n libfwsi-static
Static library version of libfwsi.

%package -n libfwsi-devel
Summary: Header files and libraries for developing applications for libfwsi
Group: Development/Libraries
Requires: libfwsi = %{version}-%{release}

%description -n libfwsi-devel
Header files and libraries for developing applications for libfwsi.

%package -n libfwsi-python3
Summary: Python 3 bindings for libfwsi
Group: System Environment/Libraries
Requires: libfwsi = %{version}-%{release} python3
BuildRequires: python3-devel python3-setuptools

%description -n libfwsi-python3
Python 3 bindings for libfwsi

%prep
%setup -q

%build
%configure --prefix=/usr --libdir=%{_libdir} --mandir=%{_mandir} --enable-python
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%make_install

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files -n libfwsi
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so.*

%files -n libfwsi-static
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.a

%files -n libfwsi-devel
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/*.so
%{_libdir}/pkgconfig/libfwsi.pc
%{_includedir}/*
%{_mandir}/man3/*

%files -n libfwsi-python3
%license COPYING COPYING.LESSER
%doc AUTHORS README
%{_libdir}/python3*/site-packages/*.a
%{_libdir}/python3*/site-packages/*.so

%changelog
* Tue Apr 23 2024 Joachim Metz <joachim.metz@gmail.com> 20240423-1
- Auto-generated

