// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CONFIG_H
#define _LIBGDAMM_CONFIG_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

// -*- C++ -*- //

/* config.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/object.h>
#include <libgdamm/serverprovider.h>
#include <libgdamm/datamodel.h>
#include <libgda/gda-config.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaConfig GdaConfig;
typedef struct _GdaConfigClass GdaConfigClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Config_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class ConfigError : public Glib::Error
{
public:
  enum Code
  {
    CONFIG_DSN_NOT_FOUND_ERROR,
    CONFIG_PERMISSION_ERROR,
    CONFIG_PROVIDER_NOT_FOUND_ERROR,
    CONFIG_PROVIDER_CREATION_ERROR
  };

  ConfigError(Code error_code, const Glib::ustring& error_message);
  explicit ConfigError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

  static void throw_func(GError* gobject);

  friend void wrap_init(); // uses throw_func()

  #endif //DOXYGEN_SHOULD_SKIP_THIS
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConfigError::Code> : public Glib::Value_Enum<Gnome::Gda::ConfigError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Configuration — Access/Management of libgda configuration.
 *
 * @ingroup Configuration
 */

class Config : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Config CppObjectType;
  typedef Config_Class CppClassType;
  typedef GdaConfig BaseObjectType;
  typedef GdaConfigClass BaseClassType;

private:  friend class Config_Class;
  static CppClassType config_class_;

private:
  // noncopyable
  Config(const Config&);
  Config& operator=(const Config&);

protected:
  explicit Config(const Glib::ConstructParams& construct_params);
  explicit Config(GdaConfig* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Config();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaConfig*       gobj()       { return reinterpret_cast<GdaConfig*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaConfig* gobj() const { return reinterpret_cast<GdaConfig*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaConfig* gobj_copy();

private:

protected:
  Config();
public:
  
  /** Get a pointer to the global GdaConfig object
   * @return A non <tt>0</tt> pointer to a Gda::Config.
   */
  static Glib::RefPtr<Config> get();

  
  /** Get information about the DSN named @a dsn_name. 
   * 
   *  @a dsn_name's format is "[<username>[:<password>]@]<DSN>" (if <username>
   * and optionally <password> are provided, they are ignored). Also see the gda_dsn_split() utility
   * function.
   * @param dsn_name The name of the DSN to look for.
   * @return A pointer to read-only Gda::DsnInfo structure, or <tt>0</tt> if not found.
   */
  static GdaDsnInfo* get_dsn_info(const Glib::ustring& dsn_name);
  
  /** Tells if the data source identified as @a dsn_name needs any authentication. If a <username>
   * and optionally a <password> are specified, they are ignored.
   * @param dsn_name The name of a DSN, in the "[<username>[:<password>]@]<DSN>" format.
   * @return <tt>true</tt> if an authentication is needed.
   */
  static bool dsn_needs_authentication(const Glib::ustring& dsn_name);

  
  /** Get a Gda::DataModel representing all the configured DSN, and keeping itself up to date with
   * the changes in the declared DSN.
   * 
   * The returned data model is composed of the following columns:
   * <itemizedlist>
   * <listitem>DSN name</listitem>
   * <listitem>Provider name</listitem>
   * <listitem>Description</listitem>
   * <listitem>Connection string</listitem>
   * <listitem>Username if it exists</listitem>
   * </itemizedlist>
   * @return A new Gda::DataModel.
   */
  static Glib::RefPtr<DataModel> list_dsn();

  
  /** Get a pointer to the session-wide Gda::ServerProvider for the
   * provider named @a provider_name. The caller must not call Glib::object_unref() on the
   * returned object.
   * 
   * This method may fail with a Gda::CONFIG_ERROR domain error (see the Gda::ConfigError error codes).
   * @param provider_name A database provider.
   * @return A pointer to the Gda::ServerProvider, or <tt>0</tt> if an error occurred.
   */
  static Glib::RefPtr<ServerProvider> get_provider(const Glib::ustring& provider_name);

  
  /** Get a Gda::DataModel representing all the installed database providers.
   * 
   * The returned data model is composed of the following columns:
   * <itemizedlist>
   * <listitem>Provider name</listitem>
   * <listitem>Description</listitem>
   * <listitem>DSN parameters</listitem>
   * <listitem>Authentication parameters</listitem>
   * <listitem>File name of the plugin</listitem>
   * </itemizedlist>
   * @return A new Gda::DataModel.
   */
  static Glib::RefPtr<DataModel> list_providers();

  
  /** Get the number of defined DSN
   * @return The number of defined DSN.
   */
  static int get_nb_dsn();

  
  /** Tells if the global (system) configuration can be modified (considering
   * system permissions and settings)
   * @return <tt>true</tt> if system-wide configuration can be modified.
   */
  static bool can_modify_system_config();

   
  /**
   * @par Prototype:
   * <tt>void on_my_%dsn_added(GdaDsnInfo* info)</tt>
   */

  Glib::SignalProxy1< void,GdaDsnInfo* > signal_dsn_added();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%dsn_changed(GdaDsnInfo* info)</tt>
   */

  Glib::SignalProxy1< void,GdaDsnInfo* > signal_dsn_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%dsn_removed(GdaDsnInfo* info)</tt>
   */

  Glib::SignalProxy1< void,GdaDsnInfo* > signal_dsn_removed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%dsn_to_be_removed(GdaDsnInfo* info)</tt>
   */

  Glib::SignalProxy1< void,GdaDsnInfo* > signal_dsn_to_be_removed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** File to use for system-wide DSN list.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_system_filename() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** File to use for system-wide DSN list.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_system_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** File to use for per-user DSN list.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_user_filename() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** File to use for per-user DSN list.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_user_filename() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Config
   */
  Glib::RefPtr<Gnome::Gda::Config> wrap(GdaConfig* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CONFIG_H */

