--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for totalBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((totalBetti(3,1,0))#(1,1) == 3)
///

TEST ///
    assert ((totalBetti(5,2,0))#(13,2) == 2002)
///

TEST ///
    assert ((totalBetti(4,2,2))#(5,0) == 252)
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for totalBettiTally.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((totalBettiTally(3,1,0))#(1,{2},2) == 3)
///

TEST ///
    assert ((totalBettiTally(5,2,0))#(13,{15},15) == 2002)
///

TEST ///
    assert ((totalBettiTally(4,2,2))#(5,{5},5) == 252)
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for makeBettiTally.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((totalBettiTally(3,1,0)) == makeBettiTally (totalBetti(3,1,0)))
///

TEST ///
    assert ((totalBettiTally(5,2,0)) == makeBettiTally (totalBetti(5,2,0)))
///

TEST ///
    assert ((totalBettiTally(4,2,2)) == makeBettiTally (totalBetti(4,2,2)))
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for multiBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    f = (multiBetti(3,1,0))#(1,1);
    R = ring f
    t_0=R_0
    t_1=R_1
--    t_2=R_2
    g = t_0^4*t_1^2+t_0^3*t_1^3+t_0^2*t_1^4;
    assert (f == g)
///

TEST ///
    f = (multiBetti(3,2,2))#(7,1);
    R = ring f
    t_0=R_0
    t_1=R_1
    t_2=R_2
    g = t_0^9*t_1^9*t_2^8+t_0^9*t_1^8*t_2^9+t_0^8*t_1^9*t_2^9;
    assert (f == g)
///

TEST ///
    f = (multiBetti(3,2,0))#(1,1);
    R = ring f
    t_0=R_0
    t_1=R_1
    t_2=R_2
    g = t_0^4*t_1^2+t_0^3*t_1^3+t_0^2*t_1^4+t_0^4*t_1*t_2+2*t_0^3*t_1^2*t_2+
        2*t_0^2*t_1^3*t_2+t_0*t_1^4*t_2+t_0^4*t_2^2+2*t_0^3*t_1*t_2^2+
	3*t_0^2*t_1^2*t_2^2+2*t_0*t_1^3*t_2^2+t_1^4*t_2^2+t_0^3*t_2^3+
	2*t_0^2*t_1*t_2^3+2*t_0*t_1^2*t_2^3+t_1^3*t_2^3+t_0^2*t_2^4+
	t_0*t_1*t_2^4+t_1^2*t_2^4;
    assert (f == g)
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for schurBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((schurBetti(3,1,0))#(1,1) == {({4,2}, 1)})
///

TEST ///
    L =  {({30, 30, 15}, 1), ({30, 28, 17}, 1), ({30, 27, 18}, 1), ({30, 26, 19}, 1), 
	  ({29, 26, 20}, 1), ({29, 24, 22}, 1), ({28, 28, 19}, 1), ({28, 27, 20}, 1), 
	  ({28, 26, 21}, 2), ({28, 25, 22}, 1), ({28, 24, 23}, 1), ({27, 26, 22}, 1), 
	  ({27, 24, 24}, 1), ({26, 26, 23}, 1), ({30, 24, 21}, 1), ({30, 25, 20}, 1)};
    assert ((schurBetti(5,2,0))#(13,2) == L)
///

TEST ///
    L = {({14, 4, 4}, 1), ({12, 6, 4}, 1), ({10, 8, 4}, 1), 
	 ({10, 6, 6}, 1), ({8, 8, 6}, 1)};
    assert ((schurBetti(4,2,2))#(5,0) == L)
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for numDistinctRepsBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((numDistinctRepsBetti(3,1,0))#(1,1) == 1)
///

TEST ///
    assert ((numDistinctRepsBetti(5,2,0))#(13,2) == 16)
///

TEST ///
    assert ((numDistinctRepsBetti(4,2,2))#(5,0) == 5)
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for numRepsBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((numRepsBetti(3,1,0))#(1,1) == 1)
///

TEST ///
    assert ((numRepsBetti(5,2,0))#(13,2) == 17)
///

TEST ///
    assert ((numRepsBetti(4,2,2))#(5,0) == 5)
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for dominantWeightsBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((dominantWeightsBetti(3,1,0))#(1,1) == {{4,2}})
///

TEST ///
    assert ((dominantWeightsBetti(5,2,0))#(13,2) == {{30,30,15}})
///

TEST ///
    assert ((dominantWeightsBetti(4,2,2))#(5,0) == {{14,4,4}})
///

TEST ///
    assert ((dominantWeightsBetti(4,2,0))#(2,1) == {{9, 2, 1}, {8, 4, 0}})
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for lexWeightsBetti.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((lexWeightsBetti(3,1,0))#(1,1) == {4,2})
///

TEST ///
    assert ((lexWeightsBetti(5,2,0))#(13,2) == {30,30,15})
///

TEST ///
    assert ((lexWeightsBetti(4,2,2))#(5,0) == {14,4,4})
///


--------------------------------------------------------------------
--------------------------------------------------------------------
----- Tests for bsCoeffs.
--------------------------------------------------------------------
--------------------------------------------------------------------
TEST ///
    assert ((bsCoeffs(3,1,0)) == {6})
///

TEST ///
    assert ((bsCoeffs(5,2,3))#0 == 2636271525888000)
///
