﻿package com.anttikupila.soundSpectrum {
	import flash.media.Sound;
	import flash.media.SoundMixer;
	import flash.utils.ByteArray;
	
	public class SoundProcessor extends Sound {
		public const LEFT:String = "left";
		public const RIGHT:String = "right";
		public const BOTH:String = "both";
		private var ba:ByteArray = new ByteArray();
		
		function SoundProcessor() {
		}
		
		private function getSection(bArr:ByteArray, sectionLength:uint = 512):Array {
			var soundArray:Array = new Array();
			for (var i:uint = 0; i < sectionLength; i++) {
				soundArray.push(bArr.readFloat());
			}
			return soundArray;
		}
		
		public function getLeftChannel(fourier:Boolean):Array {
            try {
                computeSpectrum(fourier);
            } catch (e:Error) {
                return [];
            }
			return getSection(ba, 256);
        }

        private function computeSpectrum(fourier:Boolean):void {
            SoundMixer.computeSpectrum(ba, fourier, 0);
        }
		
        public function getRightChannel(fourier:Boolean):Array {
            try {
                computeSpectrum(fourier);
            } catch (e:Error) {
                return [];
            }
			ba.position = 1024;
			return getSection(ba, 256);
		}
		
        public function getSoundSpectrum(fourier:Boolean):Array {
            try {
                computeSpectrum(fourier);
            } catch (e:Error) {
                return [];
            }
            return getSection(ba, 512);
        }
		
        public function getVolume(channel:String = BOTH):Number {
            try {
                computeSpectrum(false);
            } catch (e:Error) {
                return 0;
            }
			var soundArray:Array = new Array();
			switch (channel) {
				case LEFT:
				soundArray = getLeftChannel(true);
				break;
				case RIGHT:
				soundArray = getRightChannel(true);
				break;
				case BOTH:
				default:
				soundArray = getSoundSpectrum(true);
				break;
			}
			var vol:Number = 0;
			for (var i:* in soundArray) {
				vol += soundArray[i];
			}
			vol /= i;
			return vol*100;
		}
	}
}