#include <sys/stat.h>
#include <unistd.h>

#include "lib/util.h"
#include "open_file.h"

open_file::open_file(int fd)
{
	struct stat st;
	int r = fstat(fd, &st);
	die_if(r < 0, "fstat()");
	dev = st.st_dev;
	ino = st.st_ino;
}

open_file::open_file(const open_file& of)
	: dev(of.dev), ino(of.ino)
{
}

bool operator==(const open_file& x, const open_file& y)
{
	return (x.dev == y.dev) && (x.ino == y.ino);
}

bool operator<(const open_file& x, const open_file& y)
{
	if (x.dev != y.dev)
		return x.dev < y.dev;
	else
		return x.ino < y.ino;
}
