/* $Id: Gb_qual.hpp 171065 2009-09-21 15:44:55Z bollin $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 */

/// @Gb_qual.hpp
/// User-defined methods of the data storage class.
///
/// This file was originally generated by application DATATOOL
/// using the following specifications:
/// 'seqfeat.asn'.
///
/// New methods or data members can be added to it if needed.
/// See also: Gb_qual_.hpp


#ifndef OBJECTS_SEQFEAT_GB_QUAL_HPP
#define OBJECTS_SEQFEAT_GB_QUAL_HPP


// generated includes
#include <objects/seqfeat/Gb_qual_.hpp>

// generated classes

// other includes
#include <corelib/ncbistd.hpp>
#include <corelib/ncbistr.hpp>
#include <serial/iterator.hpp>

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

/////////////////////////////////////////////////////////////////////////////
class NCBI_SEQFEAT_EXPORT CGb_qual : public CGb_qual_Base
{
    typedef CGb_qual_Base Tparent;
public:
    // constructors
    CGb_qual(void);
    CGb_qual(const TQual& qual, const TVal& val);

    // destructor
    ~CGb_qual(void);
    
    int Compare(const CGb_qual& gbqual) const;

private:
    // Prohibit copy constructor and assignment operator
    CGb_qual(const CGb_qual& value);
    CGb_qual& operator=(const CGb_qual& value);

};

/////////////////// CGb_qual inline methods

// constructor
inline
CGb_qual::CGb_qual(void)
{
}

inline
CGb_qual::CGb_qual(const TQual& qual, const TVal& val)
{
    SetQual(qual);
    SetVal(val);
}


inline
int CGb_qual::Compare(const CGb_qual& gbqual) const
{
    if (GetQual() != gbqual.GetQual()) {
        return (GetQual() < gbqual.GetQual() ? -1 : 1);
    }
    if (GetVal() != gbqual.GetVal()) {
        return (GetVal() < gbqual.GetVal() ? -1 : 1);
    }
    return 0;
}


/////////////////// end of CGb_qual inline methods

/////////// inference prefix list
class NCBI_SEQFEAT_EXPORT CInferencePrefixList
{
public:
    // constructors
    CInferencePrefixList(void);

    // destructor
    ~CInferencePrefixList(void);
    
    static void GetPrefixAndRemainder (const string& inference, string& prefix, string& remainder);
    
private:
};



END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_SEQFEAT_GB_QUAL_HPP
/* Original file checksum: lines: 94, chars: 2540, CRC32: e99dce88 */
