/* $Id: Seq_inst.cpp 519218 2016-11-14 16:06:51Z ivanov $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'seq.asn'.
 */

// standard includes

// generated includes
#include <ncbi_pch.hpp>
#include <objects/seq/Seq_inst.hpp>

// generated classes

BEGIN_NCBI_SCOPE

BEGIN_objects_SCOPE // namespace ncbi::objects::

// destructor
CSeq_inst::~CSeq_inst(void)
{
}


typedef SStaticPair<CSeq_inst::EMol, const char*> TMolKey;

static const TMolKey mol_key_to_str[] = {
    { CSeq_inst::eMol_not_set, " " } ,
    { CSeq_inst::eMol_dna,     "DNA" } ,
    { CSeq_inst::eMol_rna,     "RNA" } ,
    { CSeq_inst::eMol_aa,      "protein" } ,
    { CSeq_inst::eMol_na,      "nucleotide" } ,
    { CSeq_inst::eMol_other,   "other" }
};


// dump the array into a map for faster searching
typedef CStaticPairArrayMap <CSeq_inst::EMol, const char*> TMolMap;
DEFINE_STATIC_ARRAY_MAP(TMolMap, sm_EMolKeys, mol_key_to_str);


string CSeq_inst::GetMoleculeClass(CSeq_inst::EMol mol)
{
    TMolMap::const_iterator g_iter = sm_EMolKeys.find(mol);
    if (g_iter != sm_EMolKeys.end()) {
        return g_iter->second;
    }
    return kEmptyStr;
}


#define CONVERT_NA_CODING_TO_STR(encoding) \
    case CSeq_data::e_##encoding: \
        CSeqConvert::Convert(seq_data.Get##encoding().Get(), CSeqUtil::e_##encoding, 0, length, str, CSeqUtil::e_Iupacna); \
        break;

#define CONVERT_AA_CODING_TO_STR(encoding) \
    case CSeq_data::e_##encoding: \
        CSeqConvert::Convert(seq_data.Get##encoding().Get(), CSeqUtil::e_##encoding, 0, length, str, CSeqUtil::e_Iupacaa); \
        break;


bool CSeq_inst::ConvertDeltaToRaw()
{
    if (!IsSetRepr() || GetRepr() != objects::CSeq_inst::eRepr_delta ||
        !IsSetExt() || !GetExt().IsDelta() || !IsSetMol())
    {
        return false;
    }

    // can only be done if there are no seq-loc objects
    ITERATE(CSeq_ext::TDelta::Tdata, it, GetExt().GetDelta().Get())
    {
        if ((*it)->IsLoc()) {
            return false;
        }
    }

    size_t orig_len = GetLength();
    string iupacna;
    NON_CONST_ITERATE(objects::CSeq_ext::TDelta::Tdata, it, SetExt().SetDelta().Set())
    {
        if ((*it)->IsLiteral())
        {
            const CSeq_literal& seq_literal = (*it)->GetLiteral();
            TSeqPos length = seq_literal.GetLength();
            if ((*it)->GetLiteral().IsSetSeq_data())
            {
                const CSeq_data& seq_data = seq_literal.GetSeq_data();
                string str;
                switch (seq_data.Which())
                {
                case CSeq_data::e_Iupacna:
                    str = seq_data.GetIupacna();
                    break;
                CONVERT_NA_CODING_TO_STR(Ncbi2na)
                CONVERT_NA_CODING_TO_STR(Ncbi4na)
                CONVERT_NA_CODING_TO_STR(Ncbi8na)
                case objects::CSeq_data::e_Iupacaa:
                    str = seq_data.GetIupacaa();
                    break;
                CONVERT_AA_CODING_TO_STR(Ncbi8aa);
                CONVERT_AA_CODING_TO_STR(Ncbieaa);
                CONVERT_AA_CODING_TO_STR(Ncbistdaa);
                default:
                    break;
                }
                iupacna += str;
            }

            if (!seq_literal.IsSetSeq_data() || seq_literal.GetSeq_data().IsGap())
            {                
                if (IsAa()) {
                    iupacna += string(length, 'X');
                } else {
                    iupacna += string(length, 'N');
                }
            }
        }
    }

    if (orig_len != iupacna.length()) {
        SetLength(iupacna.length());
    }
    SetRepr(objects::CSeq_inst::eRepr_raw);
    if (IsAa()) {
        SetSeq_data().SetIupacaa() = objects::CIUPACaa(iupacna);
    } else {
        SetSeq_data().SetIupacna() = objects::CIUPACna(iupacna);
    }
    ResetExt();
    return true;
}


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

/* Original file checksum: lines: 64, chars: 1872, CRC32: f553d25a */
