#version 430

layout(location = 0) uniform mat4 matrix;
layout(location = 1) uniform mat4 modelview;
layout(location = 3) uniform mat4 projection;

layout(location = 0) in vec4 position;
layout(location = 1) in vec2 v2UVcoordsIn;

out vec2 v2UVcoords;
out vec4 posout;
out vec4 pos_xformed;
out vec4 relpos;

void main()
{
	vec4 lpos = position;
	posout = lpos;
	v2UVcoords = v2UVcoordsIn;
	relpos = modelview * vec4( lpos.xyz, 1.0 );
	gl_Position = pos_xformed = projection * relpos;
}
