/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */
package org.apache.openjpa.persistence.xs;

import java.io.Serializable;

/**
 *
 * Auto-generated by:
 * org.apache.openjpa.enhance.ApplicationIdTool
 */
public class AccountingHierarchyRateOpenJPAKey implements Serializable {
	/**
	 * 
	 */
	private static final long serialVersionUID = -2345673847908844341L;

	static {
		// register persistent class in JVM
		try { Class.forName("org.apache.openjpa.persistence.xs.AccountingHierarchyRate"); }
		catch(Exception e) {}
	}

	public String accountingHierarchy;
	public String id;

	public AccountingHierarchyRateOpenJPAKey() {
	}

	public AccountingHierarchyRateOpenJPAKey(String str) {
		fromString(str);
	}

	public String getAccountingHierarchy() {
		return accountingHierarchy;
	}

	public void setAccountingHierarchy(String accountingHierarchy) {
		this.accountingHierarchy = accountingHierarchy;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String toString() {
		return accountingHierarchy
			+ "::" + id;
	}

	public int hashCode() {
		int rs = 17;
		rs = rs * 37 + ((accountingHierarchy == null) ? 0 : accountingHierarchy.hashCode());
		rs = rs * 37 + ((id == null) ? 0 : id.hashCode());
		return rs;
	}

	public boolean equals(Object obj) {
		if(this == obj)
			return true;
		if(obj == null || obj.getClass() != getClass())
			return false;

		AccountingHierarchyRateOpenJPAKey other = (AccountingHierarchyRateOpenJPAKey) obj;
		return ((accountingHierarchy == null && other.accountingHierarchy == null)
			|| (accountingHierarchy != null && accountingHierarchy.equals(other.accountingHierarchy)))
			&& ((id == null && other.id == null)
			|| (id != null && id.equals(other.id)));
	}

	private void fromString(String str) {
		Tokenizer toke = new Tokenizer(str);
		str = toke.nextToken();
		if("null".equals(str))
			accountingHierarchy = null;
		else
			accountingHierarchy = str;
		str = toke.nextToken();
		if("null".equals(str))
			id = null;
		else
			id = str;
	}

	protected static class Tokenizer {
		private final String str;
		private int last;

		public Tokenizer (String str) {
			this.str = str;
		}

		public String nextToken () {
			int next = str.indexOf("::", last);
			String part;
			if(next == -1) {
				part = str.substring(last);
				last = str.length();
			} else {
				part = str.substring(last, next);
				last = next + 2;
			}
			return part;
		}
	}
}
