###############################################################################
# OpenVAS Vulnerability Test
# $Id: asterisk_37153.nasl 7196 2010-04-01 09:17:33Z chandra $
#
# Asterisk RTP Comfort Noise Processing Remote Denial of Service Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100366);
 script_bugtraq_id(37153);
 script_cve_id("CVE-2009-4055");
 script_version ("1.0-$Revision: 7196 $");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");

 script_name("Asterisk RTP Comfort Noise Processing Remote Denial of Service Vulnerability");

desc = "Overview:
Asterisk is prone to a remote denial-of-service vulnerability because
it fails to properly handle malformed RTP comfort noise data.

Successful exploits can crash the application, resulting in denial-of-
service conditions for legitimate users.

Solution:
Updates are available. Please see the references for details.

References:
http://www.securityfocus.com/bid/37153
http://www.asterisk.org/
http://downloads.asterisk.org/pub/security/AST-2009-010.html

Risk factor : Medium";

 script_description(desc);
 script_summary("Determine the Asterisk version");
 script_category(ACT_GATHER_INFO);
 script_family("General");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("secpod_asterisk_detect.nasl");
 script_require_keys("Services/udp/sip");
 exit(0);
}

include("version_func.inc");

asterisk_port = get_kb_item("Services/udp/sip");
if(!asterisk_port)exit(0);
if(!get_udp_port_state(asterisk_port))exit(0);

asteriskVer = get_kb_item("Asterisk-PBX/Ver");
if(!asteriskVer){
      exit(0);
}

if(version_in_range(version:asteriskVer, test_version:"1.6.1", test_version2:"1.6.1.10")  ||
   version_in_range(version:asteriskVer, test_version:"1.4.27", test_version2:"1.4.27.0") ||
   version_in_range(version:asteriskVer, test_version:"1.2", test_version2:"1.2.36")) {
      security_warning(port:asterisk_port, proto:"udp");
}   

exit(0);
