# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1330-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(58451);
 script_cve_id("CVE-2007-1399", "CVE-2007-1864");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "Debian Security Advisory DSA 1330-1 (php5)";
 script_name(name);

 desc = "The remote host is missing an update to php5
announced via advisory DSA 1330-1.

Several remote vulnerabilities have been discovered in PHP, a
server-side, HTML-embedded scripting language, which may lead to the
execution of arbitrary code. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2007-1399
Stefan Esser discovered that a buffer overflow in the zip extension
allows the execution of arbitrary code.

CVE-2007-1864
It was discovered that a buffer overflow in the xmlrpc extension
allows the execution of arbitrary code.

The oldstable distribution (sarge) doesn't include php5.

For the stable distribution (etch) these problems have been fixed
in version 5.2.0-8+etch7.

For the unstable distribution (sid) these problems have been fixed in
version 5.2.2-1.

We recommend that you upgrade your PHP packages. Packages for the little-

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201330-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1330-1 (php5)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"php-pear", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache-mod-php5", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libapache2-mod-php5", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cgi", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-cli", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-common", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-curl", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-dev", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-gd", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-imap", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-ldap", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mcrypt", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mhash", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-mysql", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-odbc", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pgsql", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-pspell", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-recode", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-snmp", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sqlite", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-sybase", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-tidy", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xmlrpc", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-xsl", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"php5-interbase", ver:"5.2.0-8+etch7", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
