###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for kdelibs, qt-x11-free vulnerability USN-452-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840141);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "USN", value: "452-1");
  script_cve_id("CVE-2007-0242");
  script_name( "Ubuntu Update for kdelibs, qt-x11-free vulnerability USN-452-1");
  desc = "

  Vulnerability Insight:

  The Qt library did not correctly handle truncated UTF8 strings, which
  could cause some applications to incorrectly filter malicious strings.
  If a Konqueror user were tricked into visiting a web site containing
  specially crafted strings, normal XSS prevention could be bypassed
  allowing a remote attacker to steal confidential data.

  Affected Software/OS:
  kdelibs, qt-x11-free vulnerability on Ubuntu 5.10 ,
  Ubuntu 6.06 LTS ,
  Ubuntu 6.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2007-April/000520.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of kdelibs, qt-x11-free vulnerability");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"kdelibs-bin", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt-x11-free-dbg", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.2-0ubuntu18.4", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.6-1ubuntu6.2", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.5-0ubuntu3.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.5-0ubuntu3.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.5-0ubuntu3.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt-x11-free-dbg", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.5-0ubuntu3.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.5-0ubuntu3.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.5-0ubuntu3.4", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.6-3ubuntu3.1", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU5.10")
{

  if(isdpkgvuln(pkg:"kdelibs-bin", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2-dbg", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4c2", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-compat-headers", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-headers", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dbg", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-dev", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-ibase", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-mysql", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-odbc", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-psql", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt-sqlite", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-mt", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-apps-dev", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-assistant", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-designer", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-compat", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools-embedded", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-dev-tools", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-linguist", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-qtconfig", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"kdelibs", ver:"3.4.3-0ubuntu2.4", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libqt3-i18n", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-doc", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"qt3-examples", ver:"3.3.4-8ubuntu5.2", rls:"UBUNTU5.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}