###############################################################################
# OpenVAS Vulnerability Test
# $Id: nginx_detect.nasl 7516 2010-05-04 08:24:56Z chandra $
#
# nginx Detection
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

# need desc here to modify it later in script.
desc = "Overview:
This host is running nginx. nginx [engine x] is a HTTP server and mail
proxy server written by Igor Sysoev. 

See also:
http://nginx.net/

Risk factor : None";

if (description)
{
 script_id(100274);
 script_version ("1.0-$Revision: 7516 $");
 script_tag(name:"risk_factor", value:"None");
 script_name("nginx Detection");
 script_description(desc);
 script_summary("Checks for the presence of nginx");
 script_category(ACT_GATHER_INFO);
 script_family("Service detection");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("find_service.nes", "http_version.nasl");
 script_require_ports("Services/www", 80);
 exit(0);
}

include("http_func.inc");
include("global_settings.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

 buf = get_http_banner(port: port);
 if(!buf)exit(0);

 if(egrep(pattern:"Server: nginx/" , string: buf, icase: TRUE))
 {
    vers = string("unknown");
    ### try to get version 
    version = eregmatch(string: buf, pattern: "Server: nginx/([0-9.]+)",icase:TRUE);

    if ( !isnull(version[1]) ) {
       vers=chomp(version[1]);
    }

    set_kb_item(name: string("nginx/", port, "/version"), value: string(vers));

    info = string("None\n\nnginx Version '");
    info += string(vers);
    info += string("' was detected on the remote host.");

    desc = ereg_replace(
        string:desc,
        pattern:"None$",
        replace:info
    );

       if(report_verbosity > 0) {
         security_note(port:port,data:desc);
       }
       exit(0);

 }

exit(0);

