# ----------------------------------------------------------------------------
# Copyright (c) 2016-2021, QIIME 2 development team.
#
# Distributed under the terms of the Modified BSD License.
#
# The full license is in the file LICENSE, distributed with this software.
# ----------------------------------------------------------------------------

from setuptools import setup, find_packages
import versioneer

setup(
    name="q2-phylogeny",
    version=versioneer.get_version(),
    cmdclass=versioneer.get_cmdclass(),
    packages=find_packages(),
    author="Greg Caporaso and Michael Robeson",
    author_email="gregcaporaso@gmail.com",
    description="Create and work with Phylogenetic trees in QIIME 2.",
    license="BSD-3-Clause",
    url="https://qiime2.org",
    entry_points={
        'qiime2.plugins': ['q2-phylogeny=q2_phylogeny.plugin_setup:plugin']
    },
    package_data={
        'q2_phylogeny': ['citations.bib'],
        'q2_phylogeny.tests': ['data/*']
    },
    zip_safe=False,
)
