//
// C++ Implementation: qcwavesystem
//
// Description: 
//
//
// Author: Harald Krippel <harald@the-develop.net>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "qcwavesystem.hpp"
#include "main.h"

qcWaveSystem::qcWaveSystem(QObject *parent, int ntri)
: QObject(parent), ssgaWaveSystem ( ntri )
{

}

qcWaveSystem::~qcWaveSystem()
{

}

void qcWaveSystem::slot_update( float dt )
{
      static float t;
      t+= dt;
      ssgaWaveSystem::setWindDirn ( 25.0 * sin ( t / 100.0 ) ) ;
      ssgaWaveSystem::updateAnimation ( t ) ;
}

ssgSimpleState* qcWaveSystem::add_sea_state()
{
    ssgSimpleState  *sea_state   = NULL ;

  sea_state = new ssgSimpleState () ;
  QString texture=g_prjpath +"data/seawaterfull3.bmp";
  sea_state -> setTexture        ( texture.toAscii().constData() ) ;
  sea_state -> setTranslucent    () ;
  sea_state -> enable            ( GL_TEXTURE_2D ) ;
  sea_state -> setShadeModel     ( GL_SMOOTH ) ;
  sea_state -> enable            ( GL_CULL_FACE ) ;
  sea_state -> enable            ( GL_BLEND ) ;
  sea_state -> enable            ( GL_LIGHTING ) ;
  sea_state -> setColourMaterial ( GL_AMBIENT_AND_DIFFUSE ) ;
  sea_state -> setMaterial       ( GL_EMISSION, 0, 0, 0, 1 ) ;
  sea_state -> setMaterial       ( GL_SPECULAR, 1, 1, 1, 1 ) ;
  sea_state -> setShininess      (  5 ) ;

  return  (sea_state);
}

ssgaWaveTrain* qcWaveSystem::add_wtrains(float Speed, float Length, float Lambda, float Heading, float WaveHeight)
{
    ssgaWaveTrain   *wtrains     = NULL ;

  wtrains = new  ssgaWaveTrain();
  wtrains-> setSpeed      ( Speed  ) ;
  wtrains-> setLength     ( Length ) ;
  wtrains-> setLambda     ( Lambda ) ;
  wtrains-> setHeading    ( Heading ) ;
  wtrains-> setWaveHeight ( WaveHeight ) ;

  return (wtrains);
}
