/***************************************************************************
 *   Copyright (C) 2007 by Anistratov Oleg                                 *
 *   ower86@gmail.com                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation;                         *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 ***************************************************************************/
#ifndef OPTION_H
#define OPTION_H

#include <QVariant>
#include <QString>

/**
	@author Anistratov Oleg <ower86@gmail.com>
*/
class Option
{
  public:
    enum OptionType{int_opt, string_opt, bool_opt, HostAddress_opt};

  private:
    QVariant   m_option;
    QString    m_section;
    OptionType m_type;

  public:
    Option(QVariant o, QString s, OptionType t = int_opt);
    ~Option();

    OptionType type() const {return m_type;}
    QVariant option() const {return m_option;}
    void setOption(const QVariant& opt){m_option = opt;}
    const QString& section() const {return m_section;}

//     Option& operator=(const QVariant& val){m_option = val; return *this;}
};
#endif
