/**********************************************************
 * Version $Id: MLB_Interface.cpp 2304 2014-10-24 08:55:03Z reklov_w $
 *********************************************************/

///////////////////////////////////////////////////////////
//                                                       //
//                         SAGA                          //
//                                                       //
//      System for Automated Geoscientific Analyses      //
//                                                       //
//                    Module Library:                    //
//                  ta_slope_stability                   //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//                   MLB_Interface.cpp                   //
//                                                       //
//                 Copyright (C) 2011 by                 //
//                     Olaf Conrad                       //
//                                                       //
//-------------------------------------------------------//
//                                                       //
// This file is part of 'SAGA - System for Automated     //
// Geoscientific Analyses'. SAGA is free software; you   //
// can redistribute it and/or modify it under the terms  //
// of the GNU General Public License as published by the //
// Free Software Foundation; version 2 of the License.   //
//                                                       //
// SAGA is distributed in the hope that it will be       //
// useful, but WITHOUT ANY WARRANTY; without even the    //
// implied warranty of MERCHANTABILITY or FITNESS FOR A  //
// PARTICULAR PURPOSE. See the GNU General Public        //
// License for more details.                             //
//                                                       //
// You should have received a copy of the GNU General    //
// Public License along with this program; if not,       //
// write to the Free Software Foundation, Inc.,          //
// 51 Franklin Street, 5th Floor, Boston, MA 02110-1301, //
// USA.                                                  //
//                                                       //
//-------------------------------------------------------//
//                                                       //
//    e-mail:     oconrad@saga-gis.de                    //
//                                                       //
//    contact:    Olaf Conrad                            //
//                Institute of Geography                 //
//                University of Hamburg                  //
//                Germany                                //
//                                                       //
///////////////////////////////////////////////////////////

//---------------------------------------------------------


///////////////////////////////////////////////////////////
//														 //
//			The Module Link Library Interface			 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
// 1. Include the appropriate SAGA-API header...

#include "MLB_Interface.h"


//---------------------------------------------------------
// 2. Place general module library informations here...

CSG_String Get_Info(int i)
{
	switch( i )
	{
	case MLB_INFO_Name:	default:
		return(_TL("Slope Stability"));

	case MLB_INFO_Category:
		return( _TL("Terrain Analysis") );

	case MLB_INFO_Author:
		return("A. Gnther (c) 2012");

	case MLB_INFO_Description:
		return(_TW(
			"Tools for slope stability analyses. "
			"Developed by Andreas G&uuml;nther, BGR, B2.2"
		));

	case MLB_INFO_Version:
		return("1.0");

	case MLB_INFO_Menu_Path:
		return(_TL("Terrain Analysis|Slope Stability"));
	}
}


//---------------------------------------------------------
// 3. Include the headers of your modules here...

#include "Safetyfactor_01.h"
#include "TOBIA_01.h"
#include "SHALSTAB_01.h"
#include "WETNESS_01.h"
#include "WEDGEFAIL_01.h"
#include "ANGMAP_01.h"


//---------------------------------------------------------
// 4. Allow your modules to be created here...

CSG_Module *		Create_Module(int i)
{
	switch( i )
	{
	case  0:	return( new CSafetyfactor );
	case  1:	return( new CTOBIA );
	case  2:	return( new CSHALSTAB );
	case  3:	return( new CWETNESS );
	case  4:	return( new CWEDGEFAIL );
	case  5:	return( new CANGMAP );

	case 11:	return( NULL );
	default:	return( MLB_INTERFACE_SKIP_MODULE );
	}
}


///////////////////////////////////////////////////////////
//														 //
//														 //
//														 //
///////////////////////////////////////////////////////////

//---------------------------------------------------------
//{{AFX_SAGA

	MLB_INTERFACE

//}}AFX_SAGA
