// Copyright (C) 1999-2012
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include "fitsimage.h"
#include "nrrdgzip.h"

void FitsImage::initNRRD()
{
  if (compress_)
    delete compress_;
  compress_ = NULL;

  switch (fits_->pNRRDEncoding()) {
  case FitsFile::RAW:
    break;
  case FitsFile::GZIP:
    switch (fits_->pBitpix()) {
    case 8: 
      compress_ = new FitsNRRDGzipm<unsigned char>(fits_);
      break;
    case 16:
      compress_ = new FitsNRRDGzipm<short>(fits_);
      break;
    case -16:
      compress_ = new FitsNRRDGzipm<unsigned short>(fits_);
      break;
    case 32:
      compress_ = new FitsNRRDGzipm<int>(fits_);
      break;
    case 64:
      compress_ = new FitsNRRDGzipm<long long>(fits_);
      break;
    case -32:
      compress_ = new FitsNRRDGzipm<float>(fits_);
      break;
    case -64:
      compress_ = new FitsNRRDGzipm<double>(fits_);
      break;
    }
    break;
  default:
    break;
  }

  return;
}
