// Copyright (C) 1999-2015
// Smithsonian Astrophysical Observatory, Cambridge, MA, USA
// For conditions of distribution and use, see copyright notice in "copyright"

#include <tkInt.h>

#include "colorbartrue.h"
#include "util.h"

ColorbarTrue::ColorbarTrue(Tcl_Interp* i, Tk_Canvas c, Tk_Item* item) 
  : ColorbarBase(i,c,item)
{
}

void ColorbarTrue::updateColors()
{
  updateColorCells();

  // fill in xmap
  // make sure we have a pixmap
  if (!pixmap || !xmap)
    return;

  if (!((ColorbarBaseOptions*)options)->orientation) {
    updateColorsHorz();
    TkPutImage(NULL,0,display, pixmap, gc, xmap, 0, 0, 1, 1, 
	      options->width-2, ((ColorbarBaseOptions*)options)->size-2);
  }
  else {
    updateColorsVert();
    TkPutImage(NULL,0,display, pixmap, gc, xmap, 0, 0, 1, 1, 
	      ((ColorbarBaseOptions*)options)->size-2, options->height-2);
  }

  redraw();
}


